/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.javatools.ui.StatusIndicator;

public class BooleanPropertyComponentWrapper
extends ComponentWrapper<JCheckBox> {
    private final JComponent m_statusComponent;
    private boolean m_onState = true;
    private String m_label;

    public BooleanPropertyComponentWrapper() {
        super(new JCheckBox());
        StatusIndicator indicator = new StatusIndicator();
        indicator.setStatus(StatusIndicator.Status.OK);
        this.m_statusComponent = indicator.configureStandalone(StatusIndicator.OkPolicy.REMOVE);
    }

    @Override
    protected Component getDefaultValidationComponent() {
        return this.m_statusComponent;
    }

    @Override
    protected Component createComponentForLayout() {
        JPanel panel = new JPanel();
        JCheckBox box = (JCheckBox)this.getActiveComponent();
        panel.setName(box.getName() + "_Panel");
        DBUILayoutHelper layout = new DBUILayoutHelper(panel);
        layout.setMargins(0);
        layout.add(this.m_statusComponent);
        layout.add(box, 1, 1, true, false);
        GridBagConstraints statusGbc = layout.getConstraints(this.m_statusComponent);
        GridBagConstraints cboxGbc = layout.getConstraints(box);
        statusGbc.insets.left = 0;
        statusGbc.insets.right = 8;
        cboxGbc.insets.left = 0;
        layout.layout();
        return panel;
    }

    @Override
    public Object getPropertyValue() {
        boolean retval = this.m_onState ? ((JCheckBox)this.getActiveComponent()).isSelected() : !((JCheckBox)this.getActiveComponent()).isSelected();
        return retval;
    }

    @Override
    public void setPropertyValue(Object val) {
        boolean newState;
        JCheckBox box = (JCheckBox)this.getActiveComponent();
        boolean currentState = box.isSelected();
        boolean bl = newState = Boolean.TRUE.equals(val) == this.m_onState;
        if (currentState != newState) {
            box.setSelected(newState);
            Collection allowedValues = this.getProvider().getPropertyManager().getAllowedPropertyValues(this.getOriginalObject(), this.getUpdatedObject(), this.getPropertyName());
            boolean enabled = true;
            if (allowedValues != null) {
                boolean both = allowedValues.contains(true) && allowedValues.contains(false);
                enabled = !allowedValues.contains(val) || both;
            }
            this.setEnabled(enabled);
        }
    }

    @Override
    public JLabel getLabel() {
        if (this.m_label != null) {
            ((JCheckBox)this.getActiveComponent()).setText(this.m_label);
        }
        return null;
    }

    @Override
    protected void initialiseComponentListener() {
        ((JCheckBox)this.getActiveComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BooleanPropertyComponentWrapper.this.fireChangeEvent();
            }
        });
    }

    @Override
    protected void initialiseComponent() {
        super.initialiseComponent();
        String invert = "invert";
        String dispVal = PropertyDisplayRegistry.getPropValueDisplay(this.getPropertyName(), "invert");
        if (!"invert".equals(dispVal)) {
            this.m_onState = false;
            this.m_label = dispVal;
        }
    }
}

