/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import oracle.ideimpl.db.ceditor.PlSqlBreadcrumb;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlStatement;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.token.Token;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModelListener;

final class PlSqlBreadcrumbsModel
implements BreadcrumbsModel {
    private final List<BreadcrumbsModelListener> m_listeners = new LinkedList<BreadcrumbsModelListener>();
    private final ArrayList<Breadcrumb> m_crumbs = new ArrayList();

    PlSqlBreadcrumbsModel() {
    }

    public int getBreadcrumbCount() {
        return this.m_crumbs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Breadcrumb getBreadcrumb(int crumb) {
        ArrayList<Breadcrumb> arrayList = this.m_crumbs;
        synchronized (arrayList) {
            if (crumb < this.getBreadcrumbCount()) {
                return this.m_crumbs.get(crumb);
            }
            return null;
        }
    }

    public void addBreadcrumbsModelListener(BreadcrumbsModelListener l) {
        if (!this.m_listeners.contains(l)) {
            this.m_listeners.add(l);
        }
    }

    public void removeBreadcrumbsModelListener(BreadcrumbsModelListener l) {
        if (this.m_listeners.contains(l)) {
            this.m_listeners.remove(l);
        }
    }

    public boolean hasChildren(Breadcrumb breadcrumb) {
        return ((PlSqlBreadcrumb)breadcrumb).canHavePopupItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(PlSqlCodeFragment frag, PlSqlParser parser) throws CancelledException {
        ArrayList<Breadcrumb> arrayList = this.m_crumbs;
        synchronized (arrayList) {
            this.m_crumbs.clear();
            try {
                while (frag != null) {
                    String[] texts = this.getText(frag, parser);
                    if (texts[0] != null) {
                        String extra;
                        String main = texts[0];
                        String tooltip = texts[2];
                        String string = extra = this.m_crumbs.size() < 3 ? texts[1] : "";
                        if (extra != null && extra.length() > 40) {
                            extra = "";
                        }
                        PlSqlBreadcrumb crumb = new PlSqlBreadcrumb(main, extra, frag.getStartOffset(), frag, tooltip);
                        this.m_crumbs.add(0, crumb);
                    }
                    frag = (PlSqlCodeFragment)frag.getParent();
                }
                return true;
            }
            catch (ExpiredTextBufferException e) {
                this.m_crumbs.clear();
            }
        }
        return false;
    }

    private String[] getText(PlSqlCodeFragment frag, PlSqlParser parser) throws CancelledException {
        PlSqlToken tk = parser.getTokenAtOffset(frag.getStartOffset().intValue());
        String[] ret = new String[3];
        if (frag instanceof PlSqlStatement) {
            if (frag instanceof SchemaObject) {
                ret[0] = frag.getName();
                tk = parser.getNameToken();
            } else if (frag instanceof PlSqlSubProgram) {
                while (!(tk.getStart() >= frag.getEndOffset() || tk.matches("PROCEDURE") || tk.matches("FUNCTION") || tk.matches("CURSOR"))) {
                    tk = (PlSqlToken)tk.getNextCodeToken();
                }
                if (tk.matches("PROCEDURE") || tk.matches("FUNCTION") || tk.matches("CURSOR")) {
                    tk = (PlSqlToken)tk.getNextCodeToken();
                }
                ret[0] = tk.getSource(true);
            } else {
                PlSqlStatement.Type type = ((PlSqlStatement)frag).getStatementType();
                if (type != null) {
                    String endKw = null;
                    switch (type) {
                        case IF: 
                        case ELSIF: {
                            endKw = "THEN";
                            break;
                        }
                        case FOR_LOOP: 
                        case WHILE_LOOP: {
                            endKw = "LOOP";
                            break;
                        }
                    }
                    if (endKw != null) {
                        PlSqlToken tkNext;
                        PlSqlToken tk2;
                        ret[0] = tk.getSource().toLowerCase();
                        PlSqlToken tk3 = tk2 = (PlSqlToken)tk.getNextCodeToken();
                        while (!tk3.matches(endKw) && (tkNext = (PlSqlToken)tk3.getNextCodeToken()) != null && !tkNext.isEndMarker()) {
                            tk3 = tkNext;
                        }
                        ret[1] = " " + tk2.getSource(true, (Token)tk3).toLowerCase();
                        ret[2] = tk.getSource(false, (Token)tk3);
                    }
                } else {
                    PlSqlToken tk3 = parser.getTokenAtOffset(frag.getEndOffset().intValue());
                    ret[0] = tk.getSource(true).toLowerCase();
                    ret[1] = null;
                    ret[2] = tk.getSource(false, (Token)tk3);
                }
            }
        }
        return ret;
    }

    public void dispose() {
        this.m_crumbs.clear();
    }

    void fireBreadcrumbsUpdated() {
        for (BreadcrumbsModelListener l : this.m_listeners) {
            l.breadcrumbsUpdated();
        }
    }
}

