/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.AsynchronousController;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.db.compiler.PlSqlCompiler;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.db.util.IconWithSmallOverlay;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.view.View;
import oracle.ideimpl.db.ceditor.DBEditorConnectionProvider;
import oracle.ideimpl.db.controls.AbstractLazyCombo;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Database;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.plsql.PlSqlCompilerOptions;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;

public class DBEditorConnectionPlugin
implements EditorPlugin {
    private static final int COMPILE_NODEBUG_COMMAND = Ide.findOrCreateCmdID((String)"DBEditorConnectionPlugin.COMPILE");
    private static final int COMPILE_DEBUG_COMMAND = Ide.findOrCreateCmdID((String)"DBEditorConnectionPlugin.COMPILE_DEBUG");
    private static final int COMPILE_COMMAND = Ide.findOrCreateCmdID((String)"DBEditorConnectionPlugin.COMPILE_COMMAND");
    private final LazyConnectionCombo m_picker = new LazyConnectionCombo();
    private final Controller m_controller;
    private final NodeListener m_nodeListener;
    private final DBEditorConnectionProvider.ConnectionProviderListener m_connListener;
    private CodeEditor m_ceditor;
    private Toolbar m_toolbar;
    private Node m_node;
    private ActionMenuToolButton m_compileButton;
    private IdeAction m_compileAction;
    private IdeAction m_compileDebugAction;
    private IdeAction m_compileNoDebugAction;

    public DBEditorConnectionPlugin() {
        this.m_picker.setName("DBEditorConnectionPlugin.m_picker");
        this.m_picker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBEditorConnectionProvider.setURLConnection(DBEditorConnectionPlugin.this.m_node.getURL(), (String)DBEditorConnectionPlugin.this.m_picker.getSelectedItem(), true);
                DBEditorConnectionPlugin.this.updateConnectionToolbar();
            }
        });
        this.m_nodeListener = new NodeListener(){

            public void nodeSaved(NodeEvent e) {
                DBEditorConnectionPlugin.this.compile(DBEditorConnectionPlugin.this.m_ceditor.getContext());
            }
        };
        this.m_connListener = new DBEditorConnectionProvider.ConnectionProviderListener(){

            @Override
            public void connectionsChanged() {
                DBEditorConnectionPlugin.this.m_picker.resetCombo();
            }
        };
        this.m_controller = new AsyncController();
    }

    public void install(BasicEditorPane editor) {
        this.m_ceditor = CodeEditor.getCodeEditor((BasicEditorPane)editor);
        this.m_node = this.m_ceditor.getContext().getNode();
        this.m_toolbar = this.m_ceditor.getToolbar();
        this.m_compileAction = this.createLocalAction(COMPILE_COMMAND, (View)this.m_ceditor, UIBundle.get("PLSQL_COMPILE"), this.getIcon(false));
        this.m_compileNoDebugAction = this.createLocalAction(COMPILE_NODEBUG_COMMAND, (View)this.m_ceditor, UIBundle.get("PLSQL_COMPILE"), this.getIcon(false));
        this.m_compileDebugAction = this.createLocalAction(COMPILE_DEBUG_COMMAND, (View)this.m_ceditor, UIBundle.get("PLSQL_COMPILE_FOR_DEBUG"), this.getIcon(true));
        this.m_compileButton = new ActionMenuToolButton((Action)this.m_compileAction);
        this.m_compileButton.setMenuActions((Action[])new IdeAction[]{this.m_compileNoDebugAction, this.m_compileDebugAction});
        this.m_toolbar.addSeparator();
        this.m_toolbar.add((Component)this.m_compileButton);
        this.m_toolbar.add(Box.createHorizontalGlue());
        this.m_toolbar.add((Component)this.m_picker);
        this.m_node.addNodeListener(this.m_nodeListener);
        DBEditorConnectionProvider pro = DBEditorConnectionProvider.getInstance();
        pro.addConnectionsListener(this.m_ceditor.getContext(), this.m_connListener);
        String conn = DBEditorConnectionProvider.getDefaultConnection(this.m_node.getURL());
        if (conn != null) {
            this.m_picker.setIfInList(conn);
        }
        this.updateConnectionToolbar();
    }

    public void deinstall(BasicEditorPane editor) {
        DBEditorConnectionProvider pro = DBEditorConnectionProvider.getInstance();
        if (pro != null) {
            pro.removeConnectionsListener(this.m_ceditor.getContext(), this.m_connListener);
        }
        this.m_node.removeNodeListener(this.m_nodeListener);
        DBEditorConnectionProvider.setURLConnection(this.m_node.getURL(), null, false);
        this.m_compileAction.removeController(this.m_controller);
        this.m_compileNoDebugAction.removeController(this.m_controller);
        this.m_compileDebugAction.removeController(this.m_controller);
        this.m_ceditor = null;
        this.m_toolbar = null;
        this.m_node = null;
        this.m_compileAction = null;
        this.m_compileNoDebugAction = null;
        this.m_compileDebugAction = null;
        this.m_compileButton = null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    private void updateConnectionToolbar() {
        if (this.m_compileButton != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                boolean debugInfo;
                GlobalSettings settings = GlobalSettings.getInstance();
                PlSqlCompilerOptions opts = settings == null ? null : settings.getPlSqlCompilerOptions();
                boolean bl = debugInfo = opts != null && opts.isGeneratePlSqlDebugInfo();
                if (debugInfo) {
                    this.m_compileButton.setToolTipText(UIBundle.get("PLSQL_COMPILE_FOR_DEBUG"));
                } else {
                    this.m_compileButton.setToolTipText(UIBundle.get("PLSQL_COMPILE"));
                }
                this.m_compileButton.setIcon(this.getIcon(debugInfo));
                if (this.m_ceditor != null && this.m_toolbar != null) {
                    CodeEditor.updateToolbarActions((Toolbar)this.m_toolbar);
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DBEditorConnectionPlugin.this.updateConnectionToolbar();
                    }
                });
            }
        }
    }

    private IdeAction createLocalAction(int cmd, View view, String name, Icon icon) {
        IdeAction.get((int)cmd);
        IdeAction action = IdeAction.newLocalAction((int)cmd, (View)view);
        action.putValue("Name", (Object)name);
        action.putValue("SmallIcon", (Object)icon);
        action.setEnabled(false);
        action.addController(this.m_controller);
        return action;
    }

    private void compile(Context context) {
        Database db = DBEditorConnectionProvider.getCurrentDatabase(context);
        Node node = context.getNode();
        if (db instanceof OracleDatabase && node instanceof DBObjectPlSqlNode) {
            PlSqlCompiler compiler = PlSqlCompiler.getInstance();
            compiler.compile((OracleDatabase)db, (DBObjectPlSqlNode)node);
        }
    }

    private Icon getIcon(boolean debug) {
        if (debug) {
            return new IconWithSmallOverlay(OracleIcons.getIcon((String)"generatedbobject.png"), OracleIcons.getIcon((String)"debug.png"), 12, 12, 0, 5);
        }
        return OracleIcons.getIcon((String)"generatedbobject.png");
    }

    private class AsyncController
    extends AsynchronousController {
        AsyncController() {
            super(false);
        }

        public boolean handleEvent(IdeAction action, Context context) {
            this.handleAsynchronously(action, context);
            return true;
        }

        protected void handleEvent(IdeAction action, Context context, AsynchronousController.TaskInfo taskInfo) {
            int cmdId = action.getCommandId();
            if (cmdId == COMPILE_COMMAND) {
                DBEditorConnectionPlugin.this.compile(context);
            } else if (cmdId == COMPILE_NODEBUG_COMMAND || cmdId == COMPILE_DEBUG_COMMAND) {
                GlobalSettings settings = GlobalSettings.getInstance();
                if (settings != null) {
                    PlSqlCompilerOptions opts = settings.getPlSqlCompilerOptions();
                    if (opts != null) {
                        opts.setGeneratePlSqlDebugInfo(cmdId == COMPILE_DEBUG_COMMAND);
                    }
                    DBEditorConnectionPlugin.this.updateConnectionToolbar();
                }
                DBEditorConnectionPlugin.this.compile(context);
            }
        }

        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == COMPILE_COMMAND || cmdId == COMPILE_NODEBUG_COMMAND || cmdId == COMPILE_DEBUG_COMMAND) {
                action.setEnabled(DBEditorConnectionProvider.hasCurrentDatabase(context.getNode()));
                return true;
            }
            return false;
        }
    }

    private class LazyConnectionCombo
    extends AbstractLazyCombo {
        private LazyConnectionCombo() {
        }

        @Override
        protected Icon getIcon(Object value) {
            return OracleIcons.getIcon((String)"database.png");
        }

        @Override
        public String getNullText() {
            return UIBundle.get("EDITOR_NO_CONNECTION");
        }

        @Override
        protected List getModelEntries() {
            ArrayList<String> retval = new ArrayList<String>();
            DBEditorConnectionProvider pro = DBEditorConnectionProvider.getInstance();
            if (DBEditorConnectionPlugin.this.m_ceditor != null && pro != null) {
                retval.addAll(pro.getAvailableConnections(DBEditorConnectionPlugin.this.m_ceditor.getContext()));
            }
            return retval;
        }

        private void setIfInList(String conn) {
            this.loadModel();
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
            int index = model.getIndexOf(conn);
            if (index == -1) {
                index = 0;
            }
            this.setSelectedIndex(index);
        }

        private void resetCombo() {
            this.reset();
        }
    }
}

