/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.awt.Component;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.ModelUtil;

public class DBUIResourceHelper {
    private final String m_panelName;

    public DBUIResourceHelper(String panelName) {
        this.m_panelName = panelName;
    }

    public String getPanelName() {
        return this.m_panelName;
    }

    public void resLabel(JLabel label, Component labelFor, String labelText, String componentName) {
        ResourceUtils.resLabel((JLabel)label, (Component)labelFor, (String)labelText);
        this.setName(labelFor, componentName);
    }

    public void resButton(AbstractButton button, String labelText, String componentName) {
        ResourceUtils.resButton((AbstractButton)button, (String)labelText);
        this.setName(button, componentName);
    }

    public void resIconicButton(AbstractButton button, Icon icon, String toolTipText, String componentName) {
        button.setIcon(icon);
        IconicButtonUI.install((AbstractButton)button);
        int idx = StringUtils.getMnemonicIndex((String)toolTipText);
        if (idx >= 0) {
            String stripped = StringUtils.stripMnemonic((String)toolTipText);
            char mnemonic = stripped.charAt(idx);
            button.setMnemonic(mnemonic);
            StringBuilder builder = new StringBuilder();
            builder.append("<html>");
            builder.append(stripped.substring(0, idx));
            builder.append("<u>");
            builder.append(mnemonic);
            builder.append("</u>");
            builder.append(stripped.substring(idx + 1));
            builder.append("</html>");
            button.setToolTipText(builder.toString());
        } else {
            button.setToolTipText(toolTipText);
        }
        this.setName(button, componentName);
    }

    public void setName(Component comp, String compName) {
        if (comp instanceof JScrollPane) {
            this.setName(((JScrollPane)comp).getViewport().getView(), compName);
            compName = compName + "ScrollPane";
        }
        if (comp != null) {
            StringBuilder sb = new StringBuilder(this.m_panelName);
            if (ModelUtil.hasLength((String)this.m_panelName) && !this.m_panelName.endsWith(".")) {
                sb.append(".");
            }
            sb.append(compName);
            comp.setName(sb.toString());
        }
    }

    public static String createPropertiesText(Map<String, String> props) {
        String SEP = " ";
        String BR = "<br/>";
        StringBuilder buff = new StringBuilder();
        buff.append("<html>");
        for (Map.Entry<String, String> entry : props.entrySet()) {
            buff.append(entry.getKey());
            buff.append(" ");
            String value = entry.getValue();
            if (value != null) {
                buff.append((Object)value);
            }
            buff.append("<br/>");
        }
        buff.append("</html>");
        return buff.toString();
    }
}

