/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql.tester;

import oracle.ide.db.panels.sql.tester.MessageTesterComponent;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabase;

class DCNTesterComponent
extends MessageTesterComponent {
    DCNTesterComponent() {
        super("DCNTesterComponent", UIBundle.get("TESTSQL_DCN_LABEL"));
    }

    @Override
    public void testSQL(Database db, String sqlQuery) {
        if (db instanceof OracleDatabase && ((OracleDatabase)db).supportsDatabaseChangeNotification()) {
            this.runTest(db, sqlQuery);
        } else {
            this.setMessageText(UIBundle.get("TESTSQL_DCN_UNSUPPORTED"));
        }
    }

    @Override
    protected void doTestSQL(Database db, String sqlQuery) {
        String msg;
        try {
            msg = ((OracleDatabase)db).isDatabaseChangeNotificationCompatible(sqlQuery, true, true) ? UIBundle.get("TESTSQL_DCN_COMPAT") : UIBundle.get("TESTSQL_DCN_INCOMPAT");
        }
        catch (DBException dbe) {
            msg = dbe.getMessage();
        }
        this.setMessageText(msg);
    }

    @Override
    public String getName() {
        return UIBundle.get("TESTSQL_DCN");
    }
}

