/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.model;

import java.net.URL;
import java.util.logging.Level;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.db.DBURLFactory;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.ConnectionStoreNode;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ideimpl.db.model.DatabaseNodeRecognizer;
import oracle.ideimpl.db.model.ProviderNodeRecognizer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.ModelUtil;

public final class DBObjectNodeUtil {
    private DBObjectNodeUtil() {
    }

    public static DBObjectProvider findProvider(Object node) {
        Object ident;
        String type;
        DBObjectProvider retval = null;
        ProviderNodeRecognizer<Object> r = ProviderNodeRecognizer.findRecognizer(node);
        if (r != null && (type = r.getProviderType(node)) != null && (ident = r.getProviderIdentifier(node)) != null) {
            retval = DBObjectProviderFactory.findProvider((String)type, (Object)ident);
        }
        return retval;
    }

    public static String getProviderType(Object node) {
        String retval = null;
        ProviderNodeRecognizer<Object> r = ProviderNodeRecognizer.findRecognizer(node);
        if (r != null) {
            retval = r.getProviderType(node);
        }
        return retval;
    }

    public static Object getProviderIdentifier(Object node) {
        Object retval = null;
        ProviderNodeRecognizer<Object> r = ProviderNodeRecognizer.findRecognizer(node);
        if (r != null) {
            retval = r.getProviderIdentifier(node);
        }
        return retval;
    }

    public static boolean isConnectionNode(Object node) {
        boolean retval = false;
        DatabaseNodeRecognizer<Object> r = DatabaseNodeRecognizer.findRecognizer(node);
        if (r != null) {
            retval = r.isConnectionNode(node);
        }
        return retval;
    }

    public static boolean isStoreNode(Object node) {
        boolean retval = false;
        DatabaseNodeRecognizer<Object> r = DatabaseNodeRecognizer.findRecognizer(node);
        if (r != null) {
            retval = r.isStoreNode(node);
        }
        return retval;
    }

    public static boolean isNodeOfType(String type, Object node) {
        if (node instanceof DBObjectNode) {
            return type.equals(DBObjectNodeUtil.normalizeType((DBObjectNode)node));
        }
        return false;
    }

    public static boolean isOnlineNodeOfType(String type, Object node) {
        if (DBObjectNodeUtil.isNodeOfType(type, node)) {
            return DBObjectNodeUtil.isOnlineNode(node);
        }
        return false;
    }

    public static boolean isOnlineNode(Object node) {
        return "db".equals(DBObjectNodeUtil.getProviderType(node));
    }

    public static boolean isRelationNode(Object node) {
        if (node instanceof DBObjectNode) {
            String type = ((DBObjectNode)node).getObjectType();
            return "TABLE".equals(type) || "VIEW".equals(type) || "MATERIALIZED VIEW".equals(type);
        }
        return false;
    }

    public static boolean isRelationNode(Object node, boolean unwrapSynonym) {
        if (unwrapSynonym && DBObjectNodeUtil.isSynonymNode(node)) {
            try {
                DBObjectID refID;
                DBObject syn = ((DBObjectNode)node).getDBObject();
                if (syn instanceof Synonym && (refID = ((Synonym)syn).getReference()) != null) {
                    DBObject refObj = refID.resolveID();
                    return refObj instanceof Relation;
                }
            }
            catch (DBException e) {
                DBLog.getLogger().log(Level.WARNING, "Could not unwrap Synonym : " + e.getMessage());
            }
        }
        return DBObjectNodeUtil.isRelationNode(node);
    }

    public static boolean isSynonymNode(Object node) {
        if (node instanceof DBObjectNode) {
            String type = ((DBObjectNode)node).getObjectType();
            return "SYNONYM".equals(type) || "PUBLIC_SYNONYM".equals(type);
        }
        return false;
    }

    public static boolean isOnlineRelationNode(Object node) {
        if (DBObjectNodeUtil.isRelationNode(node)) {
            return DBObjectNodeUtil.isOnlineNode(node);
        }
        return false;
    }

    public static boolean isOnlineRelationNode(Object node, boolean unwrapSynonym) {
        if (DBObjectNodeUtil.isRelationNode(node, unwrapSynonym)) {
            return DBObjectNodeUtil.isOnlineNode(node);
        }
        return false;
    }

    public static String getStoreName(Object node) {
        String retval = null;
        if (node instanceof ConnectionStoreNode) {
            retval = ((ConnectionStoreNode)node).getStoreName();
        } else {
            DatabaseNodeRecognizer<Object> r = DatabaseNodeRecognizer.findRecognizer(node);
            if (r != null) {
                retval = r.getStoreName(node);
            }
        }
        return retval;
    }

    public static String getConnectionName(Object node) {
        String retval = null;
        DatabaseNodeRecognizer<Object> r = DatabaseNodeRecognizer.findRecognizer(node);
        if (r != null) {
            retval = r.getConnectionName(node);
        }
        return retval;
    }

    public static <T extends Element> T getSelectedElement(Context context, Class<T> clz) {
        Element[] selection;
        T retval = null;
        if (context != null && (selection = context.getSelection()) != null && selection.length == 1) {
            retval = DBObjectNodeUtil.getElementOfType(selection[0], clz);
        }
        return retval;
    }

    public static <T extends Element> T getElementOfType(Element elem, Class<T> clz) {
        Element retval = null;
        if (elem != null) {
            if (clz.isAssignableFrom(elem.getClass())) {
                retval = elem;
            } else {
                URL[] compositeURLs = CompositeFileElementRegistry.getCompositeFileURLs((Element)elem);
                if (compositeURLs != null) {
                    for (URL url : compositeURLs) {
                        Node composite = NodeFactory.find((URL)url);
                        if (composite == null || !clz.isAssignableFrom(composite.getClass())) continue;
                        retval = composite;
                        break;
                    }
                }
            }
        }
        return (T)retval;
    }

    public static Element getTreeNodeElement(Object treeNode) {
        Object obj;
        Element retval = null;
        if (treeNode instanceof TNode) {
            retval = ((TNode)treeNode).getData();
        } else if (treeNode instanceof DefaultMutableTreeNode && (obj = ((DefaultMutableTreeNode)treeNode).getUserObject()) instanceof Element) {
            retval = (Element)obj;
        }
        return retval;
    }

    public static Schema getSchema(DBObjectTypeNode node, boolean defaultIfNone) {
        Schema schema = null;
        try {
            DBObjectProvider pro = DBObjectProviderFactory.findOrCreateProvider((String)node.getProviderType(), (Object)node.getProviderIdentifier());
            if (pro != null) {
                String schemaName = DBObjectNodeUtil.getSchemaName(node);
                if (ModelUtil.hasLength((String)schemaName)) {
                    schema = new Schema(schemaName);
                }
                if (schema == null && defaultIfNone) {
                    schema = pro.getDefaultSchema();
                }
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return schema;
    }

    public static String getSchemaName(DBObjectTypeNode node) {
        String normalizedType;
        String retval = node.getSchemaName();
        String nodeType = node.getObjectType();
        if (ModelUtil.areDifferent((Object)nodeType, (Object)(normalizedType = DBObjectNodeUtil.normalizeType(node))) && nodeType.contains("PUBLIC")) {
            retval = "PUBLIC";
        }
        return retval == null ? null : retval.trim();
    }

    public static String normalizeType(DBObjectTypeNode node) {
        return node == null ? null : DBObjectNodeUtil.normalizeType(node.getObjectType());
    }

    public static String normalizeType(String type) {
        String retval = type;
        if (retval != null) {
            if (retval.startsWith("PUBLIC_")) {
                retval = retval.replaceFirst("PUBLIC_", "");
            } else if (retval.startsWith("PUBLIC ")) {
                retval = retval.replaceFirst("PUBLIC ", "");
            } else if (retval.equals("ALIASES")) {
                retval = "ALIAS";
            }
        }
        return retval;
    }

    public static boolean containsDBObject(Object node) {
        boolean retval = false;
        ProviderNodeRecognizer<Object> r = ProviderNodeRecognizer.findRecognizer(node);
        if (r != null) {
            retval = r.isDBObjectNode(node);
        }
        return retval;
    }

    public static DBObject getDBObject(Object node) {
        DBObject retval = null;
        ProviderNodeRecognizer<Object> r = ProviderNodeRecognizer.findRecognizer(node);
        if (r != null) {
            retval = r.getDBObject(node);
        }
        return retval;
    }

    public static BaseDBObjectTextNode getCompanionNode(PlSqlSchemaObject obj, DBObjectProvider pro) {
        URL companionObjectURL;
        PlSqlSchemaObject otherObject = null;
        if (pro instanceof Database) {
            String otherType = PlSqlUtil.getCompanionObjectType((PlSqlSchemaObject)obj);
            if (otherType != null) {
                try {
                    otherObject = (PlSqlSchemaObject)Metadata.getInstance().getObjectClass(otherType).newInstance();
                    otherObject.setSchema(obj.getSchema());
                    otherObject.setName(obj.getName());
                }
                catch (Exception exception) {}
            }
        } else {
            otherObject = PlSqlUtil.getCompanionObject((PlSqlSchemaObject)obj, (DBObjectProvider)pro);
        }
        if (otherObject != null && (companionObjectURL = DBURLFactory.getURL(pro, (SystemObject)otherObject)) != null) {
            return (BaseDBObjectTextNode)NodeFactory.find((URL)companionObjectURL);
        }
        return null;
    }

    public static BaseDBObjectTextNode getNodeFromEditorPane(BasicEditorPane editor) {
        Node node;
        BaseDBObjectTextNode ret = null;
        CodeEditor ceditor = CodeEditor.getCodeEditor((BasicEditorPane)editor);
        if (ceditor != null && (node = ceditor.getContext().getNode()) instanceof BaseDBObjectTextNode) {
            ret = (BaseDBObjectTextNode)node;
        }
        return ret;
    }
}

