/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.ide.db.insight.model.ColumnInsightDataProvider;
import oracle.ide.db.insight.model.DBInsightContext;
import oracle.ide.db.insight.model.DBInsightData;
import oracle.ide.db.insight.model.DataTypeProvider;
import oracle.ide.db.insight.model.DeclarativeSQLQueryParentLocator;
import oracle.ide.db.insight.model.FunctionProvider;
import oracle.ide.db.insight.model.InsightDataProvider;
import oracle.ide.db.insight.model.ParentLocator;
import oracle.ide.db.insight.model.PlSqlInsightDataProvider;
import oracle.ide.db.insight.model.ReservedWordInsightDataProvider;
import oracle.ide.db.insight.model.SQLFromObjectProvider;
import oracle.ide.db.insight.model.SQLParentLocator;
import oracle.ide.db.insight.model.SchemaObjectInsightDataProvider;
import oracle.ide.db.insight.model.SchemaProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlIdentifier;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.PlSqlVariable;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.token.Token;

public final class DBInsightProvider {
    private final DBInsightContext m_insightContext;
    private final Class<? extends ParentLocator> m_parentLocatorClass;
    private final List<Class<? extends InsightDataProvider>> m_insightDataProviderClasses;
    private Map<String, DBInsightData> m_data;
    private Boolean m_makeLower;
    private String m_searchString;
    private int m_replacementStart;
    private int m_replacementEnd;
    private DBObjectProvider m_pro;
    private String m_text;
    private Schema m_schema;
    private Integer m_offset;
    private Class<? extends DBObject> m_targetObjectClass;
    private Class<? extends DBObject> m_parentScopeClass;
    private DBObject m_contextObjectAtOffset;
    private String m_language;
    private boolean m_userOnly;

    public DBInsightProvider(DBInsightContext insightContext) throws CancelledException {
        this(insightContext, null, null);
    }

    public DBInsightProvider(DBInsightContext insightContext, Class<? extends ParentLocator> parentLocatorClass, List<Class<? extends InsightDataProvider>> insightDataProviderClasses) throws CancelledException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Cannot request insight on EDT");
        }
        if (insightContext == null) {
            throw new IllegalArgumentException("No context");
        }
        if (insightContext.getProvider() == null) {
            throw new IllegalArgumentException("No DBObjectProvider in the context");
        }
        if (insightContext.getText() == null) {
            throw new IllegalArgumentException("No text in the context");
        }
        this.m_insightContext = insightContext;
        this.m_parentLocatorClass = parentLocatorClass;
        this.m_insightDataProviderClasses = insightDataProviderClasses;
        this.init();
    }

    private synchronized void init() throws CancelledException {
        boolean parentContextSet;
        ParentLocator parentLocator;
        Object startTk;
        PlSqlParser parser;
        PlSqlSourceObject contextPlSqlSourceObject;
        Integer offset;
        Integer end;
        Boolean userOnly;
        this.m_data = new HashMap<String, DBInsightData>();
        this.m_pro = this.m_insightContext.getProvider();
        this.m_targetObjectClass = this.m_insightContext.getTargetObjectClass();
        this.m_parentScopeClass = this.m_insightContext.getParentScopeClass();
        this.m_language = this.m_insightContext.getLanguage();
        if (this.m_language == null) {
            this.m_language = "SQL";
        }
        this.m_userOnly = (userOnly = this.m_insightContext.getUserOnly()) == null ? this.m_pro instanceof Database : userOnly;
        this.m_searchString = "";
        if (this.m_insightContext.getSchema() != null) {
            this.m_schema = this.m_insightContext.getSchema();
        } else {
            Schema s = null;
            try {
                s = this.m_pro.getDefaultSchema();
            }
            catch (CancelledException ce) {
                throw ce;
            }
            catch (DBException e) {
                s = null;
            }
            this.m_schema = s;
        }
        Integer start = this.m_insightContext.getRangeStart();
        if (start == null) {
            start = 0;
        }
        if ((end = this.m_insightContext.getRangeEnd()) == null) {
            end = this.m_insightContext.getText().length();
        }
        this.m_text = this.m_insightContext.getText().substring(start, end);
        String EOL = System.getProperty("line.separator");
        if (EOL.length() > 1 && this.m_text.contains(EOL)) {
            this.m_text = this.m_text.replace(EOL, "\n");
        }
        this.m_offset = (offset = this.m_insightContext.getSearchOffset()) == null ? end : offset;
        if (this.m_offset < start || this.m_offset > end) {
            throw new IllegalStateException("offset not within the specied range");
        }
        DBObject givenContextObject = this.m_insightContext.getContextObject();
        DBObject contextObjectAtOffset = givenContextObject;
        if (contextObjectAtOffset == null) {
            PlSqlSourceObject so = null;
            try {
                String schemaName = this.m_schema == null ? null : this.m_schema.getName();
                PlSqlIdentifier pid = PlSqlIdentifier.getPlSqlIdentifier((String)this.m_text, (String)schemaName, (boolean)false);
                if (pid != null && pid.getPlsqlType() != null) {
                    so = (PlSqlSourceObject)this.m_pro.getObjectFactory().newObject(Metadata.getInstance().getObjectClass(pid.getPlsqlType().toString()));
                    so.setSource(this.m_text);
                    so.setSchema(this.m_schema);
                }
            }
            catch (Exception e) {
                so = null;
            }
            contextObjectAtOffset = so;
        }
        PlSqlToken tkLeftOfCursor = null;
        PlSqlToken parentTk = null;
        if (contextObjectAtOffset instanceof PlSqlSourceObject) {
            contextPlSqlSourceObject = (PlSqlSourceObject)contextObjectAtOffset;
            parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)contextPlSqlSourceObject, (DBObjectProvider)this.m_pro);
            startTk = parser != null ? parser.getTokenAtOffset(0) : null;
        } else {
            contextPlSqlSourceObject = null;
            parser = null;
            startTk = PlSqlTokenizer.tokenize((String)this.m_text, (String[])new String[0]);
        }
        if (startTk == null) {
            this.m_replacementStart = this.m_offset;
            this.m_replacementEnd = this.m_offset;
        } else {
            PlSqlToken tkRightOfCursor;
            PlSqlToken prevCodeTok;
            tkLeftOfCursor = (PlSqlToken)startTk.getTokenAt(this.m_offset - start - 1);
            if (this.m_offset - start >= this.m_text.length()) {
                prevCodeTok = tkLeftOfCursor;
                tkRightOfCursor = (PlSqlToken)prevCodeTok.getNextToken();
            } else {
                tkRightOfCursor = (PlSqlToken)startTk.getTokenAt(this.m_offset - start);
                prevCodeTok = (PlSqlToken)tkRightOfCursor.getPrevCodeToken();
            }
            if (prevCodeTok.matches("%")) {
                parentTk = (PlSqlToken)prevCodeTok.getPrevCodeToken();
                this.m_replacementStart = parentTk.getStart() + start;
                this.m_replacementEnd = prevCodeTok.getEnd() + start + 1;
                if (((PlSqlToken)prevCodeTok.getNextToken()).isCode(true)) {
                    this.m_replacementEnd = ((PlSqlToken)prevCodeTok.getNextToken()).getEnd() + start + 1;
                }
            } else if (tkLeftOfCursor != null && tkLeftOfCursor.isWord()) {
                String userString;
                this.m_replacementStart = tkLeftOfCursor.getStart() + start;
                this.m_replacementEnd = tkLeftOfCursor.getEnd() + start + 1;
                if (((PlSqlToken)tkLeftOfCursor.getNextToken()).matches("%")) {
                    this.m_replacementEnd = ((PlSqlToken)tkLeftOfCursor.getNextToken()).getEnd() + start + 1;
                    if (((PlSqlToken)((PlSqlToken)tkLeftOfCursor.getNextToken()).getNextToken()).isCode(true)) {
                        this.m_replacementEnd = ((PlSqlToken)((PlSqlToken)tkLeftOfCursor.getNextToken()).getNextToken()).getEnd() + start + 1;
                    }
                }
                this.m_searchString = (userString = this.m_text.substring(this.m_replacementStart - start, this.m_offset - start)).startsWith("\"") ? userString.substring(1) : this.m_pro.getInternalName(userString);
                if (((PlSqlToken)tkLeftOfCursor.getPrevCodeToken()).matches(".")) {
                    parentTk = (PlSqlToken)((PlSqlToken)tkLeftOfCursor.getPrevCodeToken()).getPrevCodeToken();
                }
            } else {
                if (tkRightOfCursor.isWord()) {
                    this.m_replacementStart = tkRightOfCursor.getStart() + start;
                    this.m_replacementEnd = tkRightOfCursor.getEnd() + start + 1;
                } else {
                    this.m_replacementStart = this.m_offset;
                    this.m_replacementEnd = this.m_offset;
                }
                if (prevCodeTok.matches(".")) {
                    parentTk = (PlSqlToken)prevCodeTok.getPrevCodeToken();
                }
            }
        }
        if (tkLeftOfCursor != null) {
            Token.Type tokType = tkLeftOfCursor.getType();
            if (tkLeftOfCursor.matches("..") || tokType == Token.Type.MULTI_LINE_COMMENT || tokType == Token.Type.SINGLE_LINE_COMMENT || tokType == Token.Type.SINGLE_QUOTED_STRING) {
                return;
            }
        }
        if (contextPlSqlSourceObject != null) {
            if (parser == null || parser.getEndOffsetOfObject() <= this.m_offset) {
                return;
            }
            this.m_contextObjectAtOffset = ((DBObjectPlSqlFragment)contextPlSqlSourceObject).getChildAtOffset(this.m_offset.intValue());
            if (this.m_targetObjectClass == null) {
                DBObject f;
                for (f = this.m_contextObjectAtOffset; f != null && !(f instanceof PlSqlCodeFragment); f = f.getParent()) {
                }
                if (f instanceof PlSqlCodeFragment) {
                    DBObjectPlSqlFragment decl;
                    PlSqlToken tk;
                    int startOffset = ((PlSqlCodeFragment)f).getStartOffset();
                    int endOffset = ((PlSqlCodeFragment)f).getEndOffset();
                    PlSqlToken nodeStartTk = parser.getTokenAtOffset(startOffset);
                    PlSqlToken tk2 = tk = parser.getTokenAtOffset(this.getOffset() - 1);
                    if (tk.getStart() > startOffset && tk.matches(".")) {
                        tk2 = (PlSqlToken)tk.getPrevCodeToken();
                    }
                    while (((PlSqlToken)tk2.getPrevCodeToken()).matches(".") && tk2.getStart() >= startOffset) {
                        tk2 = (PlSqlToken)((PlSqlToken)tk2.getPrevCodeToken()).getPrevCodeToken();
                    }
                    tk = tk2;
                    if (tk != nodeStartTk && (decl = ((DBObjectPlSqlFragment)contextPlSqlSourceObject).getDeclarationAtOffset(this.m_offset.intValue())) != null) {
                        if (decl instanceof PlSqlParameter) {
                            this.m_targetObjectClass = DataType.class;
                        } else if (decl instanceof PlSqlVariable) {
                            this.m_targetObjectClass = DataTypeUsage.class;
                        } else if ("STATEMENT".equals(decl.getType())) {
                            this.m_targetObjectClass = DBObject.class;
                            PlSqlSearch intoSearch = new PlSqlSearch("{SELECT|WITH} {^INTO}... <into INTO>");
                            PlSqlToken nodeEndTk = parser.getTokenAtOffset(endOffset);
                            if (intoSearch.matches(nodeStartTk, nodeEndTk) && intoSearch.getNamedMatchStartToken("into").getStart() <= this.m_offset) {
                                PlSqlSearch fromSearch = new PlSqlSearch("{SELECT|WITH} {^FROM}... <from FROM>");
                                if (fromSearch.matches(nodeStartTk, nodeEndTk)) {
                                    if (fromSearch.getNamedMatchEndToken("from").getEnd() >= this.m_offset) {
                                        this.m_targetObjectClass = PlSqlDatum.class;
                                    }
                                } else {
                                    this.m_targetObjectClass = PlSqlDatum.class;
                                }
                            }
                        }
                    }
                }
            }
        } else if (contextObjectAtOffset != null) {
            this.m_contextObjectAtOffset = contextObjectAtOffset;
        } else if (givenContextObject != null) {
            this.m_contextObjectAtOffset = givenContextObject;
        } else if (this.m_schema != null) {
            this.m_contextObjectAtOffset = this.m_schema;
        } else {
            DBLog.getLogger((Object)this).fine("Unable to identify a valid value for m_contextObjectAtOffset");
        }
        if (this.m_insightContext.getCasePolicy() == DBInsightContext.CasePolicy.LOWER) {
            this.m_makeLower = Boolean.TRUE;
        } else if (this.m_insightContext.getCasePolicy() == DBInsightContext.CasePolicy.UPPER || tkLeftOfCursor == null) {
            this.m_makeLower = Boolean.FALSE;
        } else {
            PlSqlToken tk = tkLeftOfCursor;
            while (!tk.isEndMarker() && !tk.isCode(true)) {
                tk = (PlSqlToken)tk.getPrevCodeToken();
            }
            String test = tk.isEndMarker() ? "X" : tk.getSource();
            this.m_makeLower = test.equals(test.toLowerCase());
        }
        ArrayList<InsightDataProvider> insightProviders = new ArrayList<InsightDataProvider>();
        if (this.m_insightDataProviderClasses == null) {
            insightProviders.add(new ColumnInsightDataProvider());
            insightProviders.add(new SchemaProvider());
            if (!(this.m_contextObjectAtOffset instanceof SQLQuery) || this.m_targetObjectClass == FromObject.class) {
                insightProviders.add(new SchemaObjectInsightDataProvider());
            }
            if (this.m_contextObjectAtOffset instanceof DBObjectPlSqlFragment) {
                insightProviders.add(new PlSqlInsightDataProvider());
            }
            if (this.m_targetObjectClass != null && (DataType.class.isAssignableFrom(this.m_targetObjectClass) || DataTypeUsage.class.isAssignableFrom(this.m_targetObjectClass))) {
                insightProviders.add(new DataTypeProvider());
            } else {
                insightProviders.add(new FunctionProvider());
                insightProviders.add(new SQLFromObjectProvider());
            }
            if (this.m_insightContext.isIncludeReservedWords()) {
                insightProviders.add(new ReservedWordInsightDataProvider());
            }
        } else {
            for (Class<? extends InsightDataProvider> clz : this.m_insightDataProviderClasses) {
                try {
                    insightProviders.add(clz.newInstance());
                }
                catch (Exception e) {
                    DBLog.getLogger((Object)this).severe("Failed to instantiate insightDataProvider: " + e.getMessage());
                }
            }
        }
        for (InsightDataProvider aidp : insightProviders) {
            aidp.setDBInsightProvider(this);
        }
        if (this.m_parentLocatorClass == null) {
            parentLocator = givenContextObject instanceof SQLQuery && ((SQLQuery)givenContextObject).isDeclarative() ? new DeclarativeSQLQueryParentLocator() : (givenContextObject instanceof SQLQuery || givenContextObject instanceof SQLQueryOwner || givenContextObject instanceof PlSqlSourceObject || givenContextObject == null ? new SQLParentLocator() : new ParentLocator());
        } else {
            ParentLocator loc = null;
            try {
                loc = this.m_parentLocatorClass.newInstance();
            }
            catch (Exception e) {
                DBLog.getLogger((Object)this).severe("Failed to instantiate parentLocator: " + e.getMessage());
            }
            if (loc == null) {
                loc = new ParentLocator();
            }
            parentLocator = loc;
        }
        parentLocator.setDBInsightProvider(this);
        DBObject top = this.m_contextObjectAtOffset == null ? null : DBUtil.getUppermostParent((DBObject)this.m_contextObjectAtOffset);
        ArrayList<String> parentNames = new ArrayList<String>();
        while (parentTk != null && parentTk.isCode()) {
            parentNames.add(0, this.m_pro.getInternalName(parentTk.getSource()));
            if (((PlSqlToken)parentTk.getPrevCodeToken()).matches(".") && ((PlSqlToken)((PlSqlToken)parentTk.getPrevCodeToken()).getPrevCodeToken()).isCode(true)) {
                parentTk = (PlSqlToken)((PlSqlToken)parentTk.getPrevCodeToken()).getPrevCodeToken();
                continue;
            }
            if (((PlSqlToken)parentTk.getPrevCodeToken()).matches(":") && parentNames.size() == 1 && top instanceof Trigger) {
                DBObjectID id;
                Trigger trigger = (Trigger)top;
                ArrayList<String> refAsses = new ArrayList<String>();
                String newAs = trigger.getReferencingNewAs();
                if (newAs == null) {
                    newAs = "NEW";
                }
                refAsses.add(newAs);
                String oldAs = trigger.getReferencingOldAs();
                if (oldAs == null) {
                    oldAs = "OLD";
                }
                refAsses.add(oldAs);
                if (refAsses.contains(parentNames.get(0)) && (id = trigger.getBaseObjectID()) != null) {
                    String name;
                    parentNames.clear();
                    String schemaName = DBUtil.getSchemaName((DBObjectID)id);
                    if (schemaName != null) {
                        parentNames.add(schemaName);
                    }
                    if ((name = DBUtil.getDBObjectName((DBObjectID)id)) != null) {
                        parentNames.add(name);
                    }
                }
            }
            parentTk = null;
        }
        DBObject context = null;
        if (parentNames.size() > 0 && (context = parentLocator.getParent(parentNames)) == null) {
            return;
        }
        if (context instanceof Synonym) {
            context = DBUtil.getSynonymReference((Synonym)((Synonym)context));
        }
        boolean bl = parentContextSet = context != null;
        if (context == null) {
            context = this.m_contextObjectAtOffset;
        }
        int level = 0;
        while (true) {
            ++level;
            for (InsightDataProvider p : insightProviders) {
                p.setOrder(level * 10);
                p.addItems(context);
            }
            if (parentContextSet || context == null || this.m_parentScopeClass != null && this.m_parentScopeClass.isAssignableFrom(context.getClass())) break;
            if (context instanceof Index && ((Index)context).getTable() != null) {
                context = ((Index)context).getTable();
                continue;
            }
            if (context instanceof SchemaObject) {
                context = ((SchemaObject)context).getSchema();
                continue;
            }
            context = context.getParent();
        }
    }

    public String getMatchingText() {
        return this.m_searchString;
    }

    public List<DBInsightData> getInsightData() {
        ArrayList<DBInsightData> ret = new ArrayList<DBInsightData>();
        ret.addAll(this.m_data.values());
        Collections.sort(ret, new InsightComparator());
        return ret;
    }

    final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    final Schema getSchema() {
        return this.m_schema;
    }

    final String getText() {
        return this.m_text;
    }

    final Integer getOffset() {
        return this.m_offset;
    }

    final DBObject getContextObjectAtOffset() {
        return this.m_contextObjectAtOffset;
    }

    final DBInsightContext.FilterMode getFilterMode() {
        return this.m_insightContext.getFilterMode();
    }

    final Class<? extends DBObject> getTargetObjectClass() {
        return this.m_targetObjectClass;
    }

    final Class<? extends DBObject> getParentScopeClass() {
        return this.m_parentScopeClass;
    }

    final DBInsightContext getInsightContext() {
        return this.m_insightContext;
    }

    final Class<? extends ParentLocator> getParentLocatorClass() {
        return this.m_parentLocatorClass;
    }

    final List<Class<? extends InsightDataProvider>> getInsightDataProviderClasses() {
        return this.m_insightDataProviderClasses;
    }

    final Boolean getMakeLower() {
        return this.m_makeLower;
    }

    final int getReplacementStart() {
        return this.m_replacementStart;
    }

    final int getReplacementEnd() {
        return this.m_replacementEnd;
    }

    final String getLanguage() {
        return this.m_language;
    }

    final boolean isUserOnly() {
        return this.m_userOnly;
    }

    final void addItem(DBInsightData item) {
        String key = item.getName();
        if (!this.m_data.containsKey(key)) {
            this.m_data.put(key, item);
        }
    }

    public static DBObject resolveIDForInsight(DBObjectID id) throws CancelledException {
        DBObject retval = null;
        if (id != null) {
            try {
                retval = id.resolveID();
            }
            catch (CancelledException ce) {
                throw ce;
            }
            catch (DBException dbe) {
                DBLog.getLogger(DBInsightProvider.class).fine(dbe.getMessage());
            }
        }
        return retval;
    }

    private static class InsightComparator
    implements Comparator<DBInsightData> {
        private InsightComparator() {
        }

        @Override
        public int compare(DBInsightData o1, DBInsightData o2) {
            int ord2;
            int ret = 0;
            int ord1 = o1.getOrder();
            int n = ord1 < (ord2 = o2.getOrder()) ? -1 : (ret = ord1 == ord2 ? 0 : 1);
            if (ret == 0) {
                ret = o1.getDescription().compareTo(o2.getDescription());
            }
            if (ret == 0) {
                ret = o1.getName().compareTo(o2.getName());
            }
            return ret;
        }
    }
}

