/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.execute;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ExecutorService;
import oracle.ide.db.execute.DBRequestProcessor;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.javatools.db.internal.DBCore;
import org.openide.util.RequestProcessor;

public class DBRequestProcessorFactory {
    private Timer m_timer;
    private ExecutorService m_dbExecutor;
    private final Map<String, DBRequestProcessor> m_nodeExecutors = new HashMap<String, DBRequestProcessor>();
    private final NodeListener m_listener = new NodeListener(){

        public void nodeWillClose(NodeEvent e) {
            Node node = e.getNode();
            if (node instanceof DBObjectNode) {
                DBRequestProcessorFactory.this.shutdown((DBObjectNode)node, null);
            }
        }
    };

    private synchronized Timer getTimerImpl() {
        if (this.m_timer == null) {
            this.m_timer = new Timer(this.getClass().getSimpleName() + "_Timer", true);
        }
        return this.m_timer;
    }

    private ExecutorService getDatabaseExecutor() {
        if (this.m_dbExecutor == null) {
            this.m_dbExecutor = DatabaseUIExtensionHook.getHook().getDBExecutor();
            if (this.m_dbExecutor == null) {
                this.m_dbExecutor = new RequestProcessor("DBRequestProcessor_DatabaseProcessor", 1, true);
            }
        }
        return this.m_dbExecutor;
    }

    private synchronized DBRequestProcessor getNodeProcessor(DBObjectNode node) {
        String key = this.getKey(node);
        DBRequestProcessor retval = this.m_nodeExecutors.get(key);
        if (retval == null) {
            String proType = node.getProviderType();
            ExecutorService executor = "db".equals(proType) ? this.getDatabaseExecutor() : null;
            retval = new DBRequestProcessor(executor, node);
            this.m_nodeExecutors.put(key, retval);
            if (node instanceof Node) {
                ((Node)node).addNodeListener(this.m_listener);
            }
        }
        return retval;
    }

    private synchronized void shutdown(DBObjectNode node, DBRequestProcessor proc) {
        if (node instanceof Node) {
            ((Node)node).removeNodeListener(this.m_listener);
        }
        String key = this.getKey(node);
        if (proc == null) {
            proc = this.m_nodeExecutors.remove(key);
        } else {
            DBRequestProcessor cached = this.m_nodeExecutors.get(key);
            if (cached == proc) {
                this.m_nodeExecutors.remove(key);
            }
        }
        if (proc != null) {
            proc.shutdown();
        }
        if (this.m_nodeExecutors.isEmpty() && this.m_timer != null) {
            this.m_timer.cancel();
            this.m_timer = null;
        }
    }

    private String getKey(DBObjectNode node) {
        return node.getURL().toString();
    }

    Timer getTimer() {
        return DBRequestProcessorFactory.getInstance().getTimerImpl();
    }

    synchronized void notifyProcessorEmpty(DBObjectNode node, DBRequestProcessor proc) {
        if (!(node instanceof Node) || !((Node)node).isOpen()) {
            this.shutdown(node, proc);
        }
    }

    static synchronized DBRequestProcessorFactory getInstance() {
        DBCore core = DBCore.getInstance();
        DBRequestProcessorFactory retval = (DBRequestProcessorFactory)core.get(DBRequestProcessorFactory.class);
        if (retval == null) {
            retval = new DBRequestProcessorFactory();
            core.put((Object)retval);
        }
        return retval;
    }

    public static DBRequestProcessor getProcessor(DBObjectNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        return DBRequestProcessorFactory.getInstance().getNodeProcessor(node);
    }
}

