/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

public class SchemaPicker
extends JComboBox {
    private DBObjectProvider m_prov;
    private Schema[] m_schemas;

    public SchemaPicker() {
        this(false);
    }

    public SchemaPicker(boolean allowNullSelection) {
        super(allowNullSelection ? new DefaultComboBoxModel() : new NonNullableComboBoxModel());
    }

    private DBObjectProvider getProvider() {
        if (this.m_prov == null) {
            throw new IllegalStateException("schema picker hasn't been initialized with a provider");
        }
        return this.m_prov;
    }

    public Schema getSchema() throws TraversalException {
        DBObjectProvider pro = this.getProvider();
        Schema schema = null;
        String name = (String)this.getSelectedItem();
        if (this.isEditable() && !pro.isValidName("SCHEMA", name)) {
            String msg = UIBundle.format("TABLE_INFO_ERROR_BAD_SCHEMA_NAME", name);
            throw new TraversalException(msg, UIBundle.get("SCHEMA_ERROR_TITLE"));
        }
        if (ModelUtil.hasLength((String)(name = pro.getInternalName(name)))) {
            if (this.m_schemas != null) {
                for (int i = 0; i < this.m_schemas.length; ++i) {
                    if (!name.equals(this.m_schemas[i].getName())) continue;
                    schema = this.m_schemas[i];
                    break;
                }
            }
            if (schema == null) {
                try {
                    schema = pro.getSchema(name);
                }
                catch (DBException dbe) {
                    String msg = dbe.getMessage();
                    throw new TraversalException(msg, UIBundle.get("SCHEMA_ERROR_TITLE"));
                }
            }
        } else {
            try {
                schema = pro.getDefaultSchema();
            }
            catch (DBException dbe) {
                String msg = dbe.getMessage();
                throw new TraversalException(msg, UIBundle.get("SCHEMA_ERROR_TITLE"));
            }
        }
        if (schema == null) {
            schema = new Schema(name);
            try {
                pro.validateObject((DBObject)schema);
            }
            catch (ValidationException ve) {
                String msg = ve.getMessage();
                throw new TraversalException(msg, UIBundle.get("SCHEMA_ERROR_TITLE"));
            }
        }
        return schema;
    }

    public void init(DBEditorConfig config, Schema schema) {
        this.init(config.getProvider(), schema, config.getSchemaList());
    }

    public void init(DBObjectProvider pro, String schemaName) {
        Schema schema = null;
        try {
            schema = pro.getSchema(schemaName);
        }
        catch (DBException dbe) {
            DBExceptionDialog.showErrorDialog((Component)this, UIBundle.get("SCHEMA_ERROR_TITLE"), dbe);
        }
        this.init(pro, schema);
    }

    public void init(DBObjectProvider pro, Schema schema) {
        this.init(pro, schema, true);
    }

    public void init(DBObjectProvider pro, Schema schema, boolean showAll) {
        Schema[] schemas = null;
        try {
            schemas = pro.listSchemas(showAll);
        }
        catch (DBException dbe) {
            DBExceptionDialog.showErrorDialog((Component)this, UIBundle.get("SCHEMA_ERROR_TITLE"), dbe);
        }
        this.init(pro, schema, schemas);
    }

    public void init(DBObjectProvider pro, Schema schema, Schema[] schemas) {
        this.m_prov = pro;
        this.m_schemas = schemas;
        if (pro != null && schema == null) {
            try {
                schema = pro.getDefaultSchema();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        this.removeAllItems();
        boolean found = false;
        if (this.m_schemas != null) {
            Arrays.sort(this.m_schemas, DBUtil.getNameComparator());
            for (int i = 0; i < this.m_schemas.length; ++i) {
                if (this.m_schemas[i] == null) continue;
                this.addItem(this.m_schemas[i]);
                if (found || schema == null || !ModelUtil.areEqual((Object)this.m_schemas[i].getName(), (Object)schema.getName())) continue;
                found = true;
            }
        }
        if (schema != null && !found) {
            this.addItem(schema);
        }
        this.setSelectedItem(schema);
    }

    public void initWithOneSchema(DBObjectProvider pro, Schema schema) {
        this.m_prov = pro;
        this.removeAllItems();
        this.addItem(schema);
        this.setSelectedItem(schema);
    }

    public void addItem(Object anObject) {
        super.addItem(this.convertToString(anObject));
    }

    @Override
    public void removeItem(Object anObject) {
        super.removeItem(this.convertToString(anObject));
    }

    @Override
    public void setSelectedItem(Object value) {
        super.setSelectedItem(this.convertToString(value));
    }

    private String convertToString(Object anObject) {
        if (anObject instanceof Schema) {
            anObject = this.getProvider().getExternalName(((Schema)anObject).getName());
        } else if (anObject != null) {
            anObject = anObject.toString();
        }
        return (String)anObject;
    }
}

