/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextArea;
import javax.swing.text.Caret;

public class ReadOnlyTextArea
extends JTextArea {
    public ReadOnlyTextArea() {
        this(false);
    }

    public ReadOnlyTextArea(boolean showBorder) {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setEditable(false);
        this.setOpaque(true);
        if (!showBorder) {
            this.setBorder(null);
        }
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Caret caret = ReadOnlyTextArea.this.getCaret();
                if (caret != null) {
                    caret.setVisible(true);
                }
            }
        });
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.getAccessibleContext().setAccessibleDescription(text);
        this.setCaretPosition(0);
    }
}

