/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public abstract class AbstractTreePicker
implements MouseListener,
FocusListener,
TreeSelectionListener,
ItemPicker {
    private PropertyChangeSupport m_pcs;
    private ActionListener m_actionListener;
    private JTree m_tree;
    private JScrollPane m_component;
    private ComponentWithTitlebar m_compTitleBar = new ComponentWithTitlebar();

    public AbstractTreePicker() {
    }

    public AbstractTreePicker(JTree tree) {
        this.setTree(tree);
    }

    public void setTree(JTree tree) {
        this.m_tree = tree;
        this.m_component = new JScrollPane(this.m_tree);
        this.m_tree.addFocusListener(this);
        this.m_tree.addMouseListener(this);
        this.m_tree.addTreeSelectionListener(this);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        ActionListener enterListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                boolean handled = AbstractTreePicker.this.handleDefaultAction(AbstractTreePicker.this.m_tree.getSelectionPath());
                if (!handled && AbstractTreePicker.this.m_actionListener != null) {
                    AbstractTreePicker.this.m_actionListener.actionPerformed(new ActionEvent(AbstractTreePicker.this, 1001, null));
                }
            }
        };
        this.m_tree.registerKeyboardAction(enterListener, enter, 0);
        KeyStroke ctrlA = KeyStroke.getKeyStroke(65, 128);
        ActionListener selectAllListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AbstractTreePicker.this.m_tree.setSelectionInterval(0, AbstractTreePicker.this.m_tree.getRowCount());
            }
        };
        this.m_tree.registerKeyboardAction(selectAllListener, ctrlA, 0);
        this.m_compTitleBar.setComponent((JComponent)this.m_component);
    }

    public JTree getTree() {
        return this.m_tree;
    }

    public boolean isItemSelected() {
        TreePath[] path = this.m_tree.getSelectionPaths();
        for (int i = 0; path != null && i < path.length; ++i) {
            if (this.createTransferable(path[i]) == null) continue;
            return true;
        }
        return false;
    }

    public void deselectAll() {
        this.m_tree.getSelectionModel().setSelectionPath(null);
    }

    public Transferable[] getSelectedItems() {
        TreePath[] selection = this.m_tree.getSelectionPaths();
        if (selection != null) {
            ArrayList<Transferable> t = new ArrayList<Transferable>();
            for (int i = 0; i < selection.length; ++i) {
                Transferable trans = this.createTransferable(selection[i]);
                if (trans == null) continue;
                t.add(trans);
            }
            return t.toArray(new Transferable[t.size()]);
        }
        return null;
    }

    public boolean isSelectableItemPresent() {
        return this.m_tree.getRowCount() > 0;
    }

    public JScrollPane getScrollPane() {
        return this.m_component;
    }

    public Component getComponent() {
        return this.m_compTitleBar;
    }

    public DataFlavor[] getSelectionDataFlavors() {
        Transferable[] t = this.getSelectedItems();
        if (t != null) {
            DataFlavor[] df = new DataFlavor[t.length];
            for (int i = 0; i < t.length; ++i) {
                df[i] = t[i] == null ? null : t[i].getTransferDataFlavors()[0];
            }
            return df;
        }
        return null;
    }

    public boolean canAcceptFlavors(DataFlavor[] flav) {
        return true;
    }

    public abstract Transferable[] getAllSelectableItems();

    public abstract boolean addSelectedItems(Transferable[] var1);

    public abstract void removeSelectedItems();

    public abstract void removeAllSelectableItems();

    public abstract Transferable createTransferable(TreePath var1);

    public void addActionListener(ActionListener al) {
        this.m_actionListener = AWTEventMulticaster.add(this.m_actionListener, al);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.m_pcs == null) {
            this.m_pcs = new PropertyChangeSupport(this);
        }
        this.m_pcs.addPropertyChangeListener(pcl);
    }

    public void removeActionListener(ActionListener al) {
        this.m_actionListener = AWTEventMulticaster.remove(this.m_actionListener, al);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.m_pcs != null) {
            this.m_pcs.removePropertyChangeListener(pcl);
        }
    }

    protected boolean handleDefaultAction(TreePath path) {
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.m_actionListener != null) {
            Transferable t;
            Object node;
            TreePath selPath;
            int selRow = this.m_tree.getRowForLocation(e.getX(), e.getY());
            if (selRow == -1) {
                int m = e.getModifiers();
                if ((m & 2) != 2 && (m & 1) != 1) {
                    this.deselectAll();
                }
            } else if (e.getClickCount() % 2 == 0 && SwingUtilities.isLeftMouseButton(e) && !this.handleDefaultAction(selPath = this.m_tree.getPathForLocation(e.getX(), e.getY())) && (!((node = selPath.getLastPathComponent()) instanceof DefaultMutableTreeNode) || ((DefaultMutableTreeNode)node).isLeaf()) && (t = this.createTransferable(selPath)) != null) {
                this.m_actionListener.actionPerformed(new ActionEvent(this, e.getID(), null, e.getModifiers()));
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.m_tree.getSelectionCount() == 0 && this.m_tree.getRowCount() > 0) {
            this.m_tree.setSelectionRow(0);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.m_pcs != null) {
            this.m_pcs.firePropertyChange("selection", null, null);
        }
    }

    public void setTitleLabel(String label, String panelName) {
        JLabel lbl = new JLabel();
        DBUIResourceHelper reshelp = new DBUIResourceHelper(panelName);
        reshelp.resLabel(lbl, (Component)this.m_compTitleBar, label, "Available");
        this.m_compTitleBar.setLabel(lbl);
    }

    public void setTitleControlBar(ControlBar bar) {
        this.m_compTitleBar.setControlBar(bar);
    }
}

