/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.text.Document;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractSizeChooser
extends JPanel {
    private final JComboBox m_cmbByteMultiple = new JComboBox();
    private final NumberTextField m_fldSize = new NumberTextField();
    private final List<ChangeListener> m_listeners = new ArrayList<ChangeListener>();
    private BigInteger m_highestMultiple;
    private String m_name;
    private boolean m_listening = false;
    private final BigInteger MULTIPLIER = new BigInteger("1024");
    private final NonNullableComboBoxModel m_mdlByteMultiples = new NonNullableComboBoxModel();
    private final Map<String, BigInteger> m_multiplesAsBytes = new TreeMap<String, BigInteger>();

    public AbstractSizeChooser() {
        this((String)null);
    }

    public AbstractSizeChooser(String panelName) {
        this.init(panelName);
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract void addByteMultiples();

    @Override
    public final void setName(String name) {
        this.m_name = name;
        this.m_cmbByteMultiple.setName(name);
        this.m_fldSize.setName(name + "_MULTIPLIER");
    }

    @Override
    public final String getName() {
        return this.m_name;
    }

    @Override
    public void setEnabled(boolean b) {
        this.m_cmbByteMultiple.setEnabled(b);
        this.m_fldSize.setEnabled(b);
    }

    @Override
    public boolean isEnabled() {
        return this.m_cmbByteMultiple.isEnabled() && this.m_fldSize.isEnabled();
    }

    @Override
    public boolean isVisible() {
        return this.m_cmbByteMultiple.isVisible() && this.m_fldSize.isVisible();
    }

    @Override
    public void setVisible(boolean aFlag) {
        this.m_cmbByteMultiple.setVisible(aFlag);
        this.m_fldSize.setVisible(aFlag);
    }

    protected void init(String panelName) {
        this.m_fldSize.setDataType(BigInteger.class);
        this.m_highestMultiple = BigInteger.ONE;
        this.m_name = panelName;
        this.m_mdlByteMultiples.addElement((Object)"");
        this.addByteMultiples();
        this.m_cmbByteMultiple.setModel(this.m_mdlByteMultiples);
        this.m_cmbByteMultiple.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (AbstractSizeChooser.this.m_listening) {
                    AbstractSizeChooser.this.notifyListeners();
                }
            }
        });
        this.m_listening = true;
    }

    public void addByteMultiple(String display) {
        this.m_mdlByteMultiples.addElement((Object)display);
        BigInteger multiple = this.m_highestMultiple.multiply(this.MULTIPLIER);
        this.m_multiplesAsBytes.put(display, multiple);
        this.m_highestMultiple = multiple;
    }

    protected void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_fldSize, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_cmbByteMultiple, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 4, 0, 0), 0, 0));
        this.m_cmbByteMultiple.setMaximumSize(new Dimension(10, 1));
        this.m_fldSize.setMinimumSize(new Dimension(100, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String t) {
        this.m_listening = false;
        try {
            if (ModelUtil.hasLength((String)t)) {
                Set<String> multiplesSet = this.m_multiplesAsBytes.keySet();
                BigInteger bytesValue = new BigInteger(t);
                Iterator<String> iter = multiplesSet.iterator();
                BigInteger lowest = bytesValue;
                this.m_fldSize.setNumber((Number)bytesValue);
                this.m_cmbByteMultiple.setSelectedIndex(0);
                while (iter.hasNext()) {
                    String multiple = iter.next();
                    BigInteger multipleValue = this.m_multiplesAsBytes.get(multiple);
                    BigInteger[] divideAndRemainder = bytesValue.divideAndRemainder(multipleValue);
                    if (!divideAndRemainder[1].equals(BigInteger.ZERO) || divideAndRemainder[0].compareTo(lowest) == 1) continue;
                    lowest = divideAndRemainder[0];
                    this.m_cmbByteMultiple.setSelectedItem(multiple);
                    this.m_fldSize.setNumber((Number)bytesValue.divide(multipleValue));
                }
            } else {
                this.m_fldSize.setText(null);
                this.m_cmbByteMultiple.setSelectedIndex(0);
            }
        }
        finally {
            this.m_listening = true;
        }
    }

    public String getText() {
        if (ModelUtil.hasLength((String)this.m_fldSize.getText())) {
            return this.getNumber().toString();
        }
        return this.m_fldSize.getText();
    }

    public Number getNumber() {
        Object selectedMultiple = this.m_cmbByteMultiple.getSelectedItem();
        if (selectedMultiple instanceof String && ModelUtil.hasLength((String)((String)selectedMultiple))) {
            BigInteger multiplier = this.m_multiplesAsBytes.get(selectedMultiple);
            if (ModelUtil.hasLength((String)this.m_fldSize.getText())) {
                return multiplier.multiply(new BigInteger(this.m_fldSize.getText()));
            }
            return this.m_fldSize.getNumber();
        }
        return this.m_fldSize.getNumber();
    }

    public void setNumber(Number n) {
        if (n != null) {
            this.setText(n.toString());
        } else {
            this.m_fldSize.setNumber(null);
            this.m_cmbByteMultiple.setSelectedIndex(0);
        }
    }

    public final void addChangeListener(ChangeListener l) {
        this.m_listeners.add(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.m_listeners.remove(l);
    }

    protected void notifyListeners() {
        for (ChangeListener cl : this.m_listeners) {
            cl.chooserChanged(this);
        }
    }

    public Document getDocument() {
        return this.m_fldSize.getDocument();
    }

    public static interface ChangeListener {
        public void chooserChanged(AbstractSizeChooser var1);
    }
}

