/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.view.View;
import oracle.javatools.db.ora.OracleDatabase;

public class DBObjectActions {
    public static IdeAction getNewObjectAction() {
        return IdeAction.find((String)"oracle.ide.db.NewObject");
    }

    public static IdeAction getDuplicateAction() {
        return IdeAction.find((String)"oracle.ide.db.DuplicateObject");
    }

    public static IdeAction getFindOrCreateBodyAction() {
        return IdeAction.find((String)"oracle.ide.db.FindOrCreateBody");
    }

    public static IdeAction getSynchronizeSpecAndBody() {
        return IdeAction.find((String)"oracle.ide.db.SynchronizeSpecAndBody");
    }

    public static IdeAction getTestQueryAction() {
        return IdeAction.find((String)"oracle.ide.db.TestQuery");
    }

    public static IdeAction getPropertiesAction() {
        return IdeActions.getEditPropertiesAction();
    }

    public static final boolean addNewObjectMenuItem(ContextMenu contextMenu) {
        DBObjectTypeNode node;
        boolean retval = false;
        Context c = contextMenu.getContext();
        View v = c.getView();
        if (v != null && !((node = DBObjectNodeUtil.getSelectedElement(c, DBObjectTypeNode.class)) instanceof DBObjectNode)) {
            String type = DBObjectNodeUtil.normalizeType(node);
            DBEditorFactory factory = DBEditorFactoryRegistry.getCreateFactory(node);
            if (factory != null && (DBObjectNodeUtil.findProvider(node) instanceof OracleDatabase || factory.canCreateDBObject(node))) {
                IdeAction action = DBObjectActions.getNewObjectAction();
                JMenuItem m = contextMenu.createMenuItem((ToggleAction)action);
                Icon icon = DBTypeDisplayRegistry.getNodeIcon(type);
                m.setIcon(icon);
                String text = DBTypeDisplayRegistry.getNewMenuItemText(type);
                m.setText(StringUtils.stripMnemonic((String)text));
                m.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
                contextMenu.add((Component)m, 1.0f);
                retval = true;
            }
        }
        return retval;
    }
}

