/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLConnectionManagerFactory;
import oracle.xml.xsql.XSQLCustomPageRequest;
import oracle.xml.xsql.XSQLInitializationException;
import oracle.xml.xsql.XSQLPage;
import oracle.xml.xsql.XSQLPageProcessor;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLURLPageRequest;
import oracle.xml.xsql.XSQLUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class XSQLRequest {
    XSQLConnectionManagerFactory fact = null;
    PrintWriter out = null;
    PrintWriter err = null;
    OutputStream outStream = null;
    Dictionary params = null;
    URL url = null;
    XSQLPageRequest callingReq = null;
    Document postedXML = null;
    XSQLPage page = null;
    URL baseURL = null;
    String baseURI = null;

    public static String getPageProcessorVersion() {
        return XSQLPageProcessor.getVersion();
    }

    public XSQLRequest(XMLDocument xMLDocument, URL uRL) {
        this.page = new XSQLPage((XMLDocument)xMLDocument.cloneNode(true));
        this.baseURL = uRL;
    }

    public XSQLRequest(XSQLConnectionManagerFactory xSQLConnectionManagerFactory, XMLDocument xMLDocument, URL uRL) {
        this.fact = xSQLConnectionManagerFactory;
        this.page = new XSQLPage((XMLDocument)xMLDocument.cloneNode(true));
        this.baseURL = uRL;
    }

    public XSQLRequest(String string) throws MalformedURLException {
        this.url = new URL(string);
    }

    public XSQLRequest(XSQLConnectionManagerFactory xSQLConnectionManagerFactory, String string) throws MalformedURLException {
        this.fact = xSQLConnectionManagerFactory;
        this.url = new URL(string);
    }

    public XSQLRequest(URL uRL, XSQLPageRequest xSQLPageRequest) {
        this.url = uRL;
        this.callingReq = xSQLPageRequest;
    }

    public XSQLRequest(String string, XSQLPageRequest xSQLPageRequest) throws MalformedURLException {
        if (!XSQLUtil.isAbsoluteURL(string)) {
            this.baseURI = XSQLUtil.baseUriOf(XSQLUtil.relativize(string, xSQLPageRequest.getBaseURI()));
            String string2 = xSQLPageRequest.translateURL(string);
            if (string2 == null) {
                throw new MalformedURLException(Res.format(25123, string));
            }
            this.url = new URL(string2);
        } else {
            this.url = new URL(string);
        }
        this.callingReq = xSQLPageRequest;
    }

    public XSQLRequest(URL uRL) {
        this.url = uRL;
    }

    public XSQLRequest(XSQLConnectionManagerFactory xSQLConnectionManagerFactory, URL uRL) {
        this.fact = xSQLConnectionManagerFactory;
        this.url = uRL;
    }

    public void setPostedDocument(Document document) {
        this.postedXML = document;
    }

    public void process(OutputStream outputStream, PrintWriter printWriter) {
        this.outStream = outputStream;
        this.err = printWriter;
        this.process();
    }

    public void process(PrintWriter printWriter, PrintWriter printWriter2) {
        this.out = printWriter;
        this.err = printWriter2;
        this.process();
    }

    public void process(Dictionary dictionary, OutputStream outputStream, PrintWriter printWriter) {
        this.params = dictionary;
        this.outStream = outputStream;
        this.err = printWriter;
        this.process();
    }

    public void process(Dictionary dictionary, PrintWriter printWriter, PrintWriter printWriter2) {
        this.params = dictionary;
        this.out = printWriter;
        this.err = printWriter2;
        this.process();
    }

    public void process(Dictionary dictionary) {
        this.params = dictionary;
        this.process();
    }

    public void process() {
        if (this.outStream == null && this.out == null) {
            this.out = new PrintWriter(System.out);
        }
        if (this.err == null) {
            this.err = new PrintWriter(System.err);
        }
        XSQLPageRequest xSQLPageRequest = null;
        xSQLPageRequest = this.callingReq != null ? this.callingReq.createNestedRequest(this.baseURI, this.url, this.params, this.out, this.outStream) : (this.page != null ? (this.outStream != null ? (this.fact != null ? new XSQLCustomPageRequest(this.fact, this.page, this.baseURL, this.params, this.outStream, this.err) : new XSQLCustomPageRequest(this.page, this.baseURL, this.params, this.outStream, this.err)) : (this.fact != null ? new XSQLCustomPageRequest(this.fact, this.page, this.baseURL, this.params, this.out, this.err) : new XSQLCustomPageRequest(this.page, this.baseURL, this.params, this.out, this.err))) : (this.outStream != null ? (this.fact != null ? new XSQLURLPageRequest(this.fact, this.url, this.params, this.outStream, this.err) : new XSQLURLPageRequest(this.url, this.params, this.outStream, this.err)) : (this.fact != null ? new XSQLURLPageRequest(this.fact, this.url, this.params, this.out, this.err) : new XSQLURLPageRequest(this.url, this.params, this.out, this.err))));
        if (this.postedXML != null) {
            xSQLPageRequest.setPostedDocument(this.postedXML);
        }
        if (this.callingReq != null) {
            xSQLPageRequest.setIncludingRequest(this.callingReq);
        }
        XSQLPageProcessor xSQLPageProcessor = new XSQLPageProcessor(xSQLPageRequest);
        try {
            xSQLPageProcessor.process();
        }
        catch (XSQLInitializationException xSQLInitializationException) {
            return;
        }
        catch (SAXParseException sAXParseException) {
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
    }

    public Document processToXML(PrintWriter printWriter) {
        this.out = this.out;
        this.err = printWriter;
        return this.processToXML();
    }

    public Document processToXML(Dictionary dictionary, PrintWriter printWriter) {
        this.params = dictionary;
        this.out = this.out;
        this.err = printWriter;
        return this.processToXML();
    }

    public Document processToXML(Dictionary dictionary) {
        this.params = dictionary;
        return this.processToXML();
    }

    public Document processToXML() {
        if (this.err == null) {
            this.err = new PrintWriter(System.err);
        }
        XSQLPageRequest xSQLPageRequest = null;
        xSQLPageRequest = this.callingReq != null ? this.callingReq.createNestedRequest(this.baseURI, this.url, this.params, this.out, this.outStream) : (this.page != null ? (this.fact != null ? new XSQLCustomPageRequest(this.fact, this.page, this.baseURL, this.params, this.err) : new XSQLCustomPageRequest(this.page, this.baseURL, this.params, this.err)) : (this.fact != null ? new XSQLURLPageRequest(this.fact, this.url, this.params, this.err) : new XSQLURLPageRequest(this.url, this.params, this.err)));
        if (this.callingReq != null) {
            xSQLPageRequest.setIncludingRequest(this.callingReq);
        }
        if (this.postedXML != null) {
            xSQLPageRequest.setPostedDocument(this.postedXML);
        }
        XSQLPageProcessor xSQLPageProcessor = new XSQLPageProcessor(xSQLPageRequest);
        try {
            return xSQLPageProcessor.processToXML();
        }
        catch (XSQLInitializationException xSQLInitializationException) {
            return null;
        }
        catch (SAXParseException sAXParseException) {
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static String getReleaseVersion() {
        return XSQLPageProcessor.getVersion();
    }
}

