/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxb;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oracle.xml.jaxb.JaxbNode;
import oracle.xml.jaxb.JaxbUtil;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Node;

public class JaxbListImpl
implements List,
Externalizable {
    String name = null;
    String namespace = null;
    JaxbNode jnode = null;
    int pos = 0;
    ArrayList nodeList = null;
    ArrayList jnodeList = null;
    boolean isAnyType = false;

    public JaxbListImpl() {
    }

    JaxbListImpl(String string, String string2, ArrayList arrayList, JaxbNode jaxbNode, int n) {
        this.name = string;
        this.namespace = string2;
        this.jnode = jaxbNode;
        this.pos = n;
        if (arrayList == null) {
            this.nodeList = new ArrayList(10);
            this.jnodeList = new ArrayList(10);
        } else {
            this.nodeList = arrayList;
            this.jnodeList = new ArrayList(arrayList);
        }
    }

    JaxbListImpl(String string, String string2, ArrayList arrayList, ArrayList arrayList2, JaxbNode jaxbNode, int n) {
        this.name = string;
        this.namespace = string2;
        this.jnode = jaxbNode;
        this.pos = n;
        this.nodeList = arrayList;
        this.jnodeList = arrayList2;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.writeExternal(objectOutput, true);
    }

    protected void writeExternal(ObjectOutput objectOutput, boolean bl) throws IOException {
        objectOutput.writeUTF(this.getClass().getName());
        if (bl) {
            objectOutput.writeUTF(this.jnode.getClass().getName());
            this.jnode.writeExternal(objectOutput);
        }
        objectOutput.writeUTF(this.name);
        objectOutput.writeUTF(this.namespace);
        objectOutput.writeInt(this.pos);
        this.writeExternalArrayList(objectOutput);
    }

    private void writeExternalArrayList(ObjectOutput objectOutput) throws IOException {
        int n = -1;
        if (this.nodeList != null) {
            n = this.nodeList.size();
        }
        objectOutput.writeInt(n);
        Object object = null;
        int n2 = 0;
        XMLNode xMLNode = (XMLNode)this.jnode.getDOMNode().getFirstChild();
        XMLElement xMLElement = null;
        Object[] objectArray = new Object[2];
        for (int i = 0; i < n; ++i) {
            objectArray[0] = this.nodeList.get(i);
            objectArray[1] = this.jnodeList.get(i);
            for (int j = 0; j < 2; ++j) {
                object = objectArray[j];
                if (object == null) {
                    objectOutput.write(0);
                    continue;
                }
                xMLElement = null;
                if (object instanceof JaxbNode) {
                    xMLElement = ((JaxbNode)object).getDOMNode();
                } else if (object instanceof XMLNode) {
                    xMLElement = (XMLNode)object;
                }
                if (xMLElement != null) {
                    while (xMLNode != xMLElement) {
                        if (xMLNode == null) {
                            throw new IOException();
                        }
                        ++n2;
                        xMLNode = (XMLNode)xMLNode.getNextSibling();
                    }
                }
                JaxbUtil.writeExternal(objectOutput, object, n2);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.readExternal(objectInput, null);
    }

    protected void readExternal(ObjectInput objectInput, JaxbNode jaxbNode) throws IOException, ClassNotFoundException {
        if (jaxbNode == null) {
            String string = objectInput.readUTF();
            string = objectInput.readUTF();
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                this.jnode = (JaxbNode)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new ClassNotFoundException(string, exception);
            }
            this.jnode.readExternal(objectInput);
        } else {
            this.jnode = jaxbNode;
        }
        this.name = objectInput.readUTF();
        this.namespace = objectInput.readUTF();
        this.pos = objectInput.readInt();
        this.readExternalArrayList(objectInput, jaxbNode);
    }

    private void readExternalArrayList(ObjectInput objectInput, JaxbNode jaxbNode) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n == -1) {
            this.nodeList = null;
            this.jnodeList = null;
            return;
        }
        this.nodeList = new ArrayList(n);
        this.jnodeList = new ArrayList(n);
        int n2 = 0;
        ArrayList arrayList = null;
        XMLNode xMLNode = (XMLNode)this.jnode.getDOMNode().getFirstChild();
        for (int i = 0; i < n; ++i) {
            block12: for (int j = 0; j < 2; ++j) {
                arrayList = j == 0 ? this.nodeList : this.jnodeList;
                int n3 = objectInput.read();
                switch (n3) {
                    case 0: {
                        arrayList.add(null);
                        continue block12;
                    }
                    case 1: {
                        JaxbNode jaxbNode2;
                        Class<?> clazz;
                        String string = objectInput.readUTF();
                        try {
                            clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                            jaxbNode2 = (JaxbNode)clazz.newInstance();
                        }
                        catch (Exception exception) {
                            throw new ClassNotFoundException();
                        }
                        jaxbNode2.readExternal(objectInput, (XMLNode)this.jnode.getDOMNode());
                        arrayList.add(jaxbNode2);
                        continue block12;
                    }
                    case 2: {
                        JaxbListImpl jaxbListImpl;
                        String string = objectInput.readUTF();
                        Class<?> clazz = null;
                        try {
                            clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                            jaxbListImpl = (JaxbListImpl)clazz.newInstance();
                        }
                        catch (Exception exception) {
                            throw new ClassNotFoundException(string, exception);
                        }
                        jaxbListImpl.readExternal(objectInput, this.jnode);
                        arrayList.add(jaxbListImpl);
                        continue block12;
                    }
                    case 3: {
                        int n4 = objectInput.readInt();
                        while (n4 > n2) {
                            xMLNode = (XMLNode)xMLNode.getNextSibling();
                            ++n2;
                        }
                        arrayList.add(xMLNode);
                        continue block12;
                    }
                    case 4: {
                        arrayList.add(objectInput.readUTF());
                        continue block12;
                    }
                    default: {
                        throw new IOException();
                    }
                }
            }
        }
    }

    void setName(String string) {
        this.name = string;
    }

    void setNamespace(String string) {
        this.namespace = string;
    }

    public JaxbNode getOwner() {
        return this.jnode;
    }

    void setOwner(JaxbNode jaxbNode) {
        this.jnode = jaxbNode;
    }

    public void add(int n, Object object) {
        XMLNode xMLNode = null;
        XMLNode xMLNode2 = null;
        xMLNode = (XMLNode)this.nodeList.get(n);
        if (object instanceof JaxbNode) {
            this.jnode.syncOwnerDocument((JaxbNode)object);
            xMLNode2 = ((JaxbNode)object).getDOMNode();
            this.nodeList.add(n, xMLNode2);
            this.jnodeList.add(n, object);
        } else if (this.isAnyType && object instanceof XMLElement) {
            xMLNode2 = (XMLNode)object;
            this.nodeList.add(n, object);
            this.jnodeList.add(n, object);
        } else {
            xMLNode2 = this.createDOMNode(object);
            this.nodeList.add(n, xMLNode2);
            this.jnodeList.add(n, object);
        }
        this.jnode.getDOMNode().insertBefore((Node)xMLNode2, (Node)xMLNode);
    }

    void add2List(XMLNode xMLNode) {
        this.nodeList.add(xMLNode);
        this.jnodeList.add(xMLNode);
    }

    void add2List(JaxbNode jaxbNode) {
        this.nodeList.add(jaxbNode);
        this.jnodeList.add(jaxbNode);
    }

    @Override
    public boolean add(Object object) {
        XMLNode xMLNode = this.jnode.getNextNode(this.pos);
        XMLNode xMLNode2 = null;
        if (object instanceof JaxbNode) {
            this.jnode.syncOwnerDocument((JaxbNode)object);
            xMLNode2 = ((JaxbNode)object).getDOMNode();
            if (!(this.isAnyType || this.name.equals("") && this.namespace.equals(""))) {
                ((JaxbNode)object).resetTypeName(xMLNode2, this.name, this.namespace);
            }
            this.nodeList.add(xMLNode2);
            this.jnodeList.add(object);
        } else if (this.isAnyType && object instanceof XMLElement) {
            xMLNode2 = (XMLNode)object;
            this.nodeList.add(object);
            this.jnodeList.add(object);
        } else {
            xMLNode2 = this.createDOMNode(object);
            this.nodeList.add(xMLNode2);
            this.jnodeList.add(object);
        }
        this.jnode.getDOMNode().insertBefore((Node)xMLNode2, (Node)xMLNode);
        return true;
    }

    @Override
    public boolean addAll(Collection collection) {
        int n = collection.size();
        Iterator iterator = collection.iterator();
        for (int i = 0; i < n; ++i) {
            this.add(iterator.next());
        }
        return n != 0;
    }

    public boolean addAll(int n, Collection collection) {
        int n2 = collection.size();
        Iterator iterator = collection.iterator();
        for (int i = 0; i < n2; ++i) {
            Object e = iterator.next();
            this.add(n++, e);
        }
        return n2 != 0;
    }

    @Override
    public void clear() {
        this.jnodeList.clear();
        int n = this.nodeList.size();
        for (int i = 0; i < n; ++i) {
            this.jnode.getDOMNode().removeChild((Node)((XMLNode)this.nodeList.get(i)));
        }
        this.nodeList.clear();
    }

    @Override
    public boolean contains(Object object) {
        if (this.jnodeList.contains(object)) {
            return true;
        }
        String string = object.toString();
        int n = this.nodeList.size();
        XMLNode xMLNode = null;
        for (int i = 0; i < n; ++i) {
            xMLNode = (XMLNode)this.nodeList.get(i);
            if (!xMLNode.getText().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof List)) {
            return false;
        }
        int n = this.nodeList.size();
        if (n != ((List)object).size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.get(i).equals(((List)object).get(i))) continue;
            return false;
        }
        return true;
    }

    public Object get(int n) {
        Object e;
        Object object = null;
        try {
            e = this.jnodeList.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
        if (e instanceof XMLText) {
            object = ((XMLText)e).getText();
            this.jnodeList.set(n, object);
            return object;
        }
        if (this.isAnyType) {
            return e;
        }
        if (e instanceof XMLElement) {
            object = this.jnode.createJaxbNode((XMLNode)e);
            this.jnodeList.set(n, object);
            return object;
        }
        return e;
    }

    @Override
    public int hashCode() {
        return this.jnodeList.hashCode();
    }

    @Override
    public int indexOf(Object object) {
        if (this.jnodeList.contains(object)) {
            return this.jnodeList.indexOf(object);
        }
        int n = this.nodeList.size();
        XMLNode xMLNode = null;
        for (int i = 0; i < n; ++i) {
            xMLNode = (XMLNode)this.nodeList.get(i);
            if (!xMLNode.getText().equals(object.toString())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.jnodeList.isEmpty();
    }

    @Override
    public Iterator iterator() {
        int n = this.jnodeList.size();
        Object var2_2 = null;
        for (int i = 0; i < n; ++i) {
            var2_2 = this.jnodeList.get(i);
            if (!this.isAnyType && var2_2 instanceof XMLElement) {
                this.jnodeList.set(i, this.jnode.createJaxbNode(var2_2));
                continue;
            }
            if (!(var2_2 instanceof XMLText)) continue;
            this.jnodeList.set(i, ((XMLText)var2_2).getText());
        }
        return this.jnodeList.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = -1;
        if (this.jnodeList.contains(object)) {
            return this.jnodeList.lastIndexOf(object);
        }
        int n2 = this.nodeList.size();
        for (int i = 0; i < n2; ++i) {
            XMLNode xMLNode = (XMLNode)this.nodeList.get(i);
            if (!xMLNode.getText().equals(object.toString())) continue;
            n = i;
        }
        return n;
    }

    public ListIterator listIterator() {
        int n = this.jnodeList.size();
        Object var2_2 = null;
        for (int i = 0; i < n; ++i) {
            var2_2 = this.jnodeList.get(i);
            if (!this.isAnyType && var2_2 instanceof XMLElement) {
                this.jnodeList.set(i, this.jnode.createJaxbNode(var2_2));
                continue;
            }
            if (!(var2_2 instanceof XMLText)) continue;
            this.jnodeList.set(i, ((XMLText)var2_2).getText());
        }
        return this.jnodeList.listIterator();
    }

    public ListIterator listIterator(int n) {
        int n2 = this.jnodeList.size();
        Object var3_3 = null;
        for (int i = n; i < n2; ++i) {
            var3_3 = this.jnodeList.get(i);
            if (!this.isAnyType && var3_3 instanceof XMLElement) {
                this.jnodeList.set(i, this.jnode.createJaxbNode(var3_3));
                continue;
            }
            if (!(var3_3 instanceof XMLText)) continue;
            this.jnodeList.set(i, ((XMLText)var3_3).getText());
        }
        return this.jnodeList.listIterator(n);
    }

    public Object remove(int n) {
        XMLNode xMLNode = (XMLNode)this.nodeList.remove(n);
        this.jnode.getDOMNode().removeChild((Node)xMLNode);
        Object e = this.jnodeList.remove(n);
        if (!this.isAnyType && e instanceof XMLElement) {
            return this.jnode.createJaxbNode(xMLNode);
        }
        if (e instanceof XMLText) {
            return ((XMLText)e).getText();
        }
        return e;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.jnodeList.remove(n);
        XMLNode xMLNode = (XMLNode)this.nodeList.remove(n);
        this.jnode.getDOMNode().removeChild((Node)xMLNode);
        return true;
    }

    @Override
    public boolean removeAll(Collection collection) {
        boolean bl = false;
        int n = collection.size();
        Iterator iterator = collection.iterator();
        for (int i = 0; i < n; ++i) {
            Object e = iterator.next();
            if (!this.remove(e)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection collection) {
        boolean bl = false;
        int n = this.size();
        while (n > 0) {
            if (collection.contains(this.get(--n))) continue;
            this.remove(n);
            bl = true;
        }
        return bl;
    }

    public Object set(int n, Object object) {
        XMLNode xMLNode = null;
        XMLNode xMLNode2 = null;
        Object var5_5 = null;
        xMLNode = (XMLNode)this.nodeList.get(n);
        if (object instanceof JaxbNode) {
            this.jnode.syncOwnerDocument((JaxbNode)object);
            xMLNode2 = ((JaxbNode)object).getDOMNode();
            this.jnode.getDOMNode().replaceChild((Node)xMLNode2, (Node)xMLNode);
            this.nodeList.set(n, xMLNode2);
            this.jnodeList.set(n, object);
        } else if (this.isAnyType && object instanceof XMLNode) {
            this.nodeList.set(n, object);
            this.jnodeList.set(n, object);
        } else {
            xMLNode2 = this.createDOMNode(object);
            this.jnode.getDOMNode().replaceChild((Node)xMLNode2, (Node)xMLNode);
            this.nodeList.set(n, xMLNode2);
            this.jnodeList.set(n, object);
        }
        if (!this.isAnyType && xMLNode instanceof XMLElement) {
            return this.jnode.createJaxbNode((XMLNode)((XMLElement)xMLNode));
        }
        if (xMLNode instanceof XMLText) {
            return ((XMLText)xMLNode).getText();
        }
        return xMLNode;
    }

    public void setAnyType(boolean bl) {
        this.isAnyType = bl;
    }

    @Override
    public int size() {
        return this.nodeList.size();
    }

    public List subList(int n, int n2) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        int n3 = this.nodeList.size();
        if (n2 > n3) {
            n2 = n3;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > n2) {
            n = n2;
        }
        for (int i = n; i < n2; ++i) {
            arrayList.add(this.nodeList.get(i));
            arrayList2.add(this.jnodeList.get(i));
        }
        JaxbListImpl jaxbListImpl = new JaxbListImpl(this.name, this.namespace, arrayList, arrayList2, this.jnode, this.pos);
        return jaxbListImpl;
    }

    @Override
    public Object[] toArray() {
        int n = this.jnodeList.size();
        Object var2_2 = null;
        for (int i = 0; i < n; ++i) {
            var2_2 = this.jnodeList.get(i);
            if (!this.isAnyType && var2_2 instanceof XMLElement) {
                this.jnodeList.set(i, this.jnode.createJaxbNode(var2_2));
                continue;
            }
            if (!(var2_2 instanceof XMLText)) continue;
            this.jnodeList.set(i, ((XMLText)var2_2).getText());
        }
        return this.jnodeList.toArray();
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        int n = this.jnodeList.size();
        Object var3_3 = null;
        for (int i = 0; i < n; ++i) {
            var3_3 = this.jnodeList.get(i);
            if (!this.isAnyType && var3_3 instanceof XMLElement) {
                this.jnodeList.set(i, this.jnode.createJaxbNode(var3_3));
                continue;
            }
            if (!(var3_3 instanceof XMLText)) continue;
            this.jnodeList.set(i, ((XMLText)var3_3).getText());
        }
        return this.jnodeList.toArray(objectArray);
    }

    private XMLNode createDOMNode(Object object) {
        XMLNode xMLNode = null;
        XMLDocument xMLDocument = this.jnode.getOwnerDocument();
        XMLText xMLText = (XMLText)xMLDocument.createTextNode(object.toString());
        if (object instanceof XMLNode) {
            xMLNode = (XMLNode)xMLDocument.adoptNode((Node)((XMLNode)object));
        } else if (!this.isAnyType && !this.name.equals("")) {
            xMLNode = (XMLElement)xMLDocument.createElementNS(this.namespace, this.name);
            xMLNode.appendChild((Node)xMLText);
        } else {
            xMLNode = (XMLNode)xMLDocument.createTextNode(object.toString());
        }
        return xMLNode;
    }
}

