/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.util.LinkedList;
import oracle.xml.util.FastVector;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XPathSeqType;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLDocumentBuilder;
import oracle.xml.xslt.XSLEventHandler;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLFunctionDS;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;
import oracle.xml.xslt.XSLTDebuggerTraceEventVars;
import oracle.xml.xslt.XSLVariable;

public class XSLFunction
extends XSLNode
implements XSLConstants {
    private boolean override = true;
    private OXMLSequenceType asseq;
    XSLFunctionDS funcstruc = new XSLFunctionDS();
    private boolean funcadded = false;

    XSLFunction(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 6;
    }

    @Override
    public void processAction(XSLTContext xSLTContext) throws XSLException, XQException {
        Object object;
        int n;
        if (xSLTContext.isInDebugMode()) {
            this.addJDWPDataBefore(xSLTContext, this, "xsl:function", "function call", (byte)40);
            this.addParamValuesNums(xSLTContext);
        }
        this.setContextBaseURL(xSLTContext);
        this.setDefaultCollation(xSLTContext);
        if (xSLTContext.getOSBDebugMode()) {
            this.add2OSBDebugAttrs(xSLTContext, "name", this.funcstruc.funcqname);
            this.fireOSBDebuggerTraceEventBeforeExe(xSLTContext, this, "xsl:function");
        }
        XPathSequence[] xPathSequenceArray = new XPathSequence[this.nParams];
        for (n = this.nParams - 1; n >= 0; --n) {
            object = (XPathSequence)xSLTContext.popExprValue();
            xPathSequenceArray[n] = (XPathSequence)((XPathSequence)object).clone();
        }
        for (n = 0; n < this.nParams; ++n) {
            xSLTContext.pushVariable(xPathSequenceArray[n]);
            if (!xSLTContext.getOSBDebugMode()) continue;
            object = (XSLVariable)this.paramList.elementAt(n);
            XSLTDebuggerTraceEventVars xSLTDebuggerTraceEventVars = new XSLTDebuggerTraceEventVars((XSLVariable)object, false);
            xSLTContext.pushOSBDebugVar(xSLTDebuggerTraceEventVars);
            ((XSLVariable)object).setParamPos(n + 1);
            xSLTDebuggerTraceEventVars.setParamPos(n + 1);
            xSLTDebuggerTraceEventVars.setValue(xPathSequenceArray[n]);
            this.fireOSBDebuggerTraceEventBeforeExe(xSLTContext, (XSLNode)object, "xsl:" + ((XSLVariable)object).localName);
            this.fireOSBDebuggerTraceEventAfterExe(xSLTContext, (XSLNode)object, "xsl:" + ((XSLVariable)object).localName);
        }
        this.getValue(xSLTContext, xSLTContext.pushExprValue());
        if (xSLTContext.getOSBDebugMode()) {
            this.fireOSBDebuggerTraceEventAfterExe(xSLTContext, this, "xsl:function");
        }
        if (xSLTContext.isInDebugMode()) {
            this.addJDWPDataAfter(this, (byte)41, null);
        }
    }

    @Override
    public void appendChild(XSLNode xSLNode) throws XSLException {
        super.appendChild(xSLNode);
        if (xSLNode instanceof XSLVariable && xSLNode.namespace == "http://www.w3.org/1999/XSL/Transform" && xSLNode.localName == "param") {
            if (this.paramList == null) {
                this.paramList = new FastVector(4);
            }
            this.paramList.addElement(xSLNode);
            ++this.nParams;
            this.children.setSize(this.children.size() - 1);
        } else if (!this.funcadded) {
            this.funcstruc.arity = this.nParams;
            this.funcstruc.node = this;
            this.xss.addUserDefinedFunctionToPool(this.funcstruc);
            this.funcadded = true;
        }
    }

    @Override
    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (string == "" && string3 == "name") {
            this.funcstruc.funcqname = this.resolveQname(string4);
        } else if (string == "" && string3 == "override") {
            this.override = !string4.equals("no");
        } else if (string == "" && string3 == "as") {
            this.asseq = XPathSeqType.createSequenceType(string4, this, this.xss);
        }
        super.setAttribute(string, string2, string3, string4);
    }

    @Override
    public void startContent() throws XSLException {
        if (this.funcstruc.funcqname == null) {
            this.xss.err.error2(1009, 1, "name", this.getQualifiedName());
        }
    }

    @Override
    void endContent() throws XSLException, XQException {
        super.endContent();
    }

    @Override
    public void finalizeXSLNode() throws XSLException, XQException {
        for (int i = 0; i < this.nParams; ++i) {
            ((XSLNode)this.paramList.elementAt(i)).finalizeXSLNode();
        }
        super.finalizeXSLNode();
    }

    public boolean getOverride() {
        return this.override;
    }

    private void getValue(XSLTContext xSLTContext, OXMLSequence oXMLSequence) throws XSLException, XQException {
        XSLDocumentBuilder xSLDocumentBuilder = xSLTContext.allocXSLDocumentBuilder();
        XSLEventHandler xSLEventHandler = xSLTContext.allocXSLEventHandler();
        xSLEventHandler.reset(xSLDocumentBuilder, xSLDocumentBuilder, xSLTContext);
        xSLDocumentBuilder.setVariableContext(true);
        XSLEventHandler xSLEventHandler2 = xSLTContext.getEventHandler();
        xSLTContext.setEventHandler(xSLEventHandler);
        this.processChildren(xSLTContext);
        xSLEventHandler.flushEvents();
        XPathItem xPathItem = xSLTContext.allocItem();
        ((OXMLItem)xPathItem).setNode(xSLDocumentBuilder.getResultFragment());
        oXMLSequence.appendItem(xPathItem);
        xSLTContext.setEventHandler(xSLEventHandler2);
        xSLDocumentBuilder.setVariableContext(false);
        xSLTContext.freeXSLDocumentBuilder(xSLDocumentBuilder);
        xSLTContext.freeXSLEventHandler(xSLEventHandler);
    }

    private void addParamValuesNums(XSLTContext xSLTContext) {
        LinkedList linkedList = xSLTContext.xsl.getFrameParams();
        linkedList.set(linkedList.size() - 1, new Integer(this.nParams + 1));
        LinkedList linkedList2 = (LinkedList)xSLTContext.xsl.getFrameValues().get(xSLTContext.xsl.getFrames().size() - 1);
        for (int i = 0; i < this.nParams; ++i) {
            XPathSequence xPathSequence = (XPathSequence)xSLTContext.peekExprValue(this.nParams - i - 1).clone();
            linkedList2.add(xPathSequence);
        }
    }
}

