/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.servlet.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import oracle.i18n.servlet.ApplicationContext;
import oracle.i18n.servlet.GeneralHelper;
import oracle.i18n.servlet.ServletHelper;
import oracle.i18n.servlet.localesource.LocaleSource;
import oracle.i18n.servlet.localesource.NonCachedUserInput;
import oracle.i18n.util.LocaleMapper;

public class ServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final String M_C_COMMAND_STORE = "store";
    private static final String M_C_COMMAND_CLEAN = "clean";
    private static final String M_C_USER_AGENT = "User-Agent";
    private static final String M_C_ISO_8859_1 = "iso-8859-1";
    private final ApplicationContext m_appctx;
    private final Map m_pmap;
    private final String m_orgcharset;
    private final HttpServletRequest m_request;
    private LocaleSource m_locsrc;
    private String m_pagecharset;

    public ServletRequestWrapper(HttpServletRequest httpServletRequest) throws IOException {
        super(httpServletRequest);
        String string = httpServletRequest.getParameter("dummy");
        this.m_request = httpServletRequest;
        String string2 = super.getCharacterEncoding();
        this.m_orgcharset = string2 != null ? string2 : M_C_ISO_8859_1;
        this.m_pmap = Collections.synchronizedMap(new HashMap(super.getParameterMap()));
        this.m_appctx = ServletHelper.getApplicationContextInstance(httpServletRequest);
        if (this.m_appctx != null) {
            this.refresh();
        } else {
            this.m_locsrc = null;
        }
    }

    public void refresh() {
        this.m_locsrc = null;
        this.m_pagecharset = null;
        this.runCommand(this.m_request);
        this.m_locsrc = this.getCurrentLocale(this.m_request);
        this.getCharacterEncoding();
        this.m_request.getSession().setAttribute("oracle.i18n.servlet.localesource.LocaleSource.sessionkey", (Object)this.m_locsrc);
    }

    private boolean runCommand(HttpServletRequest httpServletRequest) {
        String string = this.getRawParameter(this.m_appctx.getParameterName(LocaleSource.Parameter.COMMAND));
        if (string == null || string.equals("")) {
            return false;
        }
        if (string.equals(M_C_COMMAND_STORE)) {
            LocaleSource localeSource = NonCachedUserInput.getInstance((HttpServletRequest)this);
            List list = this.m_appctx.getLocaleSourceList();
            List list2 = this.m_appctx.getLocaleSourceGetInstanceList();
            try {
                for (int i = 0; i < list2.size(); ++i) {
                    Object[] objectArray = (Object[])list.get(i);
                    httpServletRequest.setAttribute("oracle.i18n.servlet.localesource.LocaleSource.paramkey", objectArray[1]);
                    Method method = (Method)list2.get(i);
                    LocaleSource localeSource2 = (LocaleSource)method.invoke(null, new Object[]{this});
                    if (localeSource2 == null || localeSource2.isReadOnly()) continue;
                    localeSource2.setLocaleSource(localeSource);
                    localeSource2.store();
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException.getMessage());
            }
            httpServletRequest.getSession().removeAttribute("oracle.i18n.servlet.filter.cache");
            return true;
        }
        if (string.equals(M_C_COMMAND_CLEAN)) {
            httpServletRequest.getSession().removeAttribute("oracle.i18n.servlet.filter.cache");
            return true;
        }
        return false;
    }

    public Locale getLocale() {
        return this.m_locsrc.getLocale();
    }

    public Enumeration getLocales() {
        Vector<Locale> vector = new Vector<Locale>(1);
        vector.add(this.m_locsrc.getLocale());
        return vector.elements();
    }

    private String convertToCurrentCharset(String string) {
        try {
            return new String(string.getBytes(this.m_orgcharset), LocaleMapper.getJavaCharacterSet(2, this.getCharacterEncoding()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException.getMessage());
        }
    }

    public String getCharacterEncoding() {
        if (this.m_pagecharset != null) {
            return this.m_pagecharset;
        }
        if (this.m_locsrc != null) {
            this.m_pagecharset = this.m_appctx.getIANAPageCharacterSet(this.m_locsrc.getLocale(), super.getHeader(M_C_USER_AGENT));
            return this.m_pagecharset;
        }
        return M_C_ISO_8859_1;
    }

    public String getRawParameter(String string) {
        if (this.m_pmap == null) {
            return null;
        }
        Object v = this.m_pmap.get(string);
        if (v == null) {
            return null;
        }
        if (v.getClass().isArray()) {
            return ((String[])v)[0];
        }
        return (String)v;
    }

    public String getParameter(String string) {
        String string2 = this.getRawParameter(string);
        if (string2 == null) {
            return super.getParameter(string);
        }
        return this.convertToCurrentCharset(string2);
    }

    public String[] getParameterValues(String string) {
        if (this.m_pmap == null) {
            return null;
        }
        Object v = this.m_pmap.get(string);
        if (v == null) {
            return super.getParameterValues(string);
        }
        if (v.getClass().isArray()) {
            String[] stringArray = (String[])v;
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = this.convertToCurrentCharset(stringArray[i]);
            }
            return stringArray2;
        }
        return new String[]{this.convertToCurrentCharset((String)v)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getParameterMap() {
        if (this.m_pmap == null) {
            return super.getParameterMap();
        }
        Map map = this.m_pmap;
        synchronized (map) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(this.m_pmap.size());
            for (String string : this.m_pmap.keySet()) {
                Object v = this.m_pmap.get(string);
                if (v.getClass().isArray()) {
                    String[] stringArray = (String[])v;
                    String[] stringArray2 = new String[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray2[i] = this.convertToCurrentCharset(stringArray[i]);
                    }
                    hashMap.put(string, stringArray2);
                    continue;
                }
                hashMap.put(string, this.convertToCurrentCharset((String)v));
            }
            return Collections.unmodifiableMap(hashMap);
        }
    }

    public Enumeration getParameterNames() {
        if (this.m_pmap == null) {
            return super.getParameterNames();
        }
        return Collections.enumeration(this.m_pmap.keySet());
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        if (this.m_appctx.isIANAPageCharacterSetForcedSet()) {
            return;
        }
        super.setCharacterEncoding(string);
        String string2 = LocaleMapper.getJavaCharacterSet(2, string);
        if (string2 == null) {
            throw new UnsupportedEncodingException(string);
        }
        this.m_pagecharset = string;
    }

    private LocaleSource getCurrentLocale(HttpServletRequest httpServletRequest) {
        List list = this.m_appctx.getLocaleSourceList();
        List list2 = this.m_appctx.getLocaleSourceGetInstanceList();
        try {
            for (int i = 0; i < list.size(); ++i) {
                Object[] objectArray = (Object[])list.get(i);
                Class clazz = (Class)objectArray[0];
                Object object = Boolean.TRUE;
                httpServletRequest.setAttribute("oracle.i18n.servlet.localesource.LocaleSource.paramkey", objectArray[1]);
                try {
                    object = clazz.getMethod("isAccessible", GeneralHelper.ARG_HTTP_SERVLET_REQUEST_CLASS).invoke(null, new Object[]{this});
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (!Boolean.TRUE.equals(object)) continue;
                Method method = (Method)list2.get(i);
                LocaleSource localeSource = (LocaleSource)method.invoke(null, new Object[]{this});
                if (localeSource == null) continue;
                return localeSource;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_appctx.getApplicationDefaultLocaleSource();
    }
}

