/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.import_;

import java.awt.Component;
import java.awt.Container;
import java.net.URL;
import java.util.Map;
import javax.swing.JComponent;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ideri.util.Product;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.control.CVSHintContainer;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.ui.CVSImportSourcesPageUI;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardPage;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardValidationException;
import oracle.jdevimpl.vcs.cvs.wiz.import_.CVSImportModelKey;

public final class CVSImportSourcesPage
extends CVSWizardPage
implements CVSImportModelKey {
    private JComponent _panel = null;
    private CVSImportSourcesPageUI _ui = new CVSImportSourcesPageUI();

    CVSImportSourcesPage() {
        this.createPanel();
    }

    private void createPanel() {
        CVSResourcePicker.getPicker(this.getClass()).start((Container)this._ui);
        this._ui.getChooserPanel().setChooseFolders(true);
        this._ui.getSourcesLabel().setLabelFor(this._ui.getChooserPanel().getFocusComponent());
        String hint = CVSArb.get("IMPORT_SOURCES_PAGE_HINT");
        this._panel = new CVSHintContainer(hint, this._ui);
    }

    @Override
    public String getAccessibleDescription() {
        return CVSArb.get("IMPORT_SOURCES_PAGE_HINT");
    }

    @Override
    public String getHelpTopic() {
        return "f1_cvsimpwsources_html";
    }

    @Override
    public JComponent getPanel() {
        return this._panel;
    }

    @Override
    public Component getFocusComponent() {
        return this._ui.getChooserPanel().getFocusComponent();
    }

    @Override
    public String getLabel() {
        return CVSArb.get("IMPORT_SOURCES_PAGE_LABEL");
    }

    @Override
    public Object[] getPropertyKeys() {
        return new Object[]{KEY_IMPORT_SOURCES};
    }

    @Override
    public void populatePage(Map props) {
        Object value = props.get(KEY_IMPORT_SOURCES);
        if (value != null) {
            this._ui.getChooserPanel().setURL(URLFactory.newFileURL((String)value.toString()));
            return;
        }
        URL url = this.getDefaultChooserURL();
        if (url != null) {
            this._ui.getChooserPanel().setURL(url);
        }
    }

    @Override
    public void validatePage() throws CVSWizardException {
        URL folder = this._ui.getChooserPanel().getURL();
        if (folder == null || !URLFileSystem.exists((URL)folder) || !URLFileSystem.isDirectory((URL)folder)) {
            throw new CVSWizardValidationException(CVSArb.get("IMPORT_SOURCES_PAGE_ERROR_1"));
        }
        if (URLFileSystem.isRoot((URL)folder)) {
            throw new CVSWizardValidationException(CVSArb.get("IMPORT_SOURCES_PAGE_ERROR_2"));
        }
    }

    @Override
    public void applyPage(Map props) {
        URL url = this._ui.getChooserPanel().getURL();
        url = URLFileSystem.canonicalize((URL)url);
        props.put(KEY_IMPORT_SOURCES, VCSFileSystemUtils.getPlatformPathName((URL)url));
    }

    private URL getDefaultChooserURL() {
        URL url = !Product.isRaptor() ? CVSUtil.getContextDirectoryURL(this.getContext()) : Ide.getWorkspaces().getWorkDirectory();
        return URLFileSystem.exists((URL)url) ? url : URLFactory.newFileURL((String)System.getProperty("user.home"));
    }
}

