/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.util;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.EnvironmentVariables;
import oracle.jdeveloper.vcs.util.VCSOperatingSystem;
import oracle.jdevimpl.vcs.cvs.util.CVSEnvironmentVarConstants;
import oracle.jdevimpl.vcs.cvs.util.CVSFileConstants;

public final class CVSEnvironmentVars
implements CVSEnvironmentVarConstants {
    private static final CVSEnvironmentVars _inst = new CVSEnvironmentVars();
    private Map _vars = new HashMap(EnvironmentVariables.get());

    private CVSEnvironmentVars() {
        URL home = URLFactory.newDirURL((String)System.getProperty("user.home"));
        home = URLFileSystem.canonicalize((URL)home);
        String homedrive = null;
        String homepath = URLFileSystem.getPlatformPathName((URL)home);
        if (!this._vars.containsKey("HOME")) {
            this._vars.put("HOME", homepath);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(homepath);
        sb.append(CVSFileConstants.separator);
        sb.append(".cvspass");
        this._vars.put("CVS_PASSFILE", sb.toString());
        if (!VCSOperatingSystem.isWindows()) {
            return;
        }
        int i = homepath.indexOf(58);
        if (i > 0 && i < homepath.length() - 1) {
            homedrive = homepath.substring(0, i + 1);
            homepath = homepath.substring(i + 1);
        }
        if (homedrive != null) {
            this._vars.put("HOMEDRIVE", homedrive);
        }
        this._vars.put("HOMEPATH", homepath);
    }

    public static final CVSEnvironmentVars getInstance() {
        return _inst;
    }

    public final String getVariable(String name) {
        return (String)this._vars.get(name.toUpperCase());
    }

    public final Map getVariables() {
        return new HashMap(this._vars);
    }
}

