/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.options.builder;

import java.awt.Component;
import java.awt.Insets;
import java.util.Comparator;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionArgument;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionBuilder;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionException;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionLayoutBuilder;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionResources;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionStructure;
import oracle.jdevimpl.vcs.cvs.options.CVSWatchCommand;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSWatchCommandTypeBuilder
extends CVSOptionBuilder {
    private JLabel _commandTypeLabel;
    private JComboBox _commandTypeComboBox;

    public CVSWatchCommandTypeBuilder() {
        super(CVSOptionId.WATCH_COMMAND_TYPE);
    }

    @Override
    public Object clone() {
        return new CVSWatchCommandTypeBuilder();
    }

    @Override
    public Component getFocusComponent() {
        return this._commandTypeComboBox;
    }

    @Override
    public boolean isSingleBoolean() {
        return false;
    }

    @Override
    protected void createComponents(CVSOptionResources resources) {
        this._commandTypeLabel = new JLabel();
        this._commandTypeComboBox = new JComboBox();
        SortedComboBoxModel commandTypeComboBoxModel = new SortedComboBoxModel();
        commandTypeComboBoxModel.setComparator(new Comparator(){

            public final int compare(Object o1, Object o2) {
                o1 = CVSWatchCommandTypeBuilder.this.convertWatchCommandToRenderedValue(o1);
                o2 = CVSWatchCommandTypeBuilder.this.convertWatchCommandToRenderedValue(o2);
                return o1.toString().compareTo(o2.toString());
            }
        });
        commandTypeComboBoxModel.addElement((Object)CVSWatchCommand.ON);
        commandTypeComboBoxModel.addElement((Object)CVSWatchCommand.OFF);
        commandTypeComboBoxModel.addElement((Object)CVSWatchCommand.ADD);
        commandTypeComboBoxModel.addElement((Object)CVSWatchCommand.REMOVE);
        this._commandTypeComboBox.setModel(commandTypeComboBoxModel);
        this._commandTypeComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public final Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                value = CVSWatchCommandTypeBuilder.this.convertWatchCommandToRenderedValue(value);
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this._commandTypeComboBox.setSelectedItem((Object)CVSWatchCommand.ADD);
        ResourceUtils.resLabel((JLabel)this._commandTypeLabel, (Component)this._commandTypeComboBox, (String)resources.getLabel(this.getId()));
    }

    @Override
    protected void attachListeners(CVSOptionStructure structure) {
    }

    @Override
    protected void buildLayout(CVSOptionLayoutBuilder layoutBuilder, Insets i) {
        layoutBuilder.add(this._commandTypeLabel, i, 2, false, false);
        layoutBuilder.add(this._commandTypeComboBox, i, 1, false, false);
        layoutBuilder.addHFiller();
        layoutBuilder.nl();
    }

    @Override
    protected void setValuesImpl(Map customizerOptions) {
        CVSWatchCommand commandType = (CVSWatchCommand)((Object)customizerOptions.get((Object)CVSOptionArgument.WATCH_COMMAND));
        if (commandType != null) {
            this._commandTypeComboBox.setSelectedItem((Object)commandType);
        }
    }

    @Override
    protected void validateValuesImpl() throws CVSOptionException {
    }

    @Override
    protected void commitValuesImpl(Map customizerOptions) {
        customizerOptions.put(CVSOptionArgument.WATCH_COMMAND, this._commandTypeComboBox.getSelectedItem());
    }

    private String convertWatchCommandToRenderedValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o == CVSWatchCommand.ON) {
            o = CVSArb.get("WATCH_COMMAND_ON");
        }
        if (o == CVSWatchCommand.OFF) {
            o = CVSArb.get("WATCH_COMMAND_OFF");
        }
        if (o == CVSWatchCommand.ADD) {
            o = CVSArb.get("WATCH_COMMAND_ADD");
        }
        if (o == CVSWatchCommand.REMOVE) {
            o = CVSArb.get("WATCH_COMMAND_REMOVE");
        }
        return o.toString();
    }
}

