/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.options.builder;

import java.awt.Component;
import java.awt.Insets;
import java.net.URL;
import java.util.Map;
import javax.swing.JLabel;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagCategory;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagChooser;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagField2;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionArgument;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionBuilder;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionException;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionLayoutBuilder;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionResources;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSTagTagNameBuilder
extends CVSOptionBuilder {
    private JLabel _tagNameLabel;
    private CVSTagField2 _tagField;

    public CVSTagTagNameBuilder() {
        super(CVSOptionId.TAG_TAG_NAME);
    }

    protected CVSTagTagNameBuilder(CVSOptionId optionId) {
        super(optionId);
    }

    @Override
    public Object clone() {
        return new CVSTagTagNameBuilder();
    }

    @Override
    public Component getFocusComponent() {
        return this._tagField.getTextField();
    }

    @Override
    public boolean isSingleBoolean() {
        return false;
    }

    @Override
    protected void populate(URL[] contextUrls) {
        CVSTagChooser tagChooser = new CVSTagChooser(new CVSTagCategory[]{CVSTagCategory.VERSION}, contextUrls, CVSTagChooser.ViewMode.LIST);
        this._tagField.start(tagChooser);
    }

    @Override
    protected void dispose() {
        this._tagField.stop();
    }

    @Override
    protected void createComponents(CVSOptionResources resources) {
        super.createComponents(resources);
        this._tagField = new CVSTagField2();
        this._tagNameLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._tagNameLabel, (Component)this._tagField.getTextField(), (String)resources.getLabel(this.getId()));
    }

    @Override
    protected void createOptionComponent(CVSOptionResources resources) {
    }

    @Override
    protected void buildLayout(CVSOptionLayoutBuilder layoutBuilder, Insets i) {
        layoutBuilder.add(this._tagNameLabel, i, 2, false, false);
        layoutBuilder.add(this._tagField, i, 1, false, false);
        layoutBuilder.addHFiller();
        layoutBuilder.nl();
    }

    @Override
    protected void setValuesImpl(Map customizerOptions) {
        String tagName = (String)customizerOptions.get((Object)CVSOptionArgument.TAG_NAME);
        if (tagName != null) {
            this._tagField.getTextField().setText(tagName);
        }
    }

    @Override
    protected void validateValuesImpl() throws CVSOptionException {
        if (this._tagField.getNameOrTagValue() != null && CVSUtil.hasWhitespace(this._tagField.getNameOrTagValue())) {
            throw new CVSOptionException(CVSArb.get("ERROR_TAG_NAME_WHITESPACE"));
        }
    }

    @Override
    protected void commitValuesImpl(Map customizerOptions) {
        customizerOptions.put(CVSOptionArgument.TAG_NAME, this._tagField.getNameOrTagValue());
    }
}

