/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.VetoableChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.spi.VCSCommandState;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.spi.VCSValidationException;
import oracle.jdeveloper.vcs.spi.VCSWaitRunnable;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSChangeListWindow;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSComponents;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSMergeEditor;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSEntriesFile;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionArgument;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionCategory;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionDirector;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionsCustomizer;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;
import oracle.jdevimpl.vcs.cvs.util.CVSMessageDialog;

public class CVSOperationUpdate
extends CVSAbstractCommand {
    public CVSOperationUpdate() {
        super(CVSCommandConstants.OPERATION_UPDATE_CMD_ID, VCSCommandStyle.MULTI);
    }

    protected CVSOperationUpdate(int id) {
        super(id, VCSCommandStyle.MULTI);
    }

    protected Locatable[] getLocatablesToUpdate() throws Exception {
        return this.getContextLocatables();
    }

    protected boolean isOpenSessionUpdateSelection(Locatable[] locatables) {
        return super.isOpenSessionSelection(locatables);
    }

    protected VCSStatusFilter getStatusFilter() {
        return this.createStatusFilter(new VCSStatus[]{CVSFileStatus.STATUS_LOCALLY_CHANGED, CVSFileStatus.STATUS_UNMODIFIED_READWRITE, CVSFileStatus.STATUS_UNMODIFIED_READONLY, CVSFileStatus.STATUS_SANDBOX});
    }

    protected boolean isAvailableImpl() throws Exception {
        Locatable[] locatables = this.getLocatablesToUpdate();
        if (!this.isOpenSessionUpdateSelection(locatables)) {
            return false;
        }
        return this.isAvailableImpl(locatables);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!URLFileSystem.exists((URL)url)) {
            return this.isChangeListNewFile(url);
        }
        return super.isAvailableImpl(url);
    }

    protected int doitImpl() throws Exception {
        Locatable[] locatables = this.getLocatablesToUpdate();
        URL[] urls = VCSModelUtils.convertNodesToURLs((Locatable[])locatables);
        Node[] affectedNodes = CVSUtil.getCachedBaseURLNodes(urls);
        LinkedHashSet<Node> nodesToSave = new LinkedHashSet<Node>();
        nodesToSave.addAll(Arrays.asList(affectedNodes));
        if (!CVSUtil.saveDirtyNodes(nodesToSave)) {
            return 1;
        }
        Collection nodesPreCoalesce = this.getFilteredSelection(locatables);
        for (int i = 0; i < locatables.length; ++i) {
            if (!this.isChangeListNewFile(locatables[i].getURL())) continue;
            nodesPreCoalesce.add(locatables[i]);
        }
        Collection nodes = this.coalesceNodesForUpdate(nodesPreCoalesce);
        if (nodes.size() <= 0) {
            return 9;
        }
        Map timestampMap = VCSBufferUtils.storeTimestamps(Arrays.asList(affectedNodes));
        VCSDirectoryInvokableState invokableState = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Collection)nodes));
        VCSCommandState state = new VCSCommandState(invokableState, timestampMap);
        if (this.getContext().getView() instanceof CVSChangeListWindow && (this.isActionLocal() || this.getContext().getBoolean("CVSClient.localActionSource"))) {
            VCSOptionsCustomizer customizer = CVSClient.getInstance().getChangeListOptionsCustomizer();
            return this.updateSilently(nodes, affectedNodes, state, customizer);
        }
        CVSOptionsCustomizer customizer = this.createOptionsCustomizer(nodes.toArray(new Locatable[0]));
        return this.update(nodes, affectedNodes, state, customizer);
    }

    protected Collection coalesceNodesForUpdate(Collection nodes) {
        return this.coalesceNodesForFolderOperation(nodes);
    }

    protected void noOpImpl() throws VCSValidationException {
        throw new VCSValidationException(CVSArb.get("ERROR_UPDATE_FILTERED_TITLE"), CVSArb.format("ERROR_UPDATE_FILTERED", ProductInformation.getProductInformation().getShortName()));
    }

    private boolean isChangeListNewFile(URL url) {
        if (url == null) {
            return false;
        }
        if (URLFileSystem.exists((URL)url)) {
            return false;
        }
        return CVSUtil.isUnderCVS(URLFileSystem.getParent((URL)url));
    }

    private int updateSilently(Collection nodes, final Node[] affectedNodes, final VCSCommandState state, VCSOptionsCustomizer customizer) {
        VCSWaitRunnable r = new VCSWaitRunnable(this.getExceptionHandler(), customizer){
            private boolean result;
            {
                super(x0, x1);
                this.result = true;
            }

            protected final void runImpl() throws Exception {
                this.result = CVSOperationUpdate.this.doCommitOperationImpl((Component)Ide.getMainWindow(), this.getOptions(), state);
            }

            protected final void runPostOperationAWT() throws Exception {
                CVSOperationUpdate.this.postUpdate(state, affectedNodes, this.result);
            }
        };
        Thread t = new Thread((Runnable)r, "CVSOperationUpdate");
        t.start();
        return 0;
    }

    private int update(Collection nodes, Node[] affectedNodes, final VCSCommandState state, CVSOptionsCustomizer customizer) throws Exception {
        final JEWTDialog dialog = this.createOperationDialog(nodes, customizer);
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){

            protected final boolean doCommitOperation(Map options) throws Exception {
                return CVSOperationUpdate.this.doCommitOperationImpl((Component)dialog, options, state);
            }
        });
        boolean dialogSuccessful = CVSDialogRunner.runDialog((JDialog)dialog);
        if (customizer != null) {
            customizer.dispose();
        }
        this.postUpdate(state, affectedNodes, dialogSuccessful);
        return !dialogSuccessful ? 1 : 0;
    }

    private void postUpdate(VCSCommandState state, Node[] affectedNodes, boolean result) throws Exception {
        Collection processedUrls = state.getInvokableState().getProcessedURLs();
        URL[] processedUrlArray = processedUrls.toArray(new URL[0]);
        this.fireFileStructureChanged(processedUrlArray);
        this.fireSomeFilesDeleted(processedUrlArray);
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear(processedUrlArray, Depth.INFINITY);
        if (processedUrls.size() > 0) {
            VCSBufferUtils.reloadBuffers((Map)state.getTimestampMap());
        }
        boolean conflicts = false;
        if (result) {
            CVSClient.getInstance();
            VCSStatus[] postStatuses = (VCSStatus[])CVSClient.getStatusCache().get(VCSModelUtils.convertNodesToURLs((Locatable[])affectedNodes));
            for (int i = 0; i < postStatuses.length && !conflicts; ++i) {
                conflicts = postStatuses[i] == CVSFileStatus.STATUS_CONFLICTS;
            }
        }
        if (conflicts) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CVSChangeListWindow changeListWindow = CVSClient.invokePendingChanges();
                    if (changeListWindow != null) {
                        changeListWindow.activateOutgoingChanges();
                        changeListWindow.displayOutgoingConflicts();
                    }
                }
            });
        }
        if (result && !conflicts && this.getContext().getBoolean("CVSClient.updateFromCommit")) {
            IdeAction.get((int)CVSCommandConstants.OPERATION_COMMIT_CMD_ID).performAction(this.getContext());
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CVSOperationUpdate.this.getContext().getView() instanceof CVSChangeListWindow) {
                    ((CVSChangeListWindow)CVSOperationUpdate.this.getContext().getView()).getIncomingChangeList().refresh();
                }
            }
        });
    }

    private CVSOptionsCustomizer createOptionsCustomizer(Locatable[] contextLocatables) {
        Map changeListOptions;
        boolean updateFromCommit;
        CVSOptionDirector optionDirector = new CVSOptionDirector(contextLocatables);
        ArrayList<CVSOptionId> optionIds = new ArrayList<CVSOptionId>(Arrays.asList(CVSOptionId.COMMON_USE_REVISION, CVSOptionId.UPDATE_CLEAN_UPDATE, CVSOptionId.COMMON_LOCAL_FOLDER_ONLY));
        if (CVSClient.getInstance().isAdvancedModeSet()) {
            optionIds.remove((Object)CVSOptionId.COMMON_USE_REVISION);
        }
        if (updateFromCommit = this.getContext().getBoolean("CVSClient.updateFromCommit")) {
            optionIds.clear();
        }
        optionDirector.registerCategoryOptions(CVSOptionCategory.BASIC, optionIds.toArray(new CVSOptionId[0]));
        optionDirector.registerCategoryOptions(CVSOptionCategory.ADVANCED, new CVSOptionId[]{CVSOptionId.COMMON_USE_REVISION_OR_DATE_AND_FORCE, CVSOptionId.UPDATE_CREATE_FOLDERS, CVSOptionId.UPDATE_PRUNE_FOLDERS, CVSOptionId.UPDATE_RESET_TAGS});
        if (!CVSClient.getInstance().isAdvancedModeSet()) {
            optionDirector.deregisterCategoryOptions(CVSOptionCategory.ADVANCED);
        }
        if (updateFromCommit) {
            optionDirector.deregisterCategoryOptions(CVSOptionCategory.ADVANCED);
        }
        CVSOptionsCustomizer customizer = new CVSOptionsCustomizer(optionDirector.constructOptionComponents());
        HashMap defaultOptionsValues = new HashMap();
        this.ensureDefaultOptions(defaultOptionsValues);
        if (this.getContext().getView() instanceof CVSChangeListWindow && this.isActionLocal() && (changeListOptions = CVSClient.getInstance().getChangeListOptionsCustomizer().getOptions()) != null) {
            defaultOptionsValues.putAll(changeListOptions);
        }
        customizer.setDefaultOptionValues(defaultOptionsValues);
        return customizer;
    }

    private void ensureDefaultOptions(Map optionsMap) {
        if (!optionsMap.containsKey((Object)CVSOptionId.UPDATE_CREATE_FOLDERS)) {
            optionsMap.put(CVSOptionId.UPDATE_CREATE_FOLDERS, Boolean.TRUE);
        }
        if (!optionsMap.containsKey((Object)CVSOptionId.UPDATE_PRUNE_FOLDERS)) {
            optionsMap.put(CVSOptionId.UPDATE_PRUNE_FOLDERS, Boolean.TRUE);
        }
    }

    private boolean doCommitOperationImpl(Component dialog, Map optionsMap, VCSCommandState state) throws Exception {
        if (optionsMap != null) {
            optionsMap = new HashMap(optionsMap);
            this.ensureDefaultOptions(optionsMap);
        }
        DeterminateProgressMonitor monitor = this.createProgressMonitor(dialog);
        if (!this.confirmCleanUpdate(optionsMap, state)) {
            return false;
        }
        Object value = optionsMap != null ? optionsMap.get((Object)CVSOptionId.UPDATE_CLEAN_UPDATE) : null;
        boolean clean = value != null ? (Boolean)value : false;
        value = optionsMap != null ? optionsMap.get((Object)CVSOptionId.COMMON_LOCAL_FOLDER_ONLY) : null;
        final boolean local = value != null ? (Boolean)value : false;
        final CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setCommand_("update");
        runner.getParameters().setQuiet(false);
        if (optionsMap != null) {
            optionsMap.keySet().retainAll(Arrays.asList(new Object[]{CVSOptionId.COMMON_USE_REVISION, CVSOptionId.UPDATE_CLEAN_UPDATE, CVSOptionId.COMMON_LOCAL_FOLDER_ONLY, CVSOptionId.COMMON_USE_REVISION_OR_DATE_AND_FORCE, CVSOptionArgument.REVISION_NAME, CVSOptionArgument.REVISION_DATE, CVSOptionArgument.FORCE_MATCH, CVSOptionId.UPDATE_CREATE_FOLDERS, CVSOptionId.UPDATE_PRUNE_FOLDERS, CVSOptionId.UPDATE_RESET_TAGS}));
            runner.getParameters().setBuilderOptions(optionsMap);
        }
        state.setInvokableState(this.coalesceStateForFolderOperation(optionsMap, state.getInvokableState()));
        if (clean) {
            ArrayList<URL> urls = new ArrayList<URL>(Arrays.asList(state.getInvokableState().getURLs()));
            DeletionOrderComparator comparator = new DeletionOrderComparator();
            Collections.sort(urls, comparator);
            CVSUtil.deleteFiles(!local, comparator, urls.toArray(new URL[0]));
        }
        CVSDirectoryInvokable invokable = new CVSDirectoryInvokable(state.getInvokableState()){

            @Override
            protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                Collection archiveDirectoryUrls = null;
                if (CVSMergeEditor.getClientSideMergeSettingImpl()) {
                    archiveDirectoryUrls = CVSOperationUpdate.this.copyEntriesToEntriesDotArchive(parent, invokeUrls, local);
                }
                String[] filenames = VCSFileSystemUtils.getURLFileNames((URL[])invokeUrls);
                runner.setDirURL_(parent);
                runner.getParameters().setFiles(Arrays.asList(filenames));
                CVSOperationUpdate.this.doInvocationImpl(runner);
                if (archiveDirectoryUrls != null) {
                    CVSOperationUpdate.this.updateEntriesDotArchiveTimestamps(archiveDirectoryUrls);
                }
                return true;
            }
        };
        invokable.setProgressMonitor(monitor);
        return invokable.runInvokable();
    }

    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer) {
        return VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.get("UPDATE_CAPTION"), (String)CVSArb.get("UPDATE_LONG_PROMPT"), (Component)CVSComponents.createFileListerComponent(nodes), (Component)customizer.getComponent(), (String)"f1_cvsupdate_html", (Component)customizer.getInitialFocusComponent());
    }

    protected DeterminateProgressMonitor createProgressMonitor(Component parent) {
        return new DeterminateProgressMonitor(parent, CVSArb.get("UPDATE_PROGRESS_TITLE"), (Object)CVSArb.get("UPDATE_WATCHER_DESCRIPTION"), "", 0, -1);
    }

    protected void doInvocationImpl(CVSRunner runner) throws Exception {
        runner.exec_();
        if (runner.getExitCode_() != null && runner.getExitCode_() == 0) {
            return;
        }
        if (runner.getErrorText_() != null) {
            boolean errors = false;
            BufferedReader br = new BufferedReader(new StringReader(runner.getErrorText_().trim()));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.matches(".*Updating .+")) continue;
                    errors = true;
                    break;
                }
            }
            catch (IOException ioe) {
                errors = true;
            }
            if (!errors) {
                return;
            }
        }
        throw new CVSProcessException(CVSArb.get("ERROR_UPDATE_FAILED"), runner.getErrorText_());
    }

    private boolean confirmCleanUpdate(Map optionsMap, VCSCommandState state) {
        Object value = optionsMap.get((Object)CVSOptionId.UPDATE_CLEAN_UPDATE);
        if (value == null || !((Boolean)value).booleanValue()) {
            return true;
        }
        URL[] urls = state.getInvokableState().getURLs();
        String message = CVSArb.get("UPDATE_CONFIRM_CLEAN_MISC");
        if (urls.length == 1) {
            String fileName = URLFileSystem.getFileName((URL)urls[0]);
            message = URLFileSystem.isDirectory((URL)urls[0]) ? CVSArb.format("UPDATE_CONFIRM_CLEAN_FOLDER", fileName) : CVSArb.format("UPDATE_CONFIRM_CLEAN_FILE", fileName);
        } else {
            message = CVSArb.get("UPDATE_CONFIRM_CLEAN_MISC");
        }
        String title = CVSArb.get("UPDATE_CONFIRM_CLEAN_TITLE");
        return CVSMessageDialog.confirm((Component)Ide.getMainWindow(), message, title, null, true);
    }

    private Collection<URL> copyEntriesToEntriesDotArchive(URL parent, URL[] invokeUrls, boolean local) {
        ArrayList<URL> directoryUrls = new ArrayList<URL>();
        try {
            this.copyEntriesToEntriesDotArchive(parent, invokeUrls, local, directoryUrls);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return directoryUrls;
    }

    private void copyEntriesToEntriesDotArchive(URL parent, URL[] invokeUrls, boolean local, Collection<URL> directoryUrls) throws IOException {
        URL entriesUrl = URLFactory.newFileURL((File)new File(URLFileSystem.getPlatformPathName((URL)parent), CVSEntriesFile.ENTRIES_RELATIVE_PATH));
        URL entriesDotArchiveUrl = URLFactory.newFileURL((File)new File(URLFileSystem.getPlatformPathName((URL)parent), CVSEntriesFile.ENTRIES_DOT_ARCHIVE_RELATIVE_PATH));
        if (!URLFileSystem.exists((URL)entriesUrl)) {
            return;
        }
        CVSEntriesFile entriesFile = new CVSEntriesFile(parent, CVSEntriesFile.ENTRIES_RELATIVE_PATH);
        if (invokeUrls.length > 0) {
            if (URLFileSystem.exists((URL)entriesDotArchiveUrl) && URLFileSystem.lastModified((URL)entriesUrl) > URLFileSystem.lastModified((URL)entriesDotArchiveUrl)) {
                URLFileSystem.deleteEx((URL)entriesDotArchiveUrl);
            }
            CVSEntriesFile entriesDotArchiveFile = new CVSEntriesFile(parent, CVSEntriesFile.ENTRIES_DOT_ARCHIVE_RELATIVE_PATH);
            Collection<CVSEntry> entries = entriesFile.getEntries();
            ArrayList<CVSEntry> archiveEntries = new ArrayList<CVSEntry>(entriesDotArchiveFile.getEntries());
            for (URL invokeUrl : invokeUrls) {
                CVSEntry entry = CVSEntriesFile.findEntry(entries, invokeUrl);
                CVSEntry archiveEntry = CVSEntriesFile.findEntry(archiveEntries, invokeUrl);
                if (archiveEntry != null) {
                    archiveEntries.remove(archiveEntry);
                }
                if (entry == null) continue;
                archiveEntries.add(entry);
            }
            entriesDotArchiveFile.writeEntries(archiveEntries);
            URLFileSystem.setLastModified((URL)entriesDotArchiveUrl, (long)Math.max(0L, URLFileSystem.lastModified((URL)entriesUrl)));
            directoryUrls.add(parent);
            for (URL invokeUrl : invokeUrls) {
                if (!URLFileSystem.isDirectory((URL)invokeUrl)) continue;
                this.copyEntriesToEntriesDotArchive(invokeUrl, new URL[0], local, directoryUrls);
            }
            return;
        }
        URLFileSystem.copy((URL)entriesUrl, (URL)entriesDotArchiveUrl);
        URLFileSystem.setLastModified((URL)entriesDotArchiveUrl, (long)Math.max(0L, URLFileSystem.lastModified((URL)entriesUrl)));
        directoryUrls.add(parent);
        if (local) {
            return;
        }
        Collection<CVSEntry> entries = entriesFile.getEntries();
        for (CVSEntry entry : entries) {
            URL directoryUrl;
            if (!entry.isDirectory() || !URLFileSystem.isDirectory((URL)(directoryUrl = URLFactory.newDirURL((URL)parent, (String)entry.getName())))) continue;
            this.copyEntriesToEntriesDotArchive(directoryUrl, new URL[0], local, directoryUrls);
        }
    }

    private void updateEntriesDotArchiveTimestamps(Collection<URL> directoryUrls) {
        for (URL directoryUrl : directoryUrls) {
            URL entriesUrl = URLFactory.newFileURL((File)new File(URLFileSystem.getPlatformPathName((URL)directoryUrl), CVSEntriesFile.ENTRIES_RELATIVE_PATH));
            URL entriesDotArchiveUrl = URLFactory.newFileURL((File)new File(URLFileSystem.getPlatformPathName((URL)directoryUrl), CVSEntriesFile.ENTRIES_DOT_ARCHIVE_RELATIVE_PATH));
            if (!URLFileSystem.exists((URL)entriesDotArchiveUrl)) continue;
            URLFileSystem.setLastModified((URL)entriesDotArchiveUrl, (long)Math.max(0L, URLFileSystem.lastModified((URL)entriesUrl)));
        }
    }

    static class DeletionOrderComparator
    implements Comparator<URL> {
        DeletionOrderComparator() {
        }

        @Override
        public int compare(URL url1, URL url2) {
            return this.getWeight(url1) - this.getWeight(url2);
        }

        private int getWeight(URL url) {
            String suffix = URLFileSystem.getSuffix((URL)url);
            if (suffix.equals(".jpr")) {
                return 1;
            }
            if (suffix.equals(".jws")) {
                return 2;
            }
            return 0;
        }
    }
}

