/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import oracle.ide.log.LogManager;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;

public class CVSOperationStatus
extends CVSAbstractCommand
implements CVSCommandConstants {
    public CVSOperationStatus() {
        super(OPERATION_STATUS_CMD_ID, VCSCommandStyle.SINGLE);
    }

    protected CVSOperationStatus(int id) {
        super(id, VCSCommandStyle.SINGLE);
    }

    protected boolean isAvailableImpl() throws Exception {
        Locatable[] locatables = this.getContextLocatables();
        if (!this.isOpenSessionSelection(locatables)) {
            return false;
        }
        return this.isAvailableImpl(locatables);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!URLFileSystem.exists((URL)url)) {
            return false;
        }
        CVSClient.getInstance();
        VCSStatus status = (VCSStatus)CVSClient.getStatusCache().get(url);
        return status.isVersioned();
    }

    protected boolean isThreaded() {
        return true;
    }

    protected int doitImpl() throws Exception {
        URL url = this.getContextLocatables()[0].getURL();
        Collection opts = this.createCommandOptions();
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setCommand_("status");
        runner.getParameters().setOptions(opts);
        runner.getParameters().setQuiet(false);
        if (URLFileSystem.isDirectory((URL)url)) {
            runner.setDirURL_(url);
        } else {
            URL dir = URLFileSystem.getParent((URL)url);
            runner.getParameters().setFile(URLFileSystem.getFileName((URL)url));
            runner.setDirURL_(URLFileSystem.getParent((URL)url));
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                LogManager.getLogManager().getLogWindow().selectPage(LogManager.getLogManager().getMsgPage());
                LogManager.getLogManager().showLog();
            }
        });
        runner.exec_();
        if (runner.getExitCode_() == null || runner.getExitCode_() != 0) {
            throw new CVSProcessException(CVSArb.get("ERROR_STATUS_FAILED"), runner.getErrorText_());
        }
        return 0;
    }

    protected Collection createCommandOptions() {
        ArrayList opts = new ArrayList();
        return opts;
    }
}

