/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.ProductInformation;
import oracle.ide.config.Preferences;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSValidationException;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSCommandOptionsPrefs;
import oracle.jdevimpl.vcs.cvs.CVSComponents;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSFileURLFileSystemHelper;
import oracle.jdevimpl.vcs.cvs.client.CVSEntriesFile;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;

public class CVSOperationRemove
extends CVSAbstractCommand {
    public CVSOperationRemove() {
        super(CVSCommandConstants.OPERATION_REMOVE_CMD_ID, VCSCommandStyle.MULTI);
    }

    protected boolean isAvailableImpl() throws Exception {
        Locatable[] locatables = this.getContextLocatables();
        if (!this.isOpenSessionSelection(locatables)) {
            return false;
        }
        return this.isAvailableImpl(locatables);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!URLFileSystem.exists((URL)url)) {
            return false;
        }
        if (VCSFileSystemUtils.isNonEditable((URL)url)) {
            return false;
        }
        CVSClient.getInstance();
        VCSStatus status = (VCSStatus)CVSClient.getStatusCache().get(url);
        if (status == CVSFileStatus.STATUS_SANDBOX) {
            return false;
        }
        return status.isVersioned();
    }

    protected int doitImpl() throws Exception {
        VCSStatus[] statuses = new VCSStatus[]{CVSFileStatus.STATUS_CONFLICTS, CVSFileStatus.STATUS_LOCALLY_CHANGED, CVSFileStatus.STATUS_ADDED, CVSFileStatus.STATUS_UNMODIFIED_READWRITE, CVSFileStatus.STATUS_UNMODIFIED_READONLY};
        Collection nodes = this.getFilteredSelection(statuses);
        VCSCommandUtils.removeNonEditableNodes((Collection)nodes);
        if (nodes.size() <= 0) {
            return 9;
        }
        VCSModelUtils.fireVetoableCanRemoveChildren((Object[])nodes.toArray());
        final JEWTDialog dialog = VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.get("REMOVE_CAPTION"), (String)CVSArb.get("REMOVE_LONG_PROMPT"), (Component)CVSComponents.createFileListerComponent(nodes), null, (String)"f1_cvsremove_html");
        final VCSDirectoryInvokableState state = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Collection)nodes));
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(null){

            protected final boolean doCommitOperation(Map options) throws Exception {
                return CVSOperationRemove.this.doCommitOperationImpl((Component)dialog, options, state);
            }
        });
        boolean dialogSuccessful = CVSDialogRunner.runDialog((JDialog)dialog);
        final Collection processedUrls = state.getProcessedURLs();
        URL[] processedUrlArray = processedUrls.toArray(new URL[0]);
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear(processedUrlArray, Depth.INFINITY);
        this.fireSomeFilesDeleted(processedUrlArray);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                try {
                    Iterator itr = processedUrls.iterator();
                    while (itr.hasNext()) {
                        Node node = NodeFactory.find((URL)((URL)itr.next()));
                        if (node == null) continue;
                        node.close();
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        });
        return !dialogSuccessful ? 1 : 0;
    }

    protected void noOpImpl() throws VCSValidationException {
        throw new VCSValidationException(CVSArb.get("ERROR_REMOVE_FILTERED_TITLE"), CVSArb.format("ERROR_REMOVE_FILTERED", ProductInformation.getProductInformation().getShortName()));
    }

    private boolean doCommitOperationImpl(Component dialog, Map options, VCSDirectoryInvokableState state) throws Exception {
        DeterminateProgressMonitor monitor = new DeterminateProgressMonitor(dialog, CVSArb.get("REMOVE_PROGRESS_TITLE"), (Object)CVSArb.get("REMOVE_WATCHER_DESCRIPTION"), "", 0, -1);
        final CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("-l");
        runner.setCommand_("remove");
        runner.getParameters().setQuiet(false);
        runner.getParameters().setOptions(opts);
        CVSDirectoryInvokable invokable = new CVSDirectoryInvokable(state){

            @Override
            protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                String[] filenames = VCSFileSystemUtils.getURLFileNames((URL[])invokeUrls);
                runner.setDirURL_(parent);
                runner.getParameters().setFiles(Arrays.asList(filenames));
                CVSOperationRemove.this.doInvocationImpl(runner, parent, filenames);
                return true;
            }
        };
        invokable.setProgressMonitor(monitor);
        if (!invokable.runInvokable()) {
            return false;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CVSClient.invokePendingChanges();
            }
        });
        return true;
    }

    private void doInvocationImpl(CVSRunner runner, URL parent, String[] filenames) throws Exception {
        List<String> names = Arrays.asList(filenames);
        this.deleteFilesForRemove(parent, names);
        runner.exec_();
        if (runner.getExitCode_() != null && runner.getExitCode_() == 0) {
            return;
        }
        throw new CVSProcessException(CVSArb.get("ERROR_REMOVE_FAILED"), runner.getErrorText_());
    }

    private void deleteFilesForRemove(URL dir, List names) throws Exception {
        Collection<CVSEntry> entries = new CVSEntriesFile(dir).getEntries();
        Iterator itr = names.iterator();
        while (itr.hasNext()) {
            URL url = URLFactory.newURL((URL)dir, (String)itr.next().toString());
            if (URLFileSystem.isDirectoryPath((URL)url)) continue;
            CVSFileURLFileSystemHelper.arrestCommands((Object)this, url);
            Boolean renameOnRemove = CVSCommandOptionsPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getRenameOnRemove();
            if (renameOnRemove != null && renameOnRemove.booleanValue()) {
                CVSEntry entry = CVSEntriesFile.findEntry(entries, url);
                URL renameUrl = URLFactory.newURL((URL)dir, (String)(".#" + URLFileSystem.getFileName((URL)url) + "." + (entry != null ? entry.getRevision() : "backup")));
                if (URLFileSystem.exists((URL)renameUrl)) {
                    URLFileSystem.delete((URL)renameUrl);
                }
                URLFileSystem.renameTo((URL)url, (URL)renameUrl);
            }
            if (URLFileSystem.exists((URL)url)) {
                URLFileSystem.delete((URL)url);
            }
            CVSFileURLFileSystemHelper.resumeCommands((Object)this, url);
        }
    }
}

