/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.ProductInformation;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSValidationException;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSComponents;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;

public class CVSOperationLock
extends CVSAbstractCommand
implements CVSCommandConstants {
    public CVSOperationLock() {
        super(OPERATION_LOCK_CMD_ID, VCSCommandStyle.MULTI);
    }

    protected CVSOperationLock(int id) {
        super(id, VCSCommandStyle.MULTI);
    }

    protected boolean isAvailableImpl() throws Exception {
        if (CVSClient.getInstance() == null) {
            return false;
        }
        if (CVSClient.getInstance().isUsingInternalClient() && !CVSInternalClientSupport.isSupportedCommand("admin")) {
            return false;
        }
        Locatable[] locatables = this.getContextLocatables();
        if (!this.isOpenSessionSelection(locatables)) {
            return false;
        }
        return this.isAvailableImpl(locatables);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!URLFileSystem.exists((URL)url)) {
            return false;
        }
        CVSClient.getInstance();
        VCSStatus status = (VCSStatus)CVSClient.getStatusCache().get(url);
        return status.isVersioned();
    }

    protected int doitImpl() throws Exception {
        Collection nodes = this.getFilteredSelection(new VCSStatus[]{CVSFileStatus.STATUS_LOCALLY_CHANGED, CVSFileStatus.STATUS_REMOVED, CVSFileStatus.STATUS_ADDED, CVSFileStatus.STATUS_UNMODIFIED_READWRITE, CVSFileStatus.STATUS_UNMODIFIED_READONLY, CVSFileStatus.STATUS_CONFLICTS, CVSFileStatus.STATUS_SANDBOX});
        if (nodes.size() <= 0) {
            return 9;
        }
        final VCSDirectoryInvokableState state = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Collection)nodes));
        final JEWTDialog dialog = this.createOperationDialog(nodes, null);
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(null){

            protected final boolean doCommitOperation(Map options) throws Exception {
                return CVSOperationLock.this.doCommitOperationImpl((Component)dialog, options, state);
            }
        });
        boolean dialogSuccessful = CVSDialogRunner.runDialog((JDialog)dialog);
        return !dialogSuccessful ? 1 : 0;
    }

    protected void noOpImpl() throws VCSValidationException {
        throw new VCSValidationException(CVSArb.get("ERROR_LOCK_FILTERED_TITLE"), CVSArb.format("ERROR_LOCK_FILTERED", ProductInformation.getProductInformation().getShortName()));
    }

    private boolean doCommitOperationImpl(Component dialog, Map options, VCSDirectoryInvokableState state) throws Exception {
        DeterminateProgressMonitor monitor = this.createProgressMonitor(dialog);
        final CVSRunner runner = this.createRunner(options);
        CVSDirectoryInvokable invokable = new CVSDirectoryInvokable(state){

            @Override
            protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                String[] filenames = VCSFileSystemUtils.getURLFileNames((URL[])invokeUrls);
                runner.setDirURL_(parent);
                runner.getParameters().setFiles(Arrays.asList(filenames));
                CVSOperationLock.this.doInvocationImpl(runner);
                return true;
            }
        };
        invokable.setProgressMonitor(monitor);
        return invokable.runInvokable();
    }

    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer) {
        return VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.get("LOCK_CAPTION"), null, (Component)CVSComponents.createFileListerComponent(nodes), null, (String)"f1_cvslock_html");
    }

    protected DeterminateProgressMonitor createProgressMonitor(Component parent) {
        return new DeterminateProgressMonitor(parent, CVSArb.get("LOCK_PROGRESS_TITLE"), (Object)CVSArb.get("LOCK_WATCHER_DESCRIPTION"), "", 0, -1);
    }

    protected CVSRunner createRunner(Map options) {
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setCommand_("admin");
        runner.getParameters().setQuiet(false);
        runner.getParameters().setGlobals(null);
        runner.getParameters().setOptions(Collections.singletonList("-l"));
        return runner;
    }

    protected void doInvocationImpl(CVSRunner runner) throws Exception {
        runner.exec_();
        if (runner.getExitCode_() != null && runner.getExitCode_() == 0) {
            return;
        }
        throw new CVSProcessException(CVSArb.get("ERROR_LOCK_FAILED"), runner.getErrorText_());
    }
}

