/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.EventQueue;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.controller.IdeAction;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.nav.VersioningNavigatorConstants;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSActiveClient;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDetailsKey;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.util.CVSEnvironmentVars;

public class CVSOperationInheritConnection
extends CVSAbstractCommand {
    public CVSOperationInheritConnection() {
        super(CVSCommandConstants.OPERATION_INHERIT_CONNECTION_CMD_ID, VCSCommandStyle.MULTI);
    }

    protected boolean isAvailableImpl() throws Exception {
        CVSRootString cvsroot = this.getContextRoot();
        if (cvsroot == null || CVSUtil.hasRootConnection(cvsroot)) {
            return false;
        }
        return CVSConnectionListAPI.isSupportedRoot(cvsroot.toString());
    }

    protected int doitImpl() throws Exception {
        CVSClient client = CVSClient.getInstance();
        client.verifyClientState();
        Map vars = CVSEnvironmentVars.getInstance().getVariables();
        String cvsroot = this.getContextRoot().toString();
        String cvsrsh = (String)vars.get("CVS_RSH");
        String cvsserver = (String)vars.get("CVS_SERVER");
        if (cvsroot == null || cvsroot.equals("")) {
            return -1;
        }
        if (CVSActiveClient.isClientCVSNT()) {
            cvsroot = CVSRootString.canonicalizeCVSNTRoot(cvsroot);
        }
        HashMap<Object, Object> details = new HashMap<Object, Object>();
        details.put(CVSConnectionDetailsKey.KEY_CONNECTION_NAME, cvsroot);
        details.put(CVSConnectionDetailsKey.KEY_CONNECTION_ROOT, cvsroot);
        if (cvsrsh != null) {
            details.put(CVSConnectionDetailsKey.KEY_CONNECTION_SET_RSH, Boolean.TRUE);
            details.put(CVSConnectionDetailsKey.KEY_CONNECTION_CVS_RSH, cvsrsh);
        }
        if (cvsserver != null) {
            details.put(CVSConnectionDetailsKey.KEY_CONNECTION_SET_SERVER, Boolean.TRUE);
            details.put(CVSConnectionDetailsKey.KEY_CONNECTION_CVS_SERVER, cvsserver);
        }
        CVSConnectionNodes.getConnectionListAPI().addConnection(details);
        VCSControlCache.getInstance().fireControlStateChanged("oracle.jdeveloper.cvs");
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear();
        CVSConnectionNodes.updateOverlays();
        final IdeAction showNavigatorAction = IdeAction.find((int)VersioningNavigatorConstants.SHOW_NAVIGATOR_CMD_ID);
        if (showNavigatorAction == null) {
            return 0;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    showNavigatorAction.performAction();
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
        });
        return 0;
    }
}

