/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.net.URL;
import java.util.Map;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSChangeListWindow;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSIgnorePatternList;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.util.CVSMessageDialog;

public class CVSOperationIgnoreFileType
extends CVSAbstractCommand
implements CVSCommandConstants {
    public CVSOperationIgnoreFileType() {
        super(CVSCommandConstants.OPERATION_IGNORE_FILE_TYPE_CMD_ID, VCSCommandStyle.SINGLE);
    }

    protected boolean isAvailableImpl() throws Exception {
        if (!(this.getContext().getView() instanceof CVSChangeListWindow)) {
            return false;
        }
        Locatable[] locatables = this.getContextLocatables();
        if (!this.isOpenSessionSelection(locatables)) {
            return false;
        }
        return this.isAvailableImpl(locatables);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!super.isAvailableImpl(url)) {
            return false;
        }
        return !URLFileSystem.getSuffix((URL)url).equals("");
    }

    protected int doitImpl() throws Exception {
        String suffix = URLFileSystem.getSuffix((URL)this.getContextLocatables()[0].getURL());
        if (!CVSMessageDialog.confirm(IdeUtil.getMainWindow(), CVSArb.format("IGNORE_FILE_TYPE", suffix.substring(1)), CVSArb.get("IGNORE_FILE_TYPE_TITLE"), null, false)) {
            return 1;
        }
        Map timestampMap = VCSBufferUtils.storeAllTimestamps();
        URL userHomeUrl = URLFactory.newDirURL((String)System.getProperty("user.home"));
        CVSIgnorePatternList ignorePatternList = CVSIgnorePatternList.load(userHomeUrl);
        ignorePatternList.add("*" + suffix);
        ignorePatternList.save(userHomeUrl);
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear();
        VCSBufferUtils.reloadBuffers((Map)timestampMap);
        return 0;
    }
}

