/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.Enum;
import oracle.jdeveloper.vcs.annotations.Annotations;
import oracle.jdeveloper.vcs.annotations.AnnotationsCommand;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSEntriesCache;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionArgument;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;

public class CVSOperationAnnotations
extends AnnotationsCommand {
    public CVSOperationAnnotations() {
        super(CVSCommandConstants.OPERATION_ANNOTATIONS_CMD_ID);
    }

    protected StatusCache<VCSStatus> getStatusCacheBridge() {
        CVSClient.getInstance();
        return CVSClient.getStatusCache();
    }

    protected boolean isUnmodifiedStatus(VCSStatus status) {
        return status == CVSFileStatus.STATUS_UNMODIFIED_READONLY || status == CVSFileStatus.STATUS_UNMODIFIED_READWRITE;
    }

    protected Annotations getAnnotations(URL url) throws Exception {
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.getParameters().setQuiet(true);
        runner.setDirURL_(URLFileSystem.getParent((URL)url));
        runner.setCmdArray_(new String[]{"annotate"});
        runner.getParameters().setFile(URLFileSystem.getFileName((URL)url));
        CVSEntry entry = CVSEntriesCache.findEntry(CVSEntriesCache.getInstance().getEntriesMap(URLFileSystem.getParent((URL)url)), url);
        if (entry == null || entry.getRevision() == null) {
            return new AnnotationsImpl(Arrays.asList(new Annotation[0]));
        }
        HashMap<Enum, Object> options = new HashMap<Enum, Object>();
        options.put(CVSOptionId.COMMON_USE_REVISION, Boolean.TRUE);
        options.put(CVSOptionArgument.REVISION_NAME, entry.getRevision());
        runner.getParameters().setBuilderOptions(options);
        final ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        final boolean[] aborted = new boolean[1];
        runner.addOutputMonitor(new CVSProcessStreamMonitor(){
            private final Pattern _pattern = Pattern.compile("([^\\s]+)\\s+\\(([^ ]+) ([^\\)]+)\\):(.*)");
            private final DateFormat _dateFormat = new SimpleDateFormat("dd-MMM-yy z", Locale.US);

            @Override
            protected void streamLine(String line, CVSProcess process) throws Exception {
                if (aborted[0]) {
                    return;
                }
                Matcher matcher = this._pattern.matcher(line);
                if (!matcher.matches()) {
                    Assert.printStackTrace((Throwable)new IllegalStateException(line));
                    return;
                }
                try {
                    annotations.add(new Annotation(this._dateFormat.parse(matcher.group(3) + " GMT"), matcher.group(1), matcher.group(2), matcher.group(4)));
                }
                catch (ParseException pe) {
                    Assert.printStackTrace((Throwable)pe);
                    aborted[0] = true;
                    return;
                }
            }
        });
        runner.exec_();
        if (aborted[0]) {
            annotations.clear();
        }
        return new AnnotationsImpl(annotations);
    }

    protected DateFormat getDateFormat() {
        return new SimpleDateFormat("EEE MMM dd yyyy");
    }

    private class Annotation {
        private final Date _changed;
        private final String _revision;
        private final String _author;
        private final String _line;

        Annotation(Date changed, String revision, String author, String line) {
            this._changed = changed;
            this._revision = revision;
            this._author = author;
            this._line = line;
        }

        Date getChanged() {
            return this._changed;
        }

        String getRevision() {
            return this._revision;
        }

        String getAuthor() {
            return this._author;
        }

        String getLine() {
            return this._line;
        }
    }

    private class AnnotationsImpl
    extends Annotations {
        private final List<Annotation> _annotations;

        AnnotationsImpl(List<Annotation> annotations) {
            this._annotations = annotations;
        }

        public Date getChanged(int lineNumber) {
            return this._annotations.size() > lineNumber ? this._annotations.get(lineNumber).getChanged() : new Date(0L);
        }

        public String getRevision(int lineNumber) {
            return this._annotations.size() > lineNumber ? this._annotations.get(lineNumber).getRevision() : "";
        }

        public String getAuthor(int lineNumber) {
            return this._annotations.size() > lineNumber ? this._annotations.get(lineNumber).getAuthor() : "";
        }

        public String getLine(int lineNumber) {
            return this._annotations.size() > lineNumber ? this._annotations.get(lineNumber).getLine() : "";
        }

        public int getLineCount() {
            return this._annotations.size();
        }
    }
}

