/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.model.ContentType;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSCommandState;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSValidationException;
import oracle.jdeveloper.vcs.spi.VCSWaitRunnable;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSChangeListWindow;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSComponents;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSIgnorePatternList;
import oracle.jdevimpl.vcs.cvs.CVSRootCache;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.error.CVSOperationException;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;
import oracle.jdevimpl.vcs.util.SimpleChoiceDialog;

public class CVSOperationAdd
extends CVSAbstractCommand
implements CVSCommandConstants {
    private static final String CREATED_URLS_PROPERTY = "CVSOperationAdd.CREATED_URLS";

    public CVSOperationAdd() {
        super(OPERATION_ADD_CMD_ID, VCSCommandStyle.MULTI);
    }

    protected CVSOperationAdd(int id) {
        super(id, VCSCommandStyle.MULTI);
    }

    protected Locatable[] getLocatablesToAdd() throws Exception {
        return this.getContextLocatables();
    }

    protected boolean isAvailableImpl() throws Exception {
        Locatable[] locatables = this.getLocatablesToAdd();
        if (!this.isOpenSessionSelection(locatables)) {
            return false;
        }
        return this.isAvailableImpl(locatables);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!super.isAvailableImpl(url)) {
            return false;
        }
        CVSClient.getInstance();
        VCSStatus status = (VCSStatus)CVSClient.getStatusCache().get(url);
        if (status != CVSFileStatus.STATUS_REMOVED && !URLFileSystem.exists((URL)url) && !URLFileSystem.isDirectoryPath((URL)url)) {
            return true;
        }
        return status.isCandidate();
    }

    protected int doitImpl() throws Exception {
        Locatable[] locatables = this.getLocatablesToAdd();
        if (!CVSUtil.saveDirtyNodes(Arrays.asList(locatables))) {
            return 1;
        }
        VCSStatus[] statuses = new VCSStatus[]{CVSFileStatus.STATUS_UNADDED, CVSFileStatus.STATUS_REMOVED};
        Collection nodes = this.getFilteredSelection(locatables, statuses);
        if (nodes.size() <= 0) {
            return 9;
        }
        VCSDirectoryInvokableState invokableState = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Collection)nodes));
        VCSCommandState state = new VCSCommandState(invokableState, null);
        Node[] affectedNodes = null;
        if (this.getContext().getView() instanceof CVSChangeListWindow && this.isActionLocal()) {
            VCSOptionsCustomizer customizer = CVSClient.getInstance().getChangeListOptionsCustomizer();
            return this.addSilently(nodes, affectedNodes, state, customizer);
        }
        VCSOptionsCustomizer customizer = null;
        return this.add(nodes, affectedNodes, state, customizer);
    }

    protected void noOpImpl() throws VCSValidationException {
        throw new VCSValidationException(CVSArb.get("ERROR_ADD_FILTERED_TITLE"), CVSArb.format("ERROR_ADD_FILTERED", ProductInformation.getProductInformation().getShortName()));
    }

    private int addSilently(Collection nodes, final Node[] affectedNodes, final VCSCommandState state, VCSOptionsCustomizer customizer) {
        VCSWaitRunnable r = new VCSWaitRunnable(this.getExceptionHandler(), customizer){

            protected final void runImpl() throws Exception {
                CVSOperationAdd.this.doCommitOperationImpl((Component)Ide.getMainWindow(), this.getOptions(), state);
            }

            protected final void runPostOperationAWT() throws Exception {
                CVSOperationAdd.this.postAdd(state, affectedNodes);
            }
        };
        Thread t = new Thread((Runnable)r, "CVSOperationAdd");
        t.start();
        return 0;
    }

    private int add(Collection nodes, Node[] affectedNodes, final VCSCommandState state, VCSOptionsCustomizer customizer) throws Exception {
        final JEWTDialog dialog = this.createOperationDialog(nodes);
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){

            protected final boolean doCommitOperation(Map options) throws Exception {
                return CVSOperationAdd.this.doCommitOperationImpl((Component)dialog, options, state);
            }
        });
        boolean dialogSuccessful = CVSDialogRunner.runDialog((JDialog)dialog);
        this.postAdd(state, affectedNodes);
        return !dialogSuccessful ? 1 : 0;
    }

    private void postAdd(VCSCommandState state, Node[] affectedNodes) throws Exception {
        HashSet processedUrls = state.getInvokableState().getProcessedURLs();
        HashSet processedUrls2 = new HashSet();
        processedUrls2.addAll(processedUrls);
        Iterator itr = processedUrls.iterator();
        while (itr.hasNext()) {
            processedUrls2.addAll(Arrays.asList(VCSFileSystemUtils.getParentURLs((URL)((URL)itr.next()))));
        }
        processedUrls = processedUrls2;
        URL[] processedUrlArray = processedUrls.toArray(new URL[0]);
        Collection createdUrls = (Collection)state.getProperty(CREATED_URLS_PROPERTY);
        if (createdUrls != null) {
            this.fireSomeFilesCreated(createdUrls.toArray(new URL[0]));
        }
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear(processedUrlArray);
    }

    private boolean doCommitOperationImpl(Component dialog, Map optionsMap, VCSCommandState state) throws Exception {
        ArrayList<URL> existingUrls = new ArrayList<URL>(Arrays.asList(state.getInvokableState().getURLs()));
        Iterator itr = existingUrls.iterator();
        while (itr.hasNext()) {
            if (URLFileSystem.exists((URL)((URL)itr.next()))) continue;
            itr.remove();
        }
        state.setProperty(CREATED_URLS_PROPERTY, Collections.emptySet());
        if (optionsMap != null) {
            optionsMap = new HashMap(optionsMap);
        }
        final DeterminateProgressMonitor monitor = this.createProgressMonitor(dialog);
        final CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setCommand_("add");
        runner.getParameters().setQuiet(false);
        if (optionsMap != null) {
            optionsMap.keySet().retainAll(Arrays.asList(new Object[0]));
            runner.getParameters().setBuilderOptions(optionsMap);
        }
        ArrayList<URL> urls = new ArrayList<URL>(Arrays.asList(state.getInvokableState().getURLs()));
        ArrayList<URL> ignoredUrls = new ArrayList<URL>(urls);
        CVSIgnorePatternList.filterIgnored(urls);
        ignoredUrls.removeAll(urls);
        if (!ignoredUrls.isEmpty()) {
            if (!MessageDialog.confirm((Component)IdeUtil.getMainWindow(), (Object)CVSArb.get("CONFIRM_ADD_IGNORED_FILES"), (String)CVSArb.get("CONFIRM_ADD_IGNORED_FILES_TITLE"), null, (boolean)false)) {
                throw new VCSCancelException();
            }
            CVSIgnorePatternList.removeIgnorePatterns(ignoredUrls);
            CVSClient.getInstance();
            CVSClient.getStatusCache().clear();
        }
        CVSDirectoryInvokable invokable = new CVSDirectoryInvokable(state.getInvokableState()){

            @Override
            protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                if (!CVSOperationAdd.ensureVersionedDir(parent, monitor)) {
                    return false;
                }
                ArrayList<URL> invokeUrls2 = new ArrayList<URL>(Arrays.asList(invokeUrls));
                Iterator itr = invokeUrls2.iterator();
                while (itr.hasNext()) {
                    URL url = (URL)itr.next();
                    if (!URLFileSystem.isDirectoryPath((URL)url)) continue;
                    if (!CVSOperationAdd.ensureVersionedDir(url, monitor)) {
                        return false;
                    }
                    itr.remove();
                }
                if (invokeUrls2.size() <= 0) {
                    return true;
                }
                runner.setDirURL_(parent);
                return CVSOperationAdd.this.doCommitOperationImpl2(runner, invokeUrls2);
            }
        };
        invokable.setProgressMonitor(monitor);
        boolean success = invokable.runInvokable();
        ArrayList createdUrls = new ArrayList(state.getInvokableState().getProcessedURLs());
        createdUrls.removeAll(existingUrls);
        state.setProperty(CREATED_URLS_PROPERTY, createdUrls);
        if (!success) {
            return false;
        }
        URL[] urls2 = state.getInvokableState().getURLs();
        for (int i = 0; i < urls2.length; ++i) {
            if (URLFileSystem.isDirectoryPath((URL)urls2[i])) continue;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CVSClient.invokePendingChanges();
                }
            });
            break;
        }
        return true;
    }

    protected boolean doCommitOperationImpl2(CVSRunner runner, Collection invokeUrls2) throws Exception {
        if (!CVSOperationAdd.registerUnrecognizedFileTypesUI(invokeUrls2.toArray(new URL[0]))) {
            return false;
        }
        ArrayList<URL> contentTypeUrls = new ArrayList<URL>();
        contentTypeUrls.addAll(Arrays.asList(VCSFileSystemUtils.getContentTypeURLs((URL[])invokeUrls2.toArray(new URL[0]), (ContentType)ContentType.TEXT)));
        contentTypeUrls.addAll(Arrays.asList(VCSFileSystemUtils.getContentTypeURLs((URL[])invokeUrls2.toArray(new URL[0]), null)));
        if (!contentTypeUrls.isEmpty()) {
            runner.getParameters().setOptions(this.getTextFileKeywordOptions());
            runner.getParameters().setFiles(Arrays.asList(VCSFileSystemUtils.getURLFileNames((URL[])contentTypeUrls.toArray(new URL[0]))));
            this.doInvocationImpl(runner);
        }
        contentTypeUrls.clear();
        contentTypeUrls.addAll(Arrays.asList(VCSFileSystemUtils.getContentTypeURLs((URL[])invokeUrls2.toArray(new URL[0]), (ContentType)ContentType.BINARY)));
        if (!contentTypeUrls.isEmpty()) {
            runner.getParameters().setOptions(Arrays.asList("-k", "b"));
            runner.getParameters().setFiles(Arrays.asList(VCSFileSystemUtils.getURLFileNames((URL[])contentTypeUrls.toArray(new URL[0]))));
            this.doInvocationImpl(runner);
        }
        return true;
    }

    private Collection<String> getTextFileKeywordOptions() {
        String keywordSubstitutionOption = CVSUtil.getKeywordSubtitutionOption();
        if (keywordSubstitutionOption != null) {
            return Collections.singleton(CVSUtil.prefixKeywordOption(keywordSubstitutionOption));
        }
        return Collections.emptySet();
    }

    public static final boolean registerUnrecognizedFileTypesUI(URL[] urls) {
        Map urlsByContentType = VCSFileSystemUtils.organizeURLsByContentType((URL[])urls);
        Collection unrecognizedUrls = (Collection)urlsByContentType.get(null);
        if (unrecognizedUrls == null || unrecognizedUrls.isEmpty()) {
            return true;
        }
        LinkedHashSet<String> unrecognizedExtensions = new LinkedHashSet<String>();
        Iterator itr = unrecognizedUrls.iterator();
        while (itr.hasNext()) {
            String extension = URLFileSystem.getSuffix((URL)((URL)itr.next()));
            if (extension.equals("")) continue;
            unrecognizedExtensions.add(extension);
        }
        for (String extension : unrecognizedExtensions) {
            SimpleChoiceDialog choiceDialog = new SimpleChoiceDialog(CVSArb.get("FILE_TYPE_CHOICE_TITLE"), CVSArb.format("FILE_TYPE_CHOICE_LABEL", extension), new String[]{CVSArb.get("FILE_TYPE_CHOICE_TEXT"), CVSArb.get("FILE_TYPE_CHOICE_BINARY")}, null);
            choiceDialog.setButtonAxis(0);
            if (!choiceDialog.show()) {
                return false;
            }
            ContentType contentType = choiceDialog.getChoice() == 0 ? ContentType.TEXT : ContentType.BINARY;
            VCSFileSystemUtils.registerFileType((String)extension, (ContentType)contentType);
        }
        return true;
    }

    protected void doInvocationImpl(CVSRunner runner) throws Exception {
        runner.exec_();
        if (runner.getExitCode_() != null && runner.getExitCode_() == 0) {
            return;
        }
        throw new CVSProcessException(CVSArb.get("ERROR_ADD_FAILED"), runner.getErrorText_());
    }

    protected Collection createCommandOptions() {
        return null;
    }

    protected JEWTDialog createOperationDialog(Collection nodes) {
        return VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.get("ADD_CAPTION"), (String)CVSArb.get("ADD_LONG_PROMPT"), (Component)CVSComponents.createFileListerComponent(nodes, false), null, (String)"f1_cvsadd_html");
    }

    protected DeterminateProgressMonitor createProgressMonitor(Component parent) {
        return new DeterminateProgressMonitor(parent, CVSArb.get("ADD_PROGRESS_TITLE"), (Object)CVSArb.get("ADD_WATCHER_DESCRIPTION"), "", 0, -1);
    }

    static final boolean ensureVersionedDir(URL dir, DeterminateProgressMonitor monitor) throws Exception {
        if (dir == null) {
            throw new CVSOperationException(CVSArb.get("ERROR_ADD_NO_VERSION"));
        }
        if (!CVSUtil.isUnderCVS(dir)) {
            URL parent = URLFileSystem.getParent((URL)dir);
            if (parent == null) {
                throw new CVSOperationException(CVSArb.get("ERROR_ADD_NO_VERSION"));
            }
            if (!CVSOperationAdd.ensureVersionedDir(parent, monitor)) {
                return false;
            }
            CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
            ArrayList<String> files = new ArrayList<String>();
            files.add(URLFileSystem.getFileName((URL)dir));
            runner.setCommand_("add");
            runner.getParameters().setFiles(files);
            runner.setDirURL_(parent);
            runner.getParameters().setQuiet(false);
            runner.exec_();
            CVSRootCache.getInstance().clear();
            CVSClient.getInstance();
            CVSClient.getStatusCache().clear(dir);
            if (runner.getExitCode_() == null || runner.getExitCode_() != 0) {
                throw new CVSProcessException(CVSArb.get("ERROR_ADD_FAILED"), runner.getErrorText_());
            }
        }
        return monitor == null || !monitor.isCanceled();
    }
}

