/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.spi.VCSCommandState;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSChangeListWindow;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSEntriesFile;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagChooser;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;

public abstract class CVSAbstractBranchOperation
extends CVSAbstractCommand {
    protected CVSAbstractBranchOperation(int cmdId) {
        super(cmdId, VCSCommandStyle.MULTI);
    }

    public boolean isAvailableImpl(Locatable[] locatables) {
        Workspace workspace = this.getContextWorkspace();
        if (workspace != null) {
            return this.isOpenSessionWorkspace(workspace);
        }
        Project project = this.getContextProject();
        if (project != null) {
            return this.isOpenSessionProject(project);
        }
        return this.isOpenSessionSelection(locatables);
    }

    public final int doitImpl() throws Exception {
        Locatable[] locatables = null;
        Workspace workspace = this.getContextWorkspace();
        if (locatables == null && workspace != null) {
            locatables = this.getWorkspaceFolderNodes(workspace);
        }
        Project project = this.getContextProject();
        if (locatables == null && project != null) {
            locatables = this.getProjectFolderNodes(project);
        }
        if (locatables == null) {
            locatables = this.getContextLocatables();
        }
        URL[] urls = VCSModelUtils.convertNodesToURLs((Locatable[])locatables);
        Node[] affectedNodes = CVSUtil.getCachedBaseURLNodes(urls);
        Collection nodes = this.coalesceNodesForFolderOperation(Arrays.asList(locatables), true);
        if (nodes.size() <= 0) {
            return 9;
        }
        URL[] browserUrls = VCSModelUtils.convertNodesToURLs((Collection)this.coalesceNodesForFolderOperation(Arrays.asList(locatables), false));
        return this.doitImpl2(locatables, urls, nodes, affectedNodes, browserUrls);
    }

    protected abstract int doitImpl2(Locatable[] var1, URL[] var2, Collection var3, Node[] var4, URL[] var5) throws Exception;

    protected void addVetoableChangeListener(final JEWTDialog dialog, Collection nodes, Node[] affectedNodes, VCSOptionsCustomizer customizer) {
        Map timestampMap = VCSBufferUtils.storeTimestamps(Arrays.asList(affectedNodes));
        VCSDirectoryInvokableState invokableState = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Collection)nodes));
        final VCSCommandState state = new VCSCommandState(invokableState, timestampMap);
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){

            protected final boolean doCommitOperation(Map options) throws Exception {
                return CVSAbstractBranchOperation.this.doCommitOperationImpl((Component)dialog, options, state);
            }

            protected final void runPostOperationAWT() {
                Boolean suppressPostoperation = (Boolean)state.getProperty("CVSAbstractBranchOperation.SUPPRESS_POSTOPERATION");
                if (suppressPostoperation != null && suppressPostoperation.booleanValue()) {
                    return;
                }
                CVSAbstractBranchOperation.this.postOperation(state);
            }
        });
    }

    protected abstract boolean doCommitOperationImpl(Component var1, Map var2, VCSCommandState var3) throws Exception;

    protected void updateDialogOKEnabled(JEWTDialog dialog, CVSTagChooser branchChooser) {
        dialog.setOKButtonEnabled(!branchChooser.isBusy() && (branchChooser.getTagValue() != null || branchChooser.getDateValueISO8601() != null));
    }

    private final void postOperation(VCSCommandState state) {
        URL[] processedUrlArray = state.getInvokableState().getProcessedURLs().toArray(new URL[0]);
        this.fireFileStructureChanged(processedUrlArray);
        this.fireSomeFilesDeleted(processedUrlArray);
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear(processedUrlArray, Depth.INFINITY);
        if (processedUrlArray.length > 0) {
            VCSBufferUtils.reloadBuffers((Map)state.getTimestampMap());
        }
        if (this.getContext().getView() instanceof CVSChangeListWindow) {
            ((CVSChangeListWindow)this.getContext().getView()).getIncomingChangeList().refresh();
        }
    }

    protected final void deleteEntriesDotArchive(URL[] urls) throws IOException {
        LinkedHashMap<String, URL> urlMap = new LinkedHashMap<String, URL>();
        for (URL url : urls) {
            if (!URLFileSystem.isDirectoryPath((URL)url)) {
                url = URLFileSystem.getParent((URL)url);
            }
            urlMap.put(url.toExternalForm(), url);
        }
        for (URL url : VCSFileSystemUtils.coalesceURLs((URL[])urlMap.values().toArray(new URL[0]))) {
            this._deleteEntriesDotArchive(url);
        }
    }

    private void _deleteEntriesDotArchive(URL parent) throws IOException {
        URL entriesDotArchiveUrl = URLFactory.newFileURL((File)new File(URLFileSystem.getPlatformPathName((URL)parent), CVSEntriesFile.ENTRIES_DOT_ARCHIVE_RELATIVE_PATH));
        if (URLFileSystem.exists((URL)entriesDotArchiveUrl)) {
            URLFileSystem.deleteEx((URL)entriesDotArchiveUrl);
        }
        for (URL url : URLFileSystem.list((URL)parent)) {
            if (!URLFileSystem.isDirectoryPath((URL)url)) continue;
            this._deleteEntriesDotArchive(url);
        }
    }

    class CreateBranchInvokable
    extends CVSDirectoryInvokable {
        private boolean _suppressErrors;
        private final CVSRunner _runner;
        private final String _error;

        CreateBranchInvokable(VCSDirectoryInvokableState state, CVSRunner runner, String error) {
            super(state);
            this._runner = runner;
            this._error = error;
        }

        void setSuppressErrors() {
            this._suppressErrors = true;
        }

        @Override
        protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
            this._runner.setDirURL_(parent);
            this._runner.getParameters().setFiles(Arrays.asList(VCSFileSystemUtils.getURLFileNames((URL[])invokeUrls)));
            this._runner.exec_();
            if (this._suppressErrors) {
                return true;
            }
            if (this._runner.getExitCode_() != null && this._runner.getExitCode_() != 0) {
                throw new CVSProcessException(this._error, this._runner.getErrorText_());
            }
            return true;
        }
    }

    class ChangesOutputMonitor
    extends CVSProcessStreamMonitor {
        private String _changes = "";

        ChangesOutputMonitor() {
        }

        @Override
        protected void streamLine(String line, CVSProcess process) throws Exception {
            char code;
            if (line.matches("^[MCAR] .*") && this._changes.indexOf(code = line.charAt(0)) < 0) {
                this._changes = this._changes + code;
            }
        }

        String getChanges() {
            return this._changes;
        }

        void resetChanges() {
            this._changes = "";
        }
    }
}

