/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDefaultServices;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionLocalServices;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNotSupportedServices;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionPServerServices;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionServices;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionSsh2Services;

class CVSConnectionServicesFactory {
    private CVSConnectionServicesFactory() {
    }

    static CVSConnectionServices createServices(String root) {
        if (!CVSConnectionListAPI.isSupportedRoot(root)) {
            return new CVSConnectionNotSupportedServices();
        }
        CVSRootString rootstr = new CVSRootString(root);
        if (rootstr.isAccessFork() || rootstr.isAccessLocal()) {
            return new CVSConnectionLocalServices();
        }
        if (rootstr.isAccessPServer()) {
            return new CVSConnectionPServerServices();
        }
        if (rootstr.isAccessSsh2()) {
            return new CVSConnectionSsh2Services();
        }
        return new CVSConnectionDefaultServices();
    }
}

