/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.awt.EventQueue;
import java.util.Iterator;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.model.Element;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.login.CVSLogin;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public final class CVSConnectionOverlayClient {
    private static final String OVERLAY_LOGIN_INFO_TYPE_ID = "cvsConnectionLoginInfo";
    private static final String OVERLAY_SUPPORT_INFO_TYPE_ID = "cvsConnectionSupportInfo";
    private static boolean _enabled = false;

    private CVSConnectionOverlayClient() {
    }

    public static void setEnabled(boolean enabled) {
        _enabled = enabled;
    }

    public static void updateOverlayIcon(final Element e) {
        if (!CVSConnectionOverlayClient.isConnectionsListNodeOpen()) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                CVSConnectionOverlayClient.updateOverlayIconImpl(e);
                CVSConnectionOverlayClient.getOverlayCache().fireOverlaysChanged();
            }
        });
    }

    private static void updateOverlayIconImpl(Element e) {
        if (!CVSConnectionOverlayClient.isControlled(e)) {
            return;
        }
        CVSConnectionOverlayClient.getOverlayCache().putOverlay(OVERLAY_LOGIN_INFO_TYPE_ID, e, CVSConnectionOverlayClient.getLoginOverlayIcon(e));
        CVSConnectionOverlayClient.getOverlayCache().putOverlay(OVERLAY_SUPPORT_INFO_TYPE_ID, e, CVSConnectionOverlayClient.getSupportOverlayIcon(e));
    }

    public static void updateOverlayIcons() {
        if (!CVSConnectionOverlayClient.isConnectionsListNodeOpen()) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                CVSConnectionOverlayClient.updateOverlayIconsImpl();
                CVSConnectionOverlayClient.getOverlayCache().fireOverlaysChanged();
            }
        });
    }

    private static void updateOverlayIconsImpl() {
        CVSConnectionListNode list = CVSConnectionNodes.getConnectionListNode();
        if (list == null || !list.isOpen()) {
            return;
        }
        Iterator itr = list.getChildren();
        while (itr.hasNext()) {
            CVSConnectionOverlayClient.updateOverlayIconImpl((Element)itr.next());
        }
    }

    private static IconOverlayCache getOverlayCache() {
        return IconOverlayCache.getInstance();
    }

    private static final boolean isControlled(Element e) {
        return e instanceof CVSConnectionNode;
    }

    private static final IconOverlay getLoginOverlayIcon(Element e) {
        if (!_enabled || !CVSConnectionOverlayClient.isControlled(e)) {
            return null;
        }
        CVSRootString root = new CVSRootString(((CVSConnectionNode)e).getConnection().getRoot());
        if (!CVSLogin.hasMethod(root)) {
            return null;
        }
        if (CVSLogin.getMethod(root).isLoggedIn(root)) {
            return new IconOverlay(OracleIcons.getIcon((String)"extras/overlay_unlocked.png"), null, null);
        }
        return new IconOverlay(OracleIcons.getIcon((String)"extras/overlay_locked.png"), null, CVSArb.get("OVERLAY_LABEL_NOT_AUTHENTICATED"));
    }

    private static final IconOverlay getSupportOverlayIcon(Element e) {
        if (!_enabled || !CVSConnectionOverlayClient.isControlled(e)) {
            return null;
        }
        if (CVSConnectionListAPI.isSupportedConnection(((CVSConnectionNode)e).getConnection())) {
            return null;
        }
        return new IconOverlay(OracleIcons.getIcon((String)"extras/overlay_unsupported.png"), null, null);
    }

    private static final boolean isConnectionsListNodeOpen() {
        CVSConnectionListNode node = CVSConnectionNodes.getConnectionListNode();
        return node != null && node.isOpen();
    }
}

