/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.awt.EventQueue;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.Object2DomLogger;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.util.ImageIconCache;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDetailsKey;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionElement;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileConstants;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListModel;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionObservable;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.util.CVSFileConstants;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.SAXParseException;

public class CVSConnectionListNode
extends DefaultContainer
implements CVSConnectionElement,
CVSConnectionDetailsKey,
CVSConnectionFileConstants {
    private URL _file = URLFactory.newFileURL((String)(ExtensionRegistry.getOracleRegistry().getSystemDirectory("oracle.jdeveloper.cvs").getPath() + CVSFileConstants.separator + "cvs_connect.xml"));
    private final CVSConnectionListModel _model = new CVSConnectionListModel();
    private final CVSConnectionListData _data = new CVSConnectionListData(this, this._model);

    public CVSConnectionListNode() {
        this(true);
    }

    public CVSConnectionListNode(boolean load) {
        if (load) {
            this.load();
        }
    }

    public Object getData() {
        return this._data;
    }

    public Icon getIcon() {
        return ImageIconCache.get((URL)CVSArb.class.getResource(CVSArb.get("CONNECTION_LIST_NODE_ICON")));
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        return CVSArb.get("CONNECTION_LIST_NODE_LABEL");
    }

    protected void openImpl() throws IOException {
        CVSClient client = CVSClient.getInstance();
        client.verifyClientState();
        if (!client.isClientAvailable()) {
            UpdateMessage.fireObjectClosed((Subject)this);
            return;
        }
        super.openImpl();
        this.createConnections();
    }

    public void saveListNode() {
        try {
            this.save(this._file);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public boolean hasConnection(String name) {
        return this._model.getData().containsKey(name);
    }

    public boolean hasConnection() {
        return this._children.size() > 0;
    }

    public void addConnection(CVSConnectionData data) {
        this.addConnection(data.getDetails());
        CVSConnectionObservable.getObservable().notifyObservers();
    }

    public void addConnection(Map details) {
        this.addConnectionImpl(details, true);
        CVSConnectionObservable.getObservable().notifyObservers();
    }

    public void updateConnection(String name, CVSConnectionData update) {
        this.updateConnection(name, update.getDetails());
        CVSConnectionObservable.getObservable().notifyObservers();
    }

    public void updateConnection(String name, Map update) {
        this.updateConnectionImpl(name, update);
        CVSConnectionObservable.getObservable().notifyObservers();
    }

    public void removeConnection(String name) {
        this.removeConnectionImpl(name);
        CVSConnectionObservable.getObservable().notifyObservers();
    }

    public final void load(URL f) throws IOException {
        if (f == null || !URLFileSystem.exists((URL)f)) {
            return;
        }
        ClassLoader cl = ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.cvs");
        Object2Dom o2d = Object2Dom.newInstance();
        o2d.setLogger(0, new Object2DomLogger(){

            public void logXMLParseException(XMLParseException e) {
            }

            public void logSAXParseException(SAXParseException e) {
            }

            public void logUnmarshalException(int line, int col, Throwable t) {
            }

            public void logOtherException(Throwable t) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
            }

            public void logMessage(String mesg) {
            }

            public void logXMLDocument(XMLDocument document) {
            }
        });
        HashMap m = (HashMap)o2d.toObject(f, cl);
        if (m == null) {
            m = new HashMap();
        }
        this._model.setData(m);
    }

    public final void save(URL f) throws IOException {
        if (f == null) {
            return;
        }
        Map m = this._model.getData();
        Object2Dom o2d = Object2Dom.newInstance();
        o2d.setNamespaceURI(NAMESPACE_URI);
        o2d.toDocument((Object)m, "connection_list", f);
    }

    CVSConnectionListModel getListModel() {
        return this._model;
    }

    final void addConnectionImpl(Map details) {
        this.addConnectionImpl(details, true);
    }

    final void addConnectionImpl(Map details, boolean save) {
        this.addConnectionImpl(details, save, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addConnectionImpl(Map details, boolean save, boolean notify) {
        String name = (String)details.get(KEY_CONNECTION_NAME);
        if (name == null || name.equals("")) {
            return;
        }
        CVSConnectionData data = new CVSConnectionData(name, this._model);
        final CVSConnectionNode n = new CVSConnectionNode(data);
        this._model.setValues(name, new HashMap(details));
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this._children.add(n);
        }
        if (notify) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateMessage.fireChildAdded((Subject)CVSConnectionListNode.this, (Element)n);
                }
            });
        }
        if (save) {
            this.saveListNode();
        }
    }

    final void updateConnectionImpl(String name, Map update) {
        this.updateConnectionImpl(name, update, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateConnectionImpl(String name, Map update, boolean save) {
        CVSConnectionListModel cVSConnectionListModel = this._model;
        synchronized (cVSConnectionListModel) {
            Map details = this._model.getValues(name);
            if (this.areMapsEqual(details, update)) {
                return;
            }
            String name2 = (String)update.get(KEY_CONNECTION_NAME);
            CVSConnectionNode n = this.getConnectionNode(name);
            if (name.equals(name2)) {
                if (n != null) {
                    this.closeConnectionNode(n);
                    this._model.setValues(name, update);
                    UpdateMessage.fireObjectClosed((Subject)n);
                }
            } else {
                this.removeConnectionImpl(name, false, false);
                if (n != null) {
                    n.getConnection().setName(name2);
                }
                this.addConnectionImpl(update, false, false);
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdateMessage.fireStructureChanged((Subject)CVSConnectionListNode.this);
            }
        });
        if (save) {
            this.saveListNode();
        }
    }

    final void removeConnectionImpl(String name) {
        this.removeConnectionImpl(name, true);
    }

    final void removeConnectionImpl(String name, boolean save) {
        this.removeConnectionImpl(name, save, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeConnectionImpl(String name, boolean save, boolean notify) {
        this._model.clearValues(name);
        final CVSConnectionNode n = this.getConnectionNode(name);
        if (n == null) {
            return;
        }
        this.closeConnectionNode(n);
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this._children.remove(n);
        }
        if (notify) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateMessage.fireChildRemoved((Subject)CVSConnectionListNode.this, (Element)n);
                }
            });
        }
        if (save) {
            this.saveListNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CVSConnectionNode getConnectionNode(String name) {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            for (int i = 0; i < this._children.size(); ++i) {
                CVSConnectionNode n = (CVSConnectionNode)this._children.get(i);
                if (!n.getConnection().getName().equals(name)) continue;
                return n;
            }
            return null;
        }
    }

    private final void load() {
        try {
            this.load(this._file);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createConnections() {
        Object object = this._children;
        synchronized (object) {
            this._children.clear();
        }
        object = this._model;
        synchronized (object) {
            Iterator itr = this._model.getKeys();
            while (itr.hasNext()) {
                Map details = this._model.getValues((String)itr.next());
                this.addConnectionImpl(details, false);
            }
        }
    }

    private final void closeConnectionNode(CVSConnectionNode n) {
        try {
            n.close();
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
        }
    }

    private final boolean areMapsEqual(Map m1, Map m2) {
        if (!m1.equals(m2)) {
            return false;
        }
        for (Object key : m1.keySet()) {
            Object o = m1.get(key);
            Object o2 = m1.get(key);
            if (!(o == null || o2 == null ? o != null || o2 != null : !o.equals(o2))) continue;
            return false;
        }
        return true;
    }

    static class ClientIOException
    extends IOException {
        ClientIOException() {
        }
    }
}

