/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class CVSConnectionListModel {
    private final Map _data = new HashMap();

    CVSConnectionListModel() {
    }

    final synchronized Iterator getKeys() {
        return new HashMap(this._data).keySet().iterator();
    }

    final synchronized void setData(Map data) {
        Iterator itr = data.keySet().iterator();
        while (itr.hasNext()) {
            String connection = itr.next().toString();
            Map values = (Map)data.get(connection);
            if (values == null || values.size() == 0) continue;
            this.setValues(connection, values);
        }
    }

    final synchronized Map getData() {
        return new HashMap(this._data);
    }

    final synchronized void putValue(String connection, Object key, Object value) {
        Map m = this.findOrCreateMap(connection);
        m.put(key, value);
    }

    final synchronized Object getValue(String connection, Object key) {
        Map m = (Map)this._data.get(connection);
        if (m == null) {
            return null;
        }
        return m.get(key);
    }

    final synchronized void setValues(String connection, Map values) {
        Map m = this.findOrCreateMap(connection);
        m.clear();
        m.putAll(values);
    }

    final synchronized Map getValues(String connection) {
        Map m = (Map)this._data.get(connection);
        if (m == null) {
            return new HashMap();
        }
        return new HashMap(m);
    }

    final synchronized void clearValues(String connection) {
        this._data.remove(connection);
    }

    final synchronized int size() {
        return this._data.size();
    }

    private final Map findOrCreateMap(String connection) {
        HashMap m = (HashMap)this._data.get(connection);
        if (m == null) {
            m = new HashMap();
            this._data.put(connection, m);
        }
        return m;
    }
}

