/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.util.Log;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.util.VCSCollectionUtils;
import oracle.jdevimpl.vcs.cvs.CVSActiveClient;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDirectoryData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFilePathUtils;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileURL;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionLsSupportCache;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionModuleData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionServices;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;

class CVSConnectionDefaultServices
extends CVSConnectionServices {
    private static final Log LOG = new Log("vcs-cvs");

    CVSConnectionDefaultServices() {
    }

    @Override
    CVSConnectionDirectoryData[] getRootDirectoryList(String root) throws Exception {
        CVSConnectionFileData[] lsFileData = this.ls(root, ".", false);
        if (lsFileData != null) {
            return (CVSConnectionDirectoryData[])VCSCollectionUtils.toArrayType(Arrays.asList(lsFileData), CVSConnectionDirectoryData.class);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    CVSConnectionModuleData[] getModuleList(String root) throws Exception {
        final ArrayList moduleData = new ArrayList();
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.getParameters().setQuiet(true);
        runner.setCmdArray_(new String[]{"co", "-c"});
        runner.getParameters().setRoot(root);
        runner.addOutputMonitor(new CVSProcessStreamMonitor(){
            private final Pattern _pattern = Pattern.compile("^([\\S&&[^\\&]]\\S*).*");

            @Override
            protected void streamLine(String line, CVSProcess process) throws Exception {
                CVSConnectionDefaultServices.this.debugSystemOut(line);
                Matcher matcher = this._pattern.matcher(line);
                if (!matcher.matches()) {
                    return;
                }
                moduleData.add(new CVSConnectionModuleData(matcher.group(1)));
            }
        });
        JSchAuthFailStreamMonitor jschAuthFailStreamMonitor = new JSchAuthFailStreamMonitor();
        runner.addErrorMonitor(jschAuthFailStreamMonitor);
        this.debugCommand(runner.getCmdList_());
        runner.exec_();
        if (jschAuthFailStreamMonitor.isAuthFailed()) {
            throw new JSchAuthFailException();
        }
        this.debugEOF();
        if (runner.getExitCode_() == null || runner.getExitCode_() != 0) {
            if (runner.getErrorText_() != null) {
                LOG.trace("CVS:");
                LOG.trace(runner.getErrorText_());
            }
            throw new VCSCancelException();
        }
        return moduleData.toArray(new CVSConnectionModuleData[0]);
    }

    @Override
    CVSConnectionFileData[] getDirectoryList(String root, String path) throws Exception {
        CVSConnectionFileData[] lsFileData = this.ls(root, path, true);
        if (lsFileData != null) {
            return lsFileData;
        }
        final ArrayList fileData = new ArrayList();
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.getParameters().setQuiet(true);
        runner.setCmdArray_(new String[]{"rdiff", "-D", "1970-01-02", "-s", path});
        runner.getParameters().setRoot(root);
        runner.addOutputMonitor(new CVSProcessStreamMonitor(){
            private final Pattern _pattern = Pattern.compile("File (.*) is new; current revision (.*)");

            @Override
            protected void streamLine(String line, CVSProcess process) throws Exception {
                CVSConnectionDefaultServices.this.debugSystemOut(line);
                Matcher matcher = this._pattern.matcher(line);
                if (!matcher.matches()) {
                    return;
                }
                String path = CVSConnectionFilePathUtils.canonicalizePath(matcher.group(1));
                fileData.add(new CVSConnectionFileData(path, matcher.group(2)));
            }
        });
        runner.addErrorMonitor(new CVSProcessStreamMonitor(){
            private final Pattern _pattern = Pattern.compile(".*\\p{Alpha}+: Diffing (.*)");

            @Override
            protected void streamLine(String line, CVSProcess process) throws Exception {
                CVSConnectionDefaultServices.this.debugSystemErr(line);
                Matcher matcher = this._pattern.matcher(line);
                if (!matcher.matches()) {
                    return;
                }
                String path = CVSConnectionFilePathUtils.canonicalizePath(matcher.group(1));
                fileData.add(new CVSConnectionDirectoryData(path));
            }
        });
        this.debugCommand(runner.getCmdList_());
        runner.exec_();
        this.debugEOF();
        return fileData.toArray(new CVSConnectionFileData[0]);
    }

    @Override
    byte[] getRevisionContents(CVSConnectionFileURL url) throws Exception {
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.addAll(Arrays.asList("rdiff", "-D", "1970-01-02"));
        String revision = url.getRevision();
        if (revision != null) {
            cmd.addAll(Arrays.asList("-r", revision));
        }
        cmd.add(url.getPath());
        runner.getParameters().setQuiet(true);
        runner.setCmdList_(cmd);
        runner.getParameters().setRoot(url.getRoot());
        final StringBuilder stringBuffer = new StringBuilder();
        runner.addOutputMonitor(new CVSProcessStreamMonitor(){

            @Override
            protected void streamLine(String line, CVSProcess process) throws Exception {
                CVSConnectionDefaultServices.this.debugSystemOut(line);
                if (!line.startsWith("+")) {
                    return;
                }
                if (line.length() > 2) {
                    stringBuffer.append(line.substring(2));
                }
                stringBuffer.append('\n');
            }
        });
        this.debugCommand(runner.getCmdList_());
        runner.exec_();
        this.debugEOF();
        return stringBuffer.toString().getBytes();
    }

    protected CVSConnectionFileData[] ls(String root, final String path, boolean recursive) throws Exception {
        if (!CVSActiveClient.isClientLsSupported()) {
            return null;
        }
        if (CVSConnectionLsSupportCache.has(root) && !CVSConnectionLsSupportCache.get(root)) {
            return null;
        }
        final ArrayList fileData = new ArrayList();
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.getParameters().setQuiet(true);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("ls");
        cmd.add("-e");
        if (recursive) {
            cmd.add("-R");
        }
        cmd.add(path);
        runner.setCmdList_(cmd);
        runner.getParameters().setRoot(root);
        runner.addOutputMonitor(new CVSProcessStreamMonitor(){
            private final Pattern _pattern = Pattern.compile("Directory (.+)");
            private String _path = path;

            @Override
            protected void streamLine(String line, CVSProcess process) throws Exception {
                CVSConnectionDefaultServices.this.debugSystemOut(line);
                Matcher matcher = this._pattern.matcher(line);
                if (matcher.matches()) {
                    this._path = matcher.group(1).trim();
                    return;
                }
                CVSEntry entry = CVSEntry.parseEntrySpec(line);
                if (entry == null) {
                    return;
                }
                String path0 = CVSConnectionFilePathUtils.canonicalizePath(this._path.equals(".") ? entry.getName() : this._path + '/' + entry.getName());
                if (entry.isDirectory()) {
                    fileData.add(new CVSConnectionDirectoryData(path0));
                } else {
                    fileData.add(new CVSConnectionFileData(path0, entry.getRevision()));
                }
            }
        });
        JSchAuthFailStreamMonitor jschAuthFailStreamMonitor = new JSchAuthFailStreamMonitor();
        runner.addErrorMonitor(jschAuthFailStreamMonitor);
        this.debugCommand(runner.getCmdList_());
        runner.exec_();
        if (jschAuthFailStreamMonitor.isAuthFailed()) {
            throw new JSchAuthFailException();
        }
        this.debugEOF();
        if (runner.getExitCode_() == null || runner.getExitCode_() != 0) {
            if (runner.getErrorText_() != null) {
                LOG.trace(runner.getErrorText_());
            }
            if (!CVSConnectionLsSupportCache.has(root)) {
                CVSConnectionLsSupportCache.cache(root, false);
            }
            return null;
        }
        CVSConnectionLsSupportCache.cache(root, true);
        return fileData.toArray(new CVSConnectionFileData[0]);
    }

    private void debugCommand(Collection cmd) {
        this.debug("> " + cmd);
    }

    private void debugSystemOut(String s) {
        this.debug("out> " + s);
    }

    private void debugSystemErr(String s) {
        this.debug("err> " + s);
    }

    private void debugEOF() {
        this.debug("EOF");
    }

    private void debug(String s) {
        if (Boolean.getBoolean("jdev.cvs.debugbrowser")) {
            LOG.trace(s);
        }
    }

    protected class JSchAuthFailStreamMonitor
    extends CVSProcessStreamMonitor {
        private boolean _authFailed;

        JSchAuthFailStreamMonitor() {
        }

        @Override
        protected void streamLine(String line, CVSProcess process) throws Exception {
            if (line.indexOf("JSch: Auth fail") >= 0 || line.indexOf("JSch: Auth cancel") >= 0) {
                this._authFailed = true;
            }
        }

        boolean isAuthFailed() {
            return this._authFailed;
        }
    }

    protected class JSchAuthFailException
    extends Exception {
        JSchAuthFailException() {
        }
    }
}

