/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.login;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.login.CVSDefaultMethod;
import oracle.jdevimpl.vcs.cvs.login.CVSLoginEvent;
import oracle.jdevimpl.vcs.cvs.login.CVSLoginListener;
import oracle.jdevimpl.vcs.cvs.login.CVSLoginMethod;
import oracle.jdevimpl.vcs.cvs.login.CVSLoginUtils;
import oracle.jdevimpl.vcs.cvs.login.CVSPServerMethod;

public final class CVSLogin {
    private static final Map _methods = CVSLogin.createLoginMethods();
    private static final Collection _loginListeners = new ArrayList();

    private CVSLogin() {
    }

    public static final Iterator getMethodIterator() {
        return _methods.values().iterator();
    }

    public static final boolean hasMethod(URL dir) {
        CVSRootString root = CVSLoginUtils.getSandboxRootImpl(dir);
        return root != null ? CVSLogin.hasMethod(root) : false;
    }

    public static final CVSLoginMethod getMethod(URL dir) {
        CVSRootString root = CVSLoginUtils.getSandboxRootImpl(dir);
        return CVSLogin.getMethodImpl(root);
    }

    public static final boolean hasMethod(CVSRootString root) {
        return _methods.containsKey(root.getAccessMethod());
    }

    public static final CVSLoginMethod getMethod(CVSRootString root) {
        return CVSLogin.getMethodImpl(root);
    }

    public static final void clearCachedObjects() {
        Iterator itr = CVSLogin.getMethodIterator();
        while (itr.hasNext()) {
            ((CVSLoginMethod)itr.next()).clearCachedObjects();
        }
    }

    public static final void addLoginListener(CVSLoginListener l) {
        _loginListeners.add(l);
    }

    public static final void removeLoginListener(CVSLoginListener l) {
        _loginListeners.remove(l);
    }

    static final void fireLoginPerformed(Object source, CVSRootString root) {
        CVSLoginEvent le = new CVSLoginEvent(source, 1, root);
        Iterator itr = _loginListeners.iterator();
        while (itr.hasNext()) {
            ((CVSLoginListener)itr.next()).loginPerformed(le);
        }
    }

    static final void fireLogoutPerformed(Object source, CVSRootString root) {
        CVSLoginEvent le = new CVSLoginEvent(source, 2, root);
        Iterator itr = _loginListeners.iterator();
        while (itr.hasNext()) {
            ((CVSLoginListener)itr.next()).logoutPerformed(le);
        }
    }

    private static final CVSLoginMethod getMethodImpl(CVSRootString root) {
        if (root == null || !CVSLogin.hasMethod(root)) {
            return new CVSDefaultMethod();
        }
        return (CVSLoginMethod)_methods.get(root.getAccessMethod());
    }

    private static final Map createLoginMethods() {
        HashMap<String, CVSPServerMethod> m = new HashMap<String, CVSPServerMethod>();
        m.put("pserver", new CVSPServerMethod());
        return Collections.unmodifiableMap(m);
    }
}

