/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.control.tagchooser;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.spi.VCSHashURL;

public class CVSTagCache {
    private static final CVSTagCache _instance = new CVSTagCache();
    private static final Map<VCSHashURL, Collection<Tag>> _cache = new LinkedHashMap<VCSHashURL, Collection<Tag>>();

    static CVSTagCache getInstance() {
        return _instance;
    }

    synchronized void cache(URL url, Tag tag) {
        Collection<Tag> tags = _cache.get(url);
        if (tags == null) {
            tags = new HashSet<Tag>();
            _cache.put(new VCSHashURL(url), tags);
        }
        tags.add(tag);
    }

    synchronized Collection<Tag> get(URL url) {
        return _cache.get(new VCSHashURL(url));
    }

    synchronized Collection<Tag> get(URLFilter filter) {
        HashSet<Tag> resultTags = new HashSet<Tag>();
        for (Map.Entry<VCSHashURL, Collection<Tag>> entry : _cache.entrySet()) {
            if (!filter.accept(entry.getKey().getURL())) continue;
            resultTags.addAll(entry.getValue());
        }
        return resultTags;
    }

    synchronized void clear(URLFilter filter) {
        for (VCSHashURL url : new HashSet<VCSHashURL>(_cache.keySet())) {
            if (!filter.accept(url.getURL())) continue;
            _cache.remove(url);
        }
    }

    synchronized void clear() {
        _cache.clear();
    }

    public static class Tag
    implements Comparable<Tag> {
        private String _name;
        private boolean _branch;

        Tag() {
        }

        Tag(String name) {
            this.setName(name);
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public boolean isBranch() {
            return this._branch;
        }

        public void setBranch(boolean branch) {
            this._branch = branch;
        }

        public boolean equals(Object o) {
            return o instanceof Tag && this._name.equals(((Tag)o)._name);
        }

        public int hashCode() {
            return this._name.hashCode();
        }

        @Override
        public int compareTo(Tag other) {
            return this._name.compareTo(other._name);
        }
    }
}

