/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.control;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.controls.completionfield.FieldInsightProvider;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.runner.CVSInternalClientRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.ocvs.OCVSPrompter;
import oracle.ocvs.OCVSRoot;

public class CVSTagFieldInsightProvider
implements FieldInsightProvider {
    private final ArrayList _tags = new ArrayList();
    private boolean _stopped = true;

    public void startTagSearch(final URL[] urls) {
        if (urls == null || urls.length <= 0) {
            this.stopTagSearch();
            return;
        }
        Runnable searchTagsRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    this.searchTags();
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }

            private void searchTags() throws Exception {
                final HashSet tags = new HashSet();
                for (int i = 0; i < urls.length && !CVSTagFieldInsightProvider.this.isTagSearchStopped(); ++i) {
                    URL directoryUrl;
                    URL uRL = directoryUrl = URLFileSystem.isDirectoryPath((URL)urls[i]) ? urls[i] : URLFileSystem.getParent((URL)urls[i]);
                    if (!CVSUtil.isOpenSessionSandbox(directoryUrl)) continue;
                    CVSRunner runner = this.createRunner();
                    runner.getParameters().setKeepCachedFiles(true);
                    runner.setDirURL_(directoryUrl);
                    ArrayList<String> cmd = new ArrayList<String>();
                    cmd.add("log");
                    if (CVSClient.getInstance().isUsingInternalClient() && CVSInternalClientSupport.isSupportedCommandOption("log", 'h')) {
                        cmd.add("-h");
                    }
                    if (!URLFileSystem.isDirectoryPath((URL)urls[i])) {
                        cmd.add(URLFileSystem.getFileName((URL)urls[i]));
                    }
                    runner.setCmdList_(cmd);
                    runner.addOutputMonitor(new CVSProcessStreamMonitor(){
                        private final Pattern _pattern = Pattern.compile("\\t(.+?): (.*)");

                        @Override
                        protected void streamLine(String line, CVSProcess process) throws Exception {
                            Matcher matcher = this._pattern.matcher(line);
                            if (matcher.find()) {
                                tags.add(matcher.group(1));
                            }
                        }
                    });
                    runner.exec_();
                }
                if (CVSTagFieldInsightProvider.this.isTagSearchStopped()) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (CVSTagFieldInsightProvider.this.isTagSearchStopped()) {
                                return;
                            }
                            ArrayList arrayList = CVSTagFieldInsightProvider.this._tags;
                            synchronized (arrayList) {
                                CVSTagFieldInsightProvider.this._tags.clear();
                                CVSTagFieldInsightProvider.this._tags.addAll(tags);
                                Collections.sort(CVSTagFieldInsightProvider.this._tags);
                            }
                        }
                        finally {
                            CVSTagFieldInsightProvider.this.stopTagSearch();
                        }
                    }
                });
            }

            private CVSRunner createRunner() {
                CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
                runner.getParameters().setQuiet(true);
                if (runner instanceof CVSInternalClientRunner) {
                    ((CVSInternalClientRunner)runner).setPrompter(new CancelPrompter());
                }
                return runner;
            }

            class CancelPrompter
            extends OCVSPrompter {
                CancelPrompter() {
                }

                public char[] promptPassword(OCVSRoot root, String message) {
                    return null;
                }

                public boolean promptSsh2YesNo(String message) {
                    return false;
                }

                public char[] promptSsh2Passphrase(String message) {
                    return null;
                }

                public char[] promptSsh2Password(String message) {
                    return null;
                }
            }
        };
        this.setTagSearchStopped(false);
        new Thread(searchTagsRunnable, "CVSTagFieldInsightProvider").start();
    }

    public synchronized void stopTagSearch() {
        this.setTagSearchStopped(true);
    }

    private synchronized void setTagSearchStopped(boolean stopped) {
        this._stopped = stopped;
    }

    private synchronized boolean isTagSearchStopped() {
        return this._stopped;
    }

    public ListCellRenderer getCellRenderer() {
        return new DefaultListCellRenderer();
    }

    public boolean handlesInsight(Document doc, int pos) {
        return this.getInsightData(doc, pos).length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getInsightData(Document doc, int pos) {
        try {
            String text = doc.getText(0, pos);
            ArrayList<String> data = new ArrayList<String>();
            ArrayList arrayList = this._tags;
            synchronized (arrayList) {
                for (String tag : this._tags) {
                    if (!tag.startsWith(text)) continue;
                    data.add(tag);
                }
            }
            return data.toArray();
        }
        catch (BadLocationException ble) {
            Assert.printStackTrace((Throwable)ble);
            return new Object[0];
        }
    }

    public void completeInsight(Document doc, int pos, Object insightObject) {
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(0, insightObject.toString(), null);
        }
        catch (BadLocationException ble) {
            Assert.printStackTrace((Throwable)ble);
        }
    }

    public boolean isAutoPopupChar(char c) {
        return true;
    }
}

