/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.Log;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.util.CVSFileConstants;

public class CVSEntriesFile {
    public static final String ENTRIES_RELATIVE_PATH = "CVS" + CVSFileConstants.separatorChar + "Entries";
    public static final String ENTRIES_DOT_OLD_RELATIVE_PATH = "CVS" + CVSFileConstants.separatorChar + "Entries.Old";
    public static final String ENTRIES_DOT_ARCHIVE_RELATIVE_PATH = "CVS" + CVSFileConstants.separatorChar + "Entries.Archive";
    private final URL _entriesUrl;
    private static final Log LOG = new Log("vcs-cvs");

    public CVSEntriesFile(URL dir) {
        this(dir, ENTRIES_RELATIVE_PATH);
    }

    public CVSEntriesFile(URL dir, String relativePath) {
        this._entriesUrl = URLFactory.newURL((URL)dir, (String)relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CVSEntry> getEntries() throws IOException {
        if (Boolean.getBoolean("jdev.cvs.debugcachedfiles")) {
            LOG.trace("CVS: reading file " + this._entriesUrl);
        }
        if (!URLFileSystem.exists((URL)this._entriesUrl)) {
            return Collections.emptySet();
        }
        ArrayList<CVSEntry> entries = new ArrayList<CVSEntry>();
        try (BufferedReader in = new BufferedReader(new FileReader(URLFileSystem.getPlatformPathName((URL)this._entriesUrl)));){
            String line;
            while ((line = in.readLine()) != null) {
                CVSEntry entry = CVSEntry.parseEntrySpec(line);
                if (entry == null) continue;
                entries.add(entry);
            }
            ArrayList<CVSEntry> arrayList = entries;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEntries(Collection<CVSEntry> entries) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(URLFileSystem.getPlatformPathName((URL)this._entriesUrl)));){
            Iterator<CVSEntry> itr = entries.iterator();
            while (itr.hasNext()) {
                bw.write(itr.next().toString());
                bw.newLine();
            }
        }
    }

    public static final CVSEntry findEntry(Collection entries, URL file) {
        if (entries == null) {
            return null;
        }
        String fileName = URLFileSystem.getFileName((URL)file);
        for (CVSEntry entry : entries) {
            if (!fileName.equals(entry.getName())) continue;
            return entry;
        }
        return null;
    }
}

