/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.Component;
import java.awt.Container;
import oracle.ide.panels.TraversalException;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.spi.VCSPreferencesTraversable;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;
import oracle.jdevimpl.vcs.cvs.CVSVersionToolsPrefs;
import oracle.jdevimpl.vcs.cvs.ui.CVSVersionToolsTraversableUI;

public class CVSVersionToolsTraversable
extends VCSPreferencesTraversable<CVSVersionToolsPrefs> {
    private static final int TIMEOUT_SCALE_MINUTES = 1;
    private static final int TIMEOUT_SCALE_HOURS = 2;
    private CVSVersionToolsTraversableUI _customizerUI;

    public CVSVersionToolsTraversable() {
        this.setHelpID("f1_cvspreferencesversiontools_html");
    }

    protected CVSVersionToolsPrefs getPreferences(PropertyStorage prefs) {
        return CVSVersionToolsPrefs.getInstance(prefs);
    }

    protected Component getPage() {
        if (this._customizerUI == null) {
            this.createComponent();
        }
        return this._customizerUI;
    }

    protected void loadPreferences(CVSVersionToolsPrefs prefs) {
        String value = prefs.getChangelistCommitDialog();
        this._customizerUI.getCommitDialogAlways().setSelected("changelist_commit_dialog_always".equals(value));
        this._customizerUI.getCommitDialogComments().setSelected("changelist_commit_dialog_comments".equals(value));
        this._customizerUI.getCommitDialogNever().setSelected("changelist_commit_dialog_never".equals(value));
        int seconds = prefs.getChangelistTimer();
        int scale = this.calculateTimeoutScale(seconds);
        this._customizerUI.getIncomingChangesTimerQuantity().setNumber((Number)new Integer(this.calculateTimeoutQuantity(seconds, scale)));
        if (scale == 2) {
            this._customizerUI.getIncomingChangesTimerHours().setSelected(true);
        }
        if (scale == 1) {
            this._customizerUI.getIncomingChangesTimerMinutes().setSelected(true);
        }
        this._customizerUI.setMergeEditor(prefs.getMergeEditor());
    }

    protected void savePreferences(CVSVersionToolsPrefs prefs) {
        Integer mergeEditor;
        Integer quantity;
        Integer quantity0;
        String value = this._customizerUI.getCommitDialogAlways().isSelected() ? "changelist_commit_dialog_always" : (this._customizerUI.getCommitDialogNever().isSelected() ? "changelist_commit_dialog_never" : "changelist_commit_dialog_comments");
        prefs.setChangelistCommitDialog(value);
        int scale = 1;
        if (this._customizerUI.getIncomingChangesTimerHours().isSelected()) {
            scale = 2;
        }
        Integer n = quantity0 = (quantity = (Integer)this._customizerUI.getIncomingChangesTimerQuantity().getNumber()) != null ? new Integer(this.calculateTimeoutSeconds(quantity, scale)) : null;
        if (quantity0 != null) {
            prefs.setChangelistTimer(quantity0);
        }
        if ((mergeEditor = this._customizerUI.getMergeEditor()) != null) {
            prefs.setMergeEditor(this._customizerUI.getMergeEditor());
        }
    }

    protected void validatePreferences() throws TraversalException {
    }

    private Component createComponent() {
        this._customizerUI = new CVSVersionToolsTraversableUI();
        this._customizerUI.getIncomingChangesTimerQuantity().setColumns(10);
        this._customizerUI.getIncomingChangesTimerQuantity().setDecimal(true);
        this._customizerUI.getIncomingChangesTimerQuantity().setSigned(false);
        this._customizerUI.getIncomingChangesTimerQuantity().setDataType(Integer.class);
        CVSResourcePicker.getPicker((Object)this).start((Container)this._customizerUI);
        return this._customizerUI;
    }

    private int calculateTimeoutScale(int seconds) {
        if (seconds > 0 && seconds % 3600 == 0) {
            return 2;
        }
        return 1;
    }

    private int calculateTimeoutQuantity(int seconds, int scale) {
        if (scale == 2) {
            return seconds / 3600;
        }
        return seconds / 60;
    }

    private int calculateTimeoutSeconds(int quantity, int scale) {
        if (scale == 2) {
            return quantity * 3600;
        }
        return quantity * 60;
    }
}

