/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.net.URL;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;

public final class CVSRootContext {
    private CVSRootString _root;
    private String _cvsRsh;
    private String _cvsServer;

    public CVSRootContext(String root) {
        this(new CVSRootString(root));
    }

    public CVSRootContext(CVSRootString root) {
        this(root, null, null);
        CVSConnectionData conn = this.getConnection();
        if (root != null && conn == null) {
            return;
        }
        this._cvsRsh = conn.getCVSRsh();
        this._cvsServer = conn.getCVSServer();
    }

    public CVSRootContext(String root, String cvsRsh, String cvsServer) {
        this(new CVSRootString(root), cvsRsh, cvsServer);
    }

    private CVSRootContext(CVSRootString root, String cvsRsh, String cvsServer) {
        this._root = root;
        this._cvsRsh = cvsRsh;
        this._cvsServer = cvsServer;
    }

    public final CVSRootString getCVSRoot() {
        return this._root;
    }

    public final String getCVSRsh() {
        return this._cvsRsh;
    }

    public final String getCVSServer() {
        return this._cvsServer;
    }

    public CVSRootContext canonicalize() {
        return new CVSRootContext(this._root.canonicalize(), this._cvsRsh, this._cvsServer);
    }

    public final boolean isAccessExternalSSH() {
        if (!this._root.isAccessExternal()) {
            return false;
        }
        if (this._cvsRsh == null || this._cvsRsh.equals("")) {
            return false;
        }
        String rshName = this._cvsRsh;
        URL url = URLFactory.newFileURL((String)this._cvsRsh);
        if (URLFileSystem.exists((URL)url) && !URLFileSystem.isDirectory((URL)url)) {
            rshName = URLFileSystem.getFileName((URL)url);
        }
        return CVSUtil.createSSHProgramRE().matcher(rshName).find();
    }

    public CVSConnectionData getConnection() {
        if (this._root == null) {
            return null;
        }
        String root = this._root.toString();
        CVSConnectionListAPI list = CVSConnectionNodes.getConnectionListAPI();
        if (root == null || list == null) {
            return null;
        }
        String name = ((CVSConnectionListData)list).getRootConnection(root);
        if (name == null) {
            return null;
        }
        return ((CVSConnectionListData)list).getConnectionAPI(name);
    }
}

