/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.StringReader;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.Log;
import oracle.jdeveloper.vcs.properties.PropertiesPanel;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.util.AccessibleLabel;

public class CVSPropertiesPanel
extends PropertiesPanel {
    private Element _element;
    private URL _url;
    private Component _component;
    private JLabel _statusLabel;
    private JLabel _workingRevisionLabel;
    private JLabel _repositoryRevisionLabel;
    private JLabel _rcsFileLabel;
    private JLabel _stickyTagLabel;
    private JLabel _stickyDateLabel;
    private JLabel _stickyOptionsLabel;
    private JLabel _existingTagsLabel;
    private JLabel _statusValueLabel;
    private JTextField _workingRevisionTextField;
    private JTextField _repositoryRevisionTextField;
    private JTextField _rcsFileTextField;
    private JTextField _stickyTagTextField;
    private JTextField _stickyDateTextField;
    private JTextField _stickyOptionsTextField;
    private ExistingTagsTable _existingTagsTable;
    private JScrollPane _existingTagsTableScrollPane;
    private CVSRunner _runner = CVSRunnerFactory.getInstance().createRunner();
    private StatusData _statusData;

    public CVSPropertiesPanel(Element element, URL url) {
        this._element = element;
        this._url = url;
    }

    public Component getComponent() {
        if (this._component != null) {
            return this._component;
        }
        boolean isDirectory = URLFileSystem.isDirectory((URL)this._url);
        this.createComponents(this._url, isDirectory);
        this.resComponents(this._url, isDirectory);
        this.initializeComponents(this._url, isDirectory);
        LayoutBuilder layoutBuilder = this.layoutComponents(this._url, isDirectory);
        JPanel panel = new JPanel();
        layoutBuilder.addToPanel((Container)panel);
        Box box = Box.createVerticalBox();
        box.add(panel);
        box.add(Box.createHorizontalStrut(350));
        this._component = box;
        this.populatePropertyComponents(this._url);
        return this._component;
    }

    public void stopWorkerThreads() {
        CVSRunner runner = this._runner;
        if (runner == null) {
            return;
        }
        final Process process = runner.getRunProcess().getProcess();
        if (process == null) {
            return;
        }
        new Thread("CVSPropertiesPanel Terminate"){

            @Override
            public void run() {
                try {
                    process.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    private void createComponents(URL url, boolean isDirectory) {
        this._statusLabel = new JLabel();
        this._workingRevisionLabel = new JLabel();
        this._repositoryRevisionLabel = new JLabel();
        this._rcsFileLabel = new JLabel();
        this._stickyTagLabel = new JLabel();
        this._stickyDateLabel = new JLabel();
        this._stickyOptionsLabel = new JLabel();
        this._existingTagsLabel = new JLabel();
        this._statusValueLabel = new AccessibleLabel();
        this._workingRevisionTextField = new JTextField();
        this._repositoryRevisionTextField = new JTextField();
        this._rcsFileTextField = new JTextField();
        this._stickyTagTextField = new JTextField();
        this._stickyDateTextField = new JTextField();
        this._stickyOptionsTextField = new JTextField();
        this._existingTagsTable = new ExistingTagsTable();
        this._existingTagsTableScrollPane = new JScrollPane((Component)((Object)this._existingTagsTable));
    }

    private void resComponents(URL url, boolean isDirectory) {
        ResourceUtils.resLabel((JLabel)this._statusLabel, (Component)this._statusValueLabel, (String)CVSArb.get("PROPERTIES_STATUS"));
        ResourceUtils.resLabel((JLabel)this._workingRevisionLabel, (Component)this._workingRevisionTextField, (String)CVSArb.get("PROPERTIES_WORKING_REVISION"));
        ResourceUtils.resLabel((JLabel)this._repositoryRevisionLabel, (Component)this._repositoryRevisionTextField, (String)CVSArb.get("PROPERTIES_REPOSITORY_REVISION"));
        ResourceUtils.resLabel((JLabel)this._rcsFileLabel, (Component)this._rcsFileTextField, (String)CVSArb.get("PROPERTIES_RCS_FILE"));
        ResourceUtils.resLabel((JLabel)this._stickyTagLabel, (Component)this._stickyTagTextField, (String)CVSArb.get("PROPERTIES_STICKY_TAG"));
        ResourceUtils.resLabel((JLabel)this._stickyDateLabel, (Component)this._stickyDateTextField, (String)CVSArb.get("PROPERTIES_STICKY_DATE"));
        ResourceUtils.resLabel((JLabel)this._stickyOptionsLabel, (Component)this._stickyOptionsTextField, (String)CVSArb.get("PROPERTIES_STICKY_OPTIONS"));
        ResourceUtils.resLabel((JLabel)this._existingTagsLabel, (Component)((Object)this._existingTagsTable), (String)CVSArb.get("PROPERTIES_EXISTING_TAGS"));
    }

    private void initializeComponents(URL url, boolean isDirectory) {
        this.initializePropertyComponents(this._workingRevisionLabel, this._workingRevisionTextField);
        this.initializePropertyComponents(this._repositoryRevisionLabel, this._repositoryRevisionTextField);
        this.initializePropertyComponents(this._rcsFileLabel, this._rcsFileTextField);
        this.initializePropertyComponents(this._stickyTagLabel, this._stickyTagTextField);
        this.initializePropertyComponents(this._stickyDateLabel, this._stickyDateTextField);
        this.initializePropertyComponents(this._stickyOptionsLabel, this._stickyOptionsTextField);
        this._existingTagsTableScrollPane.setPreferredSize(new Dimension(this._existingTagsTable.getPreferredSize().width, this.calculateExistingTagsTableHeight(4)));
    }

    private int calculateExistingTagsTableHeight(int rows) {
        ExistingTagsTableModel dummyExistingTagsTableModel = new ExistingTagsTableModel();
        dummyExistingTagsTableModel.addColumn(CVSArb.get("PROPERTIES_EXISTING_TAGS_NAME"));
        ExistingTagsTable dummyExistingTagsTable = new ExistingTagsTable();
        dummyExistingTagsTable.installModel((TableModel)((Object)dummyExistingTagsTableModel));
        int height = 0;
        height += dummyExistingTagsTable.getTableHeader().getPreferredSize().height;
        height += this._existingTagsTable.getRowHeight() * rows;
        height += this._existingTagsTable.getIntercellSpacing().height * 2 * rows;
        height += this._existingTagsTable.getInsets().top;
        height += this._existingTagsTable.getInsets().bottom;
        height += this._existingTagsTableScrollPane.getInsets().top;
        return height += this._existingTagsTableScrollPane.getInsets().bottom;
    }

    private LayoutBuilder layoutComponents(URL url, boolean isDirectory) {
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets i = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)this._statusLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._statusValueLabel, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._workingRevisionLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._workingRevisionTextField, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._repositoryRevisionLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._repositoryRevisionTextField, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._rcsFileLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._rcsFileTextField, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._stickyTagLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._stickyTagTextField, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._stickyDateLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._stickyDateTextField, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._stickyOptionsLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._stickyOptionsTextField, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._existingTagsLabel, i, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._existingTagsTableScrollPane, i, 3, false, true);
        layoutBuilder.nl();
        return layoutBuilder;
    }

    private void initializePropertyComponents(JLabel label, JComponent propertyComponent) {
        if (propertyComponent instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)propertyComponent;
            textComponent.setBorder(BorderFactory.createEmptyBorder());
            textComponent.setBackground(UIManager.getColor("control"));
            textComponent.setEditable(false);
        }
        if (label == null) {
            return;
        }
        int height = Math.max(label.getPreferredSize().height, propertyComponent.getPreferredSize().height);
        label.setPreferredSize(new Dimension(label.getPreferredSize().width, height));
        propertyComponent.setPreferredSize(new Dimension(propertyComponent.getPreferredSize().width, height));
    }

    private void populatePropertyComponents(URL url) {
        this._statusData = new StatusData();
        String busyText = CVSArb.get("PROPERTIES_BUSY_TEXT");
        this._statusData._status = "";
        this._statusData._workingRevision = busyText;
        this._statusData._repositoryRevision = busyText;
        this._statusData._rcsFile = busyText;
        this._statusData._stickyTag = busyText;
        this._statusData._stickyDate = busyText;
        this._statusData._stickyOptions = busyText;
        this.setAsynchronousValueComponentsEnabled(false);
        this.updateAsynchronousValueComponents(url);
        new Thread((Runnable)new AsynchronousValueWorker(url), "CVSPropertiesPanel Populate").start();
    }

    private void updateAsynchronousValueComponents(final URL url) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CVSPropertiesPanel.this._updateAsynchronousValueComponents(url);
            }
        });
    }

    private void _updateAsynchronousValueComponents(URL url) {
        if (this._statusData._status != null) {
            this._statusValueLabel.setIcon(this.getStatusIcon(url));
            this._statusValueLabel.setText(this._statusData._status);
            this._statusValueLabel.getAccessibleContext().setAccessibleDescription(this._statusData._status);
        }
        if (this._statusData._workingRevision != null) {
            this._workingRevisionTextField.setText(this._statusData._workingRevision);
        }
        if (this._statusData._repositoryRevision != null) {
            this._repositoryRevisionTextField.setText(this._statusData._repositoryRevision);
        }
        if (this._statusData._rcsFile != null) {
            this._rcsFileTextField.setText(this._statusData._rcsFile);
        }
        if (this._statusData._stickyTag != null) {
            this._stickyTagTextField.setText(this._statusData._stickyTag);
        }
        if (this._statusData._stickyDate != null) {
            this._stickyDateTextField.setText(this._statusData._stickyDate);
        }
        if (this._statusData._stickyOptions != null) {
            this._stickyOptionsTextField.setText(this._statusData._stickyOptions);
        }
        if (this._statusData._existingTags == null) {
            return;
        }
        ExistingTagsTableModel existingTagsTableModel = new ExistingTagsTableModel();
        existingTagsTableModel.addColumn(CVSArb.get("PROPERTIES_EXISTING_TAGS_NAME"));
        existingTagsTableModel.addColumn(CVSArb.get("PROPERTIES_EXISTING_TAGS_TYPE"));
        existingTagsTableModel.addColumn(CVSArb.get("PROPERTIES_EXISTING_TAGS_REVISION"));
        for (TagData tagData : this._statusData._existingTags) {
            existingTagsTableModel.addRow(new Object[]{tagData._name, tagData._type, tagData._revision});
        }
        this._existingTagsTable.installModel((TableModel)((Object)existingTagsTableModel));
    }

    private void setAsynchronousValueComponentsEnabled(final boolean enabled) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CVSPropertiesPanel.this._setAsynchronousValueComponentsEnabled(enabled);
            }
        });
    }

    private void _setAsynchronousValueComponentsEnabled(boolean enabled) {
        this._workingRevisionTextField.setEnabled(enabled);
        this._repositoryRevisionTextField.setEnabled(enabled);
        this._rcsFileTextField.setEnabled(enabled);
        this._stickyTagTextField.setEnabled(enabled);
        this._stickyDateTextField.setEnabled(enabled);
        this._stickyOptionsTextField.setEnabled(enabled);
        this._existingTagsTable.setEnabled(enabled);
    }

    private Icon getStatusIcon(URL url) {
        Icon icon = this._element instanceof Displayable ? this._element.getIcon() : null;
        Icon overlayIcon = null;
        try {
            CVSClient.getInstance();
            VCSStatus status = (VCSStatus)CVSClient.getStatusCache().get(url);
            IconOverlay overlay = status.getOverlay();
            if (overlay != null) {
                overlayIcon = overlay.getDisplayable().getIcon();
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        if (overlayIcon == null) {
            return icon;
        }
        if (icon == null) {
            return overlayIcon;
        }
        return new OverlayIcon(icon, overlayIcon);
    }

    private static class TagData {
        private String _name;
        private String _type;
        private String _revision;

        private TagData() {
        }
    }

    private static class StatusData {
        private String _status;
        private String _workingRevision;
        private String _repositoryRevision;
        private String _rcsFile;
        private String _stickyTag;
        private String _stickyDate;
        private String _stickyOptions;
        private Collection _existingTags;

        private StatusData() {
        }
    }

    private class AsynchronousValueWorker
    implements Runnable {
        private final URL _regularFileUrl;
        private final Log LOG = new Log("vcs-cvs");

        AsynchronousValueWorker(URL regularFileUrl) {
            this._regularFileUrl = regularFileUrl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.getRunner().setDirURL_(URLFileSystem.getParent((URL)this._regularFileUrl));
            this.getRunner().setCommand_("status");
            this.getRunner().getParameters().setOptions(Collections.singleton("-v"));
            this.getRunner().getParameters().setFile(URLFileSystem.getFileName((URL)this._regularFileUrl));
            this.getRunner().getParameters().setQuiet(true);
            try {
                String line;
                this.getRunner().exec_();
                StringBuilder regexpBuffer = new StringBuilder();
                this.appendRegexpPropertySubstring("Status:", regexpBuffer);
                this.appendRegexpPropertySubstring("Working revision:", regexpBuffer);
                this.appendRegexpPropertySubstring("Repository revision:", regexpBuffer);
                regexpBuffer.append("(\\t([^\\t\\n\\r\\f]+))?");
                this.appendRegexpPropertySubstring("Sticky Tag:", regexpBuffer);
                this.appendRegexpPropertySubstring("Sticky Date:", regexpBuffer);
                this.appendRegexpPropertySubstring("Sticky Options:", regexpBuffer);
                regexpBuffer.append("[^E]+");
                regexpBuffer.append("(Existing Tags:\\s+(.+))?");
                Pattern pattern = Pattern.compile(regexpBuffer.toString(), 32);
                Matcher matcher = pattern.matcher(CVSPropertiesPanel.this._runner.getOutputText_());
                if (!matcher.matches()) {
                    this.LOG.trace("Failed to parse CVS status information for properties dialog...");
                    this.LOG.trace("Output:");
                    this.LOG.trace(CVSPropertiesPanel.this._runner.getOutputText_());
                    this.LOG.trace("Errors:");
                    this.LOG.trace(CVSPropertiesPanel.this._runner.getErrorText_());
                    return;
                }
                CVSPropertiesPanel.this._statusData = new StatusData();
                this.getStatusData()._status = this.getMatcherGroup(matcher, 1);
                this.getStatusData()._workingRevision = this.getMatcherGroup(matcher, 2);
                this.getStatusData()._repositoryRevision = this.getMatcherGroup(matcher, 3);
                this.getStatusData()._rcsFile = this.getMatcherGroup(matcher, 5);
                this.getStatusData()._stickyTag = this.getMatcherGroup(matcher, 6);
                this.getStatusData()._stickyDate = this.getMatcherGroup(matcher, 7);
                this.getStatusData()._stickyOptions = this.getMatcherGroup(matcher, 8);
                this.getStatusData()._existingTags = new ArrayList();
                if (matcher.groupCount() < 10 || matcher.group(10) == null) {
                    return;
                }
                String existingTagsString = this.getMatcherGroup(matcher, 10);
                BufferedReader bufferedReader = new BufferedReader(new StringReader(existingTagsString));
                pattern = Pattern.compile("([^\\s]+)\\s+\\(([^:]+):\\s([^\\)]+)\\)");
                while ((line = bufferedReader.readLine()) != null) {
                    if ((line = line.trim()).equals("") || !(matcher = pattern.matcher(line)).matches()) continue;
                    TagData tagData = new TagData();
                    tagData._name = this.getMatcherGroup(matcher, 1);
                    tagData._type = this.getMatcherGroup(matcher, 2);
                    tagData._revision = this.getMatcherGroup(matcher, 3);
                    this.getStatusData()._existingTags.add(tagData);
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            finally {
                CVSClient.getInstance();
                CVSClient.getStatusCache().clear(this._regularFileUrl);
                CVSPropertiesPanel.this._runner = null;
                CVSPropertiesPanel.this.updateAsynchronousValueComponents(this._regularFileUrl);
                CVSPropertiesPanel.this.setAsynchronousValueComponentsEnabled(true);
            }
        }

        private CVSRunner getRunner() {
            return CVSPropertiesPanel.this._runner;
        }

        private StatusData getStatusData() {
            return CVSPropertiesPanel.this._statusData;
        }

        private void appendRegexpPropertySubstring(String propertyString, StringBuilder regexpBuffer) {
            regexpBuffer.append(".*");
            regexpBuffer.append(propertyString);
            regexpBuffer.append("\\s+([^\\t\\n\\r\\f]+)");
        }

        private String getMatcherGroup(Matcher matcher, int i) {
            if (matcher.groupCount() < i) {
                return null;
            }
            String group = matcher.group(i);
            return group != null ? group.trim() : "";
        }
    }

    private class ExistingTagsTableModel
    extends GenericBaseTableModel {
        private ExistingTagsTableModel() {
        }

        public int getColumnAlignment(int column) {
            return 2;
        }

        public Comparator getColumnSortComparator(int column) {
            return Collator.getInstance();
        }
    }

    private class ExistingTagsTable
    extends GenericTable {
        private ExistingTagsTable() {
            this.setSelectionMode(0);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void installModel(TableModel model) {
            this.setModel(model);
            this.setSorted(true);
            this.getTableHeader().setReorderingAllowed(false);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.getColumnModel().getColumn(i).setHeaderRenderer(this.getTableHeader().getDefaultRenderer());
            }
            this.setAutoResizeMode(0);
            this.autoSizeColumnsToFit();
            ((DefaultTableModel)this.getModel()).fireTableDataChanged();
            this.setSortColumn(0, true);
            if (model.getRowCount() > 0) {
                this.setRowSelectionInterval(0, 0);
            }
        }
    }
}

