/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.util.regex.Pattern;
import oracle.jdevimpl.vcs.cvs.CVSGlobalOptionId;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionArgument;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionCommandLine;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.ocvs.OCVSCommandSpec;
import oracle.ocvs.OCVSMain;

public class CVSInternalClientSupport {
    private CVSInternalClientSupport() {
    }

    public static final boolean isSupportedCommand(String command) {
        return CVSInternalClientSupport.findRegisteredCommandSpec(command) != null;
    }

    public static final boolean isSupportedGlobalOption(CVSGlobalOptionId id) {
        if (id == CVSGlobalOptionId.L_NO_HISTORY_LOGGING) {
            return CVSInternalClientSupport.isSupportedGlobalOption('l');
        }
        if (id == CVSGlobalOptionId.Q_BE_QUIET) {
            return CVSInternalClientSupport.isSupportedGlobalOption('q');
        }
        if (id == CVSGlobalOptionId.R_MAKE_NEW_FILES_READ_ONLY) {
            return CVSInternalClientSupport.isSupportedGlobalOption('r');
        }
        if (id == CVSGlobalOptionId.X_ENCRYPT) {
            return CVSInternalClientSupport.isSupportedGlobalOption('x');
        }
        if (id == CVSGlobalOptionId.Z_SET_GZIP_LEVEL) {
            return CVSInternalClientSupport.isSupportedGlobalOption('z');
        }
        return false;
    }

    public static final boolean isSupportedGlobalOption(char option) {
        return "Hz.d.QqwnEC.".indexOf(option) >= 0;
    }

    public static final boolean isSupportedCommandOption(String command, CVSOptionId id) {
        return CVSInternalClientSupport._isSupportedCommandOption(command, CVSOptionCommandLine.lookupOptionChar(id));
    }

    public static final boolean isSupportedCommandOption(String command, CVSOptionArgument argument) {
        return CVSInternalClientSupport._isSupportedCommandOption(command, CVSOptionCommandLine.lookupOptionChar(argument));
    }

    public static final boolean isSupportedCommandOption(String command, char option) {
        OCVSCommandSpec commandSpec = CVSInternalClientSupport.findRegisteredCommandSpec(command);
        if (commandSpec == null) {
            return false;
        }
        if (commandSpec.getOptionSpec() == null) {
            return false;
        }
        return commandSpec.getOptionSpec().indexOf(option) >= 0;
    }

    private static final boolean _isSupportedCommandOption(String command, Character optionChar) {
        return optionChar != null && CVSInternalClientSupport.isSupportedCommandOption(command, optionChar.charValue());
    }

    private static final OCVSCommandSpec findRegisteredCommandSpec(String command) {
        OCVSCommandSpec[] commandSpecs = OCVSMain.getRegisteredCommandSpecs();
        for (int i = 0; i < commandSpecs.length; ++i) {
            if (!Pattern.matches(commandSpecs[i].getTokenSpec(), command)) continue;
            return commandSpecs[i];
        }
        return null;
    }
}

