/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.io.IOException;
import java.net.URL;
import oracle.ide.model.Recognizer;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSRootCache;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;

public class CVSEncodingUtil {
    private CVSEncodingUtil() {
    }

    public static final String getEncodingForRegularFile(URL url) throws IOException {
        Class c = Recognizer.recognizeURL((URL)url);
        if (c == null || !TextNode.class.isAssignableFrom(c)) {
            return null;
        }
        return (url = URLFileSystem.getParent((URL)url)) != null ? CVSEncodingUtil.getEncodingForDirectory(url) : null;
    }

    public static final String getEncodingForDirectory(URL url) throws IOException {
        CVSRootString rootString = CVSRootCache.getInstance().getRoot(url);
        return rootString != null ? CVSEncodingUtil.getEncodingForRoot(rootString.toString()) : null;
    }

    public static final String getEncodingForRoot(String root) {
        if (!CVSClient.getInstance().isUsingInternalClient()) {
            return null;
        }
        CVSConnectionListAPI connectionList = CVSConnectionNodes.getConnectionListAPI();
        String connectionName = connectionList.getRootConnection(root);
        CVSConnectionData connection = connectionName != null ? connectionList.getConnectionAPI(connectionName) : null;
        return connection != null ? connection.getEncoding() : null;
    }
}

