/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Recognizer;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.util.Log;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSEncodingUtil;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileURL;
import oracle.jdevimpl.vcs.util.browser.Browsable;
import oracle.jdevimpl.vcs.util.browser.BrowsableCache;
import oracle.jdevimpl.vcs.util.browser.BrowsableViewer;

public class CVSEncodingNodeListener
extends NodeListener {
    private static final Log LOG = new Log("vcs-cvs");

    public void nodeWillOpen(NodeEvent ne) {
        if (!(ne.getNode() instanceof TextNode)) {
            return;
        }
        URL url = ne.getNodeURL();
        if (url == null) {
            return;
        }
        String charsetName = this.getEncodingForURL(url);
        if (charsetName == null) {
            return;
        }
        TextNode textNode = (TextNode)ne.getNode();
        LOG.trace("CVS: Setting encoding " + charsetName + " for " + ne.getNodeURL());
        textNode.setLoadEncoding(charsetName);
        textNode.setSaveEncoding(charsetName);
    }

    private String getEncodingForURL(URL url) {
        if (!CVSClient.getInstance().getURLFilter().accept(url)) {
            return null;
        }
        Browsable browsable = BrowsableCache.find((URL)url);
        if (browsable != null && browsable instanceof CVSConnectionFileNode) {
            return this.getEncodingForConnectionFileNode(url, (CVSConnectionFileNode)browsable);
        }
        return this.getEncodingForFileURL(url);
    }

    private String getEncodingForFileURL(URL url) {
        if (!URLFileSystem.isDirectoryPath((URL)url)) {
            url = URLFileSystem.getParent((URL)url);
        }
        if (url == null) {
            return null;
        }
        try {
            return CVSEncodingUtil.getEncodingForDirectory(url);
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
            return null;
        }
    }

    private String getEncodingForConnectionFileNode(URL url, CVSConnectionFileNode connectionFileNode) {
        if (BrowsableViewer.isDefaultTextViewerURL((URL)url)) {
            return null;
        }
        Class c = Recognizer.recognizeURL((URL)url);
        if (c == null || !TextNode.class.isAssignableFrom(c)) {
            return null;
        }
        String root = null;
        try {
            CVSConnectionFileURL connectionFileUrl = new CVSConnectionFileURL(connectionFileNode.getURL());
            root = connectionFileUrl.getRoot();
        }
        catch (ParseException pe) {
            Assert.printStackTrace((Throwable)pe);
        }
        return root != null ? CVSEncodingUtil.getEncodingForRoot(root) : null;
    }
}

