/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.IdeAction;
import oracle.ide.navigator.ProjectNavigatorWindow;
import oracle.javatools.util.Executors;
import oracle.jdeveloper.vcs.spi.VCSController;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;

class CVSController
extends VCSController {
    CVSController() {
        super(CVSClient.class.getPackage());
    }

    public boolean update(IdeAction action, Context context) {
        if (action.getCommandId() == 51) {
            if (context.getView() instanceof ProjectNavigatorWindow) {
                action.setEnabled(true);
                return true;
            }
            return false;
        }
        return super.update(action, context);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (action.getCommandId() == 51) {
            if (context.getView() instanceof ProjectNavigatorWindow) {
                java.util.concurrent.Executors.newSingleThreadExecutor(Executors.namedThreadFactory((String)"CVSController")).execute(new Runnable(){

                    @Override
                    public final void run() {
                        CVSClient.getInstance();
                        CVSClient.getStatusCache().clear();
                    }
                });
                return false;
            }
            return false;
        }
        return super.handleEvent(action, context);
    }

    protected void updateImpl(IdeAction action, Context context) {
        if (CVSClient.getInstance() != null && !CVSClient.getInstance().isClientAvailable()) {
            action.setEnabled(false);
            return;
        }
        super.updateImpl(action, context);
    }

    protected void handleEventImpl(IdeAction action, Context context) {
        CVSClient client = CVSClient.getInstance();
        if (client == null) {
            return;
        }
        client.verifyClientState();
        if (!client.isClientAvailable() && action.getValue("serverOnly") == null) {
            return;
        }
        super.handleEventImpl(action, context);
    }

    protected int invokeCommand(IdeAction action, Command command) throws Exception {
        if (command instanceof CVSAbstractCommand) {
            ((CVSAbstractCommand)command).setAction(action);
        }
        return super.invokeCommand(action, command);
    }

    private IdeAction updateGeneratePatchAction(Context context) {
        IdeAction generatePatchAction = IdeAction.find((int)CVSCommandConstants.OPERATION_GENERATE_PATCH_CMD_ID);
        generatePatchAction.updateAction(context);
        return generatePatchAction;
    }
}

