/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.hierarchical;

import ilog.views.graphlayout.hierarchical.CalcCrossings;
import ilog.views.graphlayout.hierarchical.HGraph;
import ilog.views.graphlayout.hierarchical.HLevel;
import ilog.views.graphlayout.hierarchical.HLevelIterator;
import ilog.views.graphlayout.hierarchical.HLevelSweepAlgorithm;
import ilog.views.graphlayout.hierarchical.HNode;
import ilog.views.graphlayout.hierarchical.HNodeIterator;
import ilog.views.graphlayout.hierarchical.HNodeSort;
import ilog.views.graphlayout.hierarchical.HSegment;
import ilog.views.graphlayout.hierarchical.HSegmentIterator;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalLayout;
import ilog.views.graphlayout.hierarchical.relpositioning.HRPGraph;
import ilog.views.graphlayout.hierarchical.relpositioning.HRPSolving;
import ilog.views.util.collections.IlvUnsynchronizedStack;

class CrossingReductionAlgorithm
extends HLevelSweepAlgorithm {
    protected HNodeSort _nodeSortAlg;
    private HRPSolving a;
    protected boolean _usePortBaryCenter = false;
    private boolean b;
    private CalcCrossings c = new CalcCrossings();
    protected int _numberOfSweeps;
    protected boolean _checkBestPositions;
    private int d;
    private int e;

    CrossingReductionAlgorithm(HGraph hGraph) {
        super.init(hGraph);
        IlvHierarchicalLayout ilvHierarchicalLayout = hGraph.v();
        this._nodeSortAlg = new HNodeSort();
        this.a = new HRPSolving(null, ilvHierarchicalLayout, hGraph.bq());
        this._numberOfSweeps = ilvHierarchicalLayout.getNumberOfLinkCrossingSweeps();
        this._checkBestPositions = ilvHierarchicalLayout.isBacktrackCrossingReductionEnabled();
        this.b = ilvHierarchicalLayout.isMedianCrossingValueEnabled();
    }

    void a() {
        super.a();
        this._nodeSortAlg = null;
    }

    public void run() {
        HGraph hGraph = this.getGraph();
        int n = (this._numberOfSweeps + 3) * (hGraph.z() - 1) + 2;
        if (hGraph.bh() || hGraph.bi()) {
            n += 2 * (hGraph.z() - 1);
        }
        this.c().startStep(this.d().ac[5], n, false);
        this.b();
        this.updateInfoInLevels();
        this.d = Integer.MAX_VALUE;
        boolean bl = false;
        if (hGraph.bh() || hGraph.bi()) {
            this._usePortBaryCenter = true;
            this.sweepForward();
            bl = true;
            if (!this.g()) {
                this.sweepBackward();
            }
        }
        this._usePortBaryCenter = false;
        if (hGraph.z() == 1) {
            this.treatForwardLevel(null, hGraph.am());
        } else {
            for (int i = 0; !(i >= this._numberOfSweeps || bl && this.g()); ++i) {
                if (i % 2 == 0) {
                    this.sweepForward();
                } else {
                    this.sweepBackward();
                }
                bl = true;
            }
        }
        this.i();
        this.calcCrossings(true);
        this.storeLevelPositionsInNodes();
    }

    private void b() {
        this.e = 1;
        HGraph hGraph = this.getGraph();
        HNodeIterator hNodeIterator = hGraph.aa();
        while (hNodeIterator.hasNext()) {
            hNodeIterator.next().a(-1.0f);
        }
        hNodeIterator = hGraph.aa();
        while (hNodeIterator.hasNext()) {
            HNode hNode = hNodeIterator.next();
            if (!(hNode.ao() < 0.0f)) continue;
            this.a(hNode);
        }
        HLevelIterator hLevelIterator = this.getGraph().ah();
        while (hLevelIterator.hasNext()) {
            HLevel hLevel = hLevelIterator.next();
            if (hLevel.d() != null) {
                this._nodeSortAlg.sort(hLevel.d());
            }
            this.e();
        }
    }

    private void a(HNode hNode) {
        IlvUnsynchronizedStack ilvUnsynchronizedStack = new IlvUnsynchronizedStack();
        hNode.a((float)this.e++);
        ilvUnsynchronizedStack.push((Object)hNode);
        while (!ilvUnsynchronizedStack.isEmpty()) {
            HNode hNode2;
            HSegment hSegment;
            hNode = (HNode)ilvUnsynchronizedStack.pop();
            HSegmentIterator hSegmentIterator = hNode.e();
            while (hSegmentIterator.hasNext()) {
                hSegment = hSegmentIterator.next();
                hNode2 = hSegment.b();
                if (!(hNode2.ao() < 0.0f)) continue;
                hNode2.a((float)this.e++);
                ilvUnsynchronizedStack.push((Object)hNode2);
            }
            hSegmentIterator = hNode.f();
            while (hSegmentIterator.hasNext()) {
                hSegment = hSegmentIterator.next();
                hNode2 = hSegment.a();
                if (!(hNode2.ao() < 0.0f)) continue;
                hNode2.a((float)this.e++);
                ilvUnsynchronizedStack.push((Object)hNode2);
            }
        }
    }

    protected final void sweepForward() {
        super.sweepForward();
        this.f();
    }

    protected final void sweepBackward() {
        super.sweepBackward();
        this.f();
    }

    private final void a(HLevel hLevel) {
        int n = hLevel.h();
        if (n > 0 && hLevel.p()) {
            HNodeIterator hNodeIterator = hLevel.f();
            int n2 = 0;
            int n3 = hLevel.h() + 1;
            while (hNodeIterator.hasNext()) {
                HNode hNode = hNodeIterator.next();
                int n4 = hNode.am();
                for (int i = n3; n4 != n2 && n4 >= 0 && n4 < n && i > 0; --i) {
                    HNode hNode2 = hLevel.d()[n4];
                    hLevel.d()[n4] = hNode;
                    hLevel.d()[n2] = hNode2;
                    hNode = hNode2;
                    n4 = hNode.am();
                }
                ++n2;
            }
        }
    }

    private final void b(HLevel hLevel) {
        int n = hLevel.h();
        HNodeIterator hNodeIterator = hLevel.f();
        if (this._usePortBaryCenter) {
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().g(false);
            }
        } else {
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().a(false, n);
            }
        }
        if (this.b) {
            double d = n > 0 ? 1.0E-5 / (double)n : 1.0E-5;
            hNodeIterator = hLevel.f();
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().a(d);
            }
        }
        if (hLevel != this.getGraph().am()) {
            HNode hNode;
            hNodeIterator = hLevel.f();
            float f = 0.0f;
            while (hNodeIterator.hasNext()) {
                hNode = hNodeIterator.next();
                if (hNode.i() == 0) {
                    hNode.a(f);
                    continue;
                }
                f = hNode.ao();
            }
            hNodeIterator = hLevel.g();
            while (hNodeIterator.hasNext()) {
                hNode = hNodeIterator.next();
                if (hNode.i() == 0) {
                    hNode.a((f + hNode.ao()) / 2.0f);
                    continue;
                }
                f = hNode.ao();
            }
        }
    }

    private final void c(HLevel hLevel) {
        int n = hLevel.h();
        HNodeIterator hNodeIterator = hLevel.f();
        if (this._usePortBaryCenter) {
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().h(false);
            }
        } else {
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().b(false, n);
            }
        }
        if (this.b) {
            double d = n > 0 ? 1.0E-5 / (double)n : 1.0E-5;
            hNodeIterator = hLevel.f();
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().b(d);
            }
        }
        if (hLevel != this.getGraph().an()) {
            HNode hNode;
            hNodeIterator = hLevel.f();
            float f = 0.0f;
            while (hNodeIterator.hasNext()) {
                hNode = hNodeIterator.next();
                if (hNode.h() == 0) {
                    hNode.a(f);
                    continue;
                }
                f = hNode.ao();
            }
            hNodeIterator = hLevel.g();
            while (hNodeIterator.hasNext()) {
                hNode = hNodeIterator.next();
                if (hNode.h() == 0) {
                    hNode.a((f + hNode.ao()) / 2.0f);
                    continue;
                }
                f = hNode.ao();
            }
        }
    }

    private final void d(HLevel hLevel) {
        HNode hNode;
        HGraph hGraph = this.getGraph();
        HRPGraph hRPGraph = hLevel.q();
        if (hRPGraph == null) {
            return;
        }
        this.a.init(hRPGraph);
        HNodeIterator hNodeIterator = hLevel.f();
        while (hNodeIterator.hasNext()) {
            hNode = hNodeIterator.next();
            hGraph.c(hNode).setBarycenter(hNode.ao(), 1.0f);
        }
        this.a.run();
        hNodeIterator = hLevel.f();
        while (hNodeIterator.hasNext()) {
            hNode = hNodeIterator.next();
            hNode.a((float)hGraph.c(hNode).getPositionNumber());
        }
    }

    protected void initForwardFirstLevel(HLevel hLevel) {
        if (hLevel.q() != null) {
            this.e(hLevel);
            this.d(hLevel);
            if (hLevel.d() != null) {
                this._nodeSortAlg.sort(hLevel.d());
            }
        }
        this.a(hLevel);
        hLevel.b(1, false);
    }

    protected void initBackwardFirstLevel(HLevel hLevel) {
        if (hLevel.q() != null) {
            this.e(hLevel);
            this.d(hLevel);
            if (hLevel.d() != null) {
                this._nodeSortAlg.sort(hLevel.d());
            }
        }
        this.a(hLevel);
        hLevel.b(1, false);
    }

    private void e(HLevel hLevel) {
        HNodeIterator hNodeIterator = hLevel.f();
        int n = 1;
        while (hNodeIterator.hasNext()) {
            hNodeIterator.next().a((float)n++);
        }
    }

    protected void treatForwardLevel(HLevel hLevel, HLevel hLevel2) {
        this.b(hLevel2);
        this.d(hLevel2);
        if (hLevel2.d() != null) {
            this._nodeSortAlg.sort(hLevel2.d());
        }
        this.a(hLevel2);
        hLevel2.b(1, false);
    }

    protected void treatBackwardLevel(HLevel hLevel, HLevel hLevel2) {
        this.c(hLevel2);
        this.d(hLevel2);
        if (hLevel2.d() != null) {
            this._nodeSortAlg.sort(hLevel2.d());
        }
        this.a(hLevel2);
        hLevel2.b(1, false);
    }

    private final void f() {
        if (!this._checkBestPositions) {
            return;
        }
        int n = this.calcCrossings(false);
        if (n < this.d) {
            this.h();
            this.d = n;
        }
    }

    private final boolean g() {
        return this._checkBestPositions && this.d == 0;
    }

    private final void h() {
        HNodeIterator hNodeIterator = this.getGraph().aa();
        while (hNodeIterator.hasNext()) {
            hNodeIterator.next().at();
        }
    }

    private final void i() {
        if (!this._checkBestPositions) {
            return;
        }
        HNodeIterator hNodeIterator = this.getGraph().aa();
        while (hNodeIterator.hasNext()) {
            hNodeIterator.next().au();
        }
        HLevelIterator hLevelIterator = this.getGraph().ah();
        while (hLevelIterator.hasNext()) {
            HLevel hLevel = hLevelIterator.next();
            if (hLevel.d() != null) {
                this._nodeSortAlg.sort(hLevel.d());
            }
            hLevel.b(1, false);
        }
    }

    protected final void storeLevelPositionsInNodes() {
        HLevelIterator hLevelIterator = this.getGraph().ah();
        while (hLevelIterator.hasNext()) {
            hLevelIterator.next().b(0, false);
            this.c().addPoints(1);
            this.e();
        }
    }

    protected final void updateInfoInLevels() {
        HLevelIterator hLevelIterator = this.getGraph().ah();
        while (hLevelIterator.hasNext()) {
            hLevelIterator.next().c();
            this.c().addPoints(1);
            this.e();
        }
    }

    protected int calcCrossings(boolean bl) {
        HLevelIterator hLevelIterator = this.getGraph().ah();
        HLevel hLevel = null;
        int n = 0;
        while (hLevelIterator.hasNext()) {
            HLevel hLevel2 = hLevelIterator.next();
            if (hLevel != null) {
                int n2 = this.c.getNumberOfCrossings(hLevel, hLevel2);
                n += n2;
                if (bl) {
                    hLevel.h(n2);
                }
            }
            hLevel = hLevel2;
        }
        return n;
    }
}

