/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.hierarchical;

import ilog.views.graphlayout.hierarchical.AnchorPointOptimization;
import ilog.views.graphlayout.hierarchical.HGraph;
import ilog.views.graphlayout.hierarchical.HGraphAlgorithm;
import ilog.views.graphlayout.hierarchical.HLevel;
import ilog.views.graphlayout.hierarchical.HLink;
import ilog.views.graphlayout.hierarchical.HNode;
import ilog.views.graphlayout.hierarchical.HNodeIterator;
import ilog.views.graphlayout.hierarchical.HSegment;
import ilog.views.graphlayout.hierarchical.HSegmentIterator;
import ilog.views.graphlayout.internalutil.LayoutUtil;

final class CalcConnectors
extends HGraphAlgorithm {
    private AnchorPointOptimization a;
    private int b;
    private int c;
    private int d;
    private float e;
    private HNode f;
    private HSegment g;

    CalcConnectors(HGraph hGraph) {
        super.init(hGraph);
        this.a = new AnchorPointOptimization(hGraph);
        this.b = hGraph.a3();
        this.c = hGraph.a4();
        this.d = hGraph.a6();
    }

    void a() {
        super.a();
        if (this.a != null) {
            this.a.a();
        }
        this.a = null;
    }

    public void run() {
        HGraph hGraph = this.getGraph();
        float f = this.d().ac[12];
        int n = 2 * hGraph.getNumberOfNodes();
        this.c().startStep(f, n, false);
        switch (this.d) {
            case 99: {
                this.calcCenteredConnectors();
                break;
            }
            case 100: {
                this.calcClippedConnectors();
                break;
            }
            case 101: {
                this.calcEvenSpacedConnectors();
                break;
            }
            default: {
                throw new RuntimeException("CalcConnectors: Illegal connector style");
            }
        }
    }

    public void fixEastWestPorts() {
        HGraph hGraph = this.getGraph();
        int n = hGraph.getNumberOfNodes();
        float f = this.d().ac[19];
        this.c().startStep(f, 2 * n, false);
        HNodeIterator hNodeIterator = hGraph.aa();
        while (hNodeIterator.hasNext()) {
            HNode hNode = hNodeIterator.next();
            HNode hNode2 = hNode.aw();
            if (hNode2 != null) {
                this.a(hNode, hNode2);
            }
            if ((hNode2 = hNode.ay()) != null) {
                this.a(hNode, hNode2);
            }
            this.c().addPoints(1);
            this.e();
        }
    }

    private void a(HNode hNode, HNode hNode2) {
        switch (this.d) {
            case 99: {
                this.b(hNode, hNode2);
                break;
            }
            case 100: {
                this.c(hNode, hNode2);
                break;
            }
            case 101: {
                this.c(hNode, hNode2);
                break;
            }
            default: {
                throw new RuntimeException("CalcConnectors: Illegal connector style");
            }
        }
    }

    public final void calcCenteredConnectors() {
        this.calcNorthSouthPortConnectors();
        this.calcEastWestAuxPortNodeConnectors();
        HNodeIterator hNodeIterator = this.getGraph().aa();
        while (hNodeIterator.hasNext()) {
            this.a(hNodeIterator.next());
            this.c().addPoints(1);
            this.e();
        }
    }

    private final void a(HNode hNode) {
        HSegmentIterator hSegmentIterator = hNode.c(true, true, false, false);
        while (hSegmentIterator.hasNext()) {
            HLink hLink = hSegmentIterator.next().e();
            if (hLink.ab() == hNode) {
                this.calcCenteredConnectorsFromSide(hLink);
            }
            if (hLink.ac() != hNode) continue;
            this.calcCenteredConnectorsToSide(hLink);
        }
    }

    public final void calcCenteredConnectorsFromSide(HLink hLink) {
        if (!hLink.ab().az()) {
            if (hLink.aq()) {
                hLink.au();
            } else if (!hLink.af()) {
                this.a(hLink, hLink.al());
            }
        }
    }

    public final void calcCenteredConnectorsToSide(HLink hLink) {
        if (!hLink.ac().az()) {
            if (hLink.ar()) {
                hLink.av();
            } else if (!hLink.ag()) {
                this.b(hLink, hLink.am());
            }
        }
    }

    private final void a(HLink hLink, int n) {
        HNode hNode;
        float f;
        float f2;
        HSegment hSegment = hLink.t();
        HNode hNode2 = hSegment.a();
        HNode hNode3 = hSegment.b();
        int n2 = this.a(hSegment, n);
        int n3 = 1 - n2;
        if (hSegment.aa()) {
            f2 = hNode3.a(n2);
            f = hNode2.a(n2);
            hNode = hNode3;
        } else {
            f2 = hNode2.a(n2);
            f = hNode3.a(n2);
            hNode = hNode2;
        }
        if (n == 1 || n == 0) {
            hLink.a(n2, f2);
        } else if (n == 3 || n == 2) {
            hLink.a(n2, f2 + hNode.c(n2));
        } else if (f2 > f) {
            hLink.a(n2, f2);
        } else {
            hLink.a(n2, f2 + hNode.c(n2));
        }
        hLink.a(n3, hNode.b(n3));
    }

    private final void b(HLink hLink, int n) {
        HNode hNode;
        float f;
        float f2;
        HSegment hSegment = hLink.u();
        HNode hNode2 = hSegment.b();
        HNode hNode3 = hSegment.a();
        int n2 = this.a(hSegment, n);
        int n3 = 1 - n2;
        if (hSegment.aa()) {
            f2 = hNode3.a(n2);
            f = hNode2.a(n2);
            hNode = hNode3;
        } else {
            f2 = hNode2.a(n2);
            f = hNode3.a(n2);
            hNode = hNode2;
        }
        if (n == 1 || n == 0) {
            hLink.b(n2, f2);
        } else if (n == 3 || n == 2) {
            hLink.b(n2, f2 + hNode.c(n2));
        } else if (f2 > f) {
            hLink.b(n2, f2);
        } else {
            hLink.b(n2, f2 + hNode.c(n2));
        }
        hLink.b(n3, hNode.b(n3));
    }

    private final void b(HNode hNode, HNode hNode2) {
        if (hNode.u()) {
            return;
        }
        hNode2.a5();
        boolean bl = hNode.an() < hNode2.an();
        float f = hNode.a(this.b);
        float f2 = hNode.b(this.c);
        float f3 = hNode.a(this.c);
        float f4 = hNode.c(this.c);
        int n = hNode2.u(2);
        if (hNode2.u(0) > n) {
            n = hNode2.u(0);
        }
        if (bl) {
            if (hNode.u(1) > n) {
                n = hNode.u(1);
            }
        } else if (hNode.u(3) > n) {
            n = hNode.u(3);
        }
        float[] fArray = null;
        if (n > 0) {
            fArray = new float[n];
            this.a(hNode2, fArray, f3, f4, true, true);
        }
        if (bl) {
            f += hNode.c(this.b);
        }
        this.d(hNode2);
        HSegmentIterator hSegmentIterator = hNode2.b(true, true, false, false);
        while (hSegmentIterator.hasNext()) {
            this.b(hSegmentIterator.next(), f, f2, fArray);
        }
        hSegmentIterator = hNode2.a(true, true, false, false);
        while (hSegmentIterator.hasNext()) {
            this.a(hSegmentIterator.next(), f, f2, fArray);
        }
    }

    private final int a(HSegment hSegment, int n) {
        if (n == 1 || n == 3 || n == -3) {
            return this.b;
        }
        if (n == 0 || n == 2 || n == -2) {
            return this.c;
        }
        if (hSegment.q() == 0) {
            return this.b;
        }
        return this.c;
    }

    public final void calcClippedConnectors() {
        this.calcNorthSouthPortConnectors();
        this.calcEastWestAuxPortNodeConnectors();
        HNodeIterator hNodeIterator = this.getGraph().aa();
        while (hNodeIterator.hasNext()) {
            this.calcClippedConnectors(hNodeIterator.next());
            this.c().addPoints(1);
            this.e();
        }
    }

    public final void calcClippedConnectors(HNode hNode) {
        HLink hLink;
        HSegment hSegment;
        if (hNode.u()) {
            return;
        }
        if (hNode.az()) {
            return;
        }
        HSegmentIterator hSegmentIterator = hNode.a(true, true, false, false);
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            hLink = hSegment.e();
            if (hLink.ab() == hNode) {
                this.calcFromClippedConnector(hLink);
            }
            if (hLink.ac() != hNode) continue;
            this.calcToClippedConnector(hLink);
        }
        hSegmentIterator = hNode.b(true, true, false, false);
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            hLink = hSegment.e();
            if (hLink.ab() == hNode) {
                this.calcFromClippedConnector(hLink);
            }
            if (hLink.ac() != hNode) continue;
            this.calcToClippedConnector(hLink);
        }
    }

    public final void calcClippedConnectors(HLink hLink) {
        this.calcFromClippedConnector(hLink);
        this.calcToClippedConnector(hLink);
    }

    public final void calcClippedConnectorAtNode(HLink hLink, HNode hNode) {
        if (hLink.ab() == hNode) {
            this.calcFromClippedConnector(hLink);
        }
        if (hLink.ac() == hNode) {
            this.calcToClippedConnector(hLink);
        }
    }

    public final void calcFromClippedConnector(HLink hLink) {
        if (!hLink.ab().az()) {
            if (hLink.aq()) {
                hLink.au();
            } else if (!hLink.af()) {
                this.a(hLink);
            }
        }
    }

    public final void calcToClippedConnector(HLink hLink) {
        if (!hLink.ac().az()) {
            if (hLink.ar()) {
                hLink.av();
            } else if (!hLink.ag()) {
                this.b(hLink);
            }
        }
    }

    private final void a(HLink hLink) {
        float[] fArray;
        int n;
        HNode hNode;
        HNode hNode2;
        HGraph hGraph = this.getGraph();
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[4];
        HSegment hSegment = hLink.t();
        if (hSegment.aa()) {
            hNode2 = hSegment.b();
            hNode = hSegment.a();
        } else {
            hNode2 = hSegment.a();
            hNode = hSegment.b();
        }
        if (hNode2.ah()) {
            return;
        }
        while (hNode.ah()) {
            hSegment = hNode.d(hSegment);
            hNode = hSegment.a(hNode);
        }
        if (hSegment.a() == hNode) {
            n = hSegment.v();
            fArray = hSegment.f();
        } else {
            n = hSegment.w();
            fArray = hSegment.g();
        }
        if (n == -1) {
            dArray2[0] = hNode.b(0);
            dArray2[1] = hNode.b(1);
        } else {
            dArray2[0] = fArray[0];
            dArray2[1] = fArray[1];
        }
        if (hNode.getOwnerGraph() != hGraph) {
            dArray2[0] = hGraph.a(hNode, (float)dArray2[0], 0);
            dArray2[1] = hGraph.a(hNode, (float)dArray2[1], 1);
        }
        dArray[0] = hNode2.b(0);
        dArray[1] = hNode2.b(1);
        dArray3[0] = hNode2.x();
        dArray3[1] = hNode2.x() + hNode2.z();
        dArray3[2] = hNode2.y();
        dArray3[3] = hNode2.y() + hNode2.aa();
        LayoutUtil.Clip(dArray, dArray2, dArray3);
        hLink.a(0, (float)dArray[0]);
        hLink.a(1, (float)dArray[1]);
    }

    private final void b(HLink hLink) {
        float[] fArray;
        int n;
        HNode hNode;
        HNode hNode2;
        HGraph hGraph = this.getGraph();
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[4];
        HSegment hSegment = hLink.u();
        if (hSegment.aa()) {
            hNode2 = hSegment.a();
            hNode = hSegment.b();
        } else {
            hNode2 = hSegment.b();
            hNode = hSegment.a();
        }
        if (hNode2.ah()) {
            return;
        }
        while (hNode.ah()) {
            hSegment = hNode.d(hSegment);
            hNode = hSegment.a(hNode);
        }
        if (hSegment.a() == hNode) {
            n = hSegment.v();
            fArray = hSegment.f();
        } else {
            n = hSegment.w();
            fArray = hSegment.g();
        }
        if (n == -1) {
            dArray2[0] = hNode.b(0);
            dArray2[1] = hNode.b(1);
        } else {
            dArray2[0] = fArray[0];
            dArray2[1] = fArray[1];
        }
        if (hNode.getOwnerGraph() != hGraph) {
            dArray2[0] = hGraph.a(hNode, (float)dArray2[0], 0);
            dArray2[1] = hGraph.a(hNode, (float)dArray2[1], 1);
        }
        dArray[0] = hNode2.b(0);
        dArray[1] = hNode2.b(1);
        dArray3[0] = hNode2.x();
        dArray3[1] = hNode2.x() + hNode2.z();
        dArray3[2] = hNode2.y();
        dArray3[3] = hNode2.y() + hNode2.aa();
        LayoutUtil.Clip(dArray, dArray2, dArray3);
        hLink.b(0, (float)dArray[0]);
        hLink.b(1, (float)dArray[1]);
    }

    public final void calcEvenSpacedConnectors() {
        this.calcNorthSouthPortConnectors();
        HNodeIterator hNodeIterator = this.getGraph().aa();
        while (hNodeIterator.hasNext()) {
            HNode hNode = hNodeIterator.next();
            if (hNode.az()) {
                this.c(hNode);
            } else {
                this.a(hNode, false);
            }
            this.c().addPoints(1);
            this.e();
        }
    }

    public final void calcEastWestAuxPortNodeConnectors() {
        if (!this.getGraph().bf()) {
            return;
        }
        HNodeIterator hNodeIterator = this.getGraph().aa();
        while (hNodeIterator.hasNext()) {
            HNode hNode = hNodeIterator.next();
            if (!hNode.az()) continue;
            this.c(hNode);
        }
    }

    private final void a(HNode hNode, boolean bl) {
        float[] fArray;
        float f;
        HSegment hSegment;
        if (hNode.u()) {
            return;
        }
        boolean bl2 = !hNode.az();
        float f2 = hNode.c(this.b);
        float f3 = hNode.a(this.b);
        float f4 = this.a(hNode, f2, true, false, bl);
        HSegmentIterator hSegmentIterator = hNode.n();
        float f5 = f3 + f4;
        float f6 = hNode.a(this.c) + hNode.c(this.c);
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            if (hSegment.h() && bl2) {
                hSegment.j();
                continue;
            }
            if (hSegment.v() != -1 && !bl) continue;
            f = this.e * hSegment.e().w();
            fArray = hSegment.f();
            fArray[this.b] = f5 + 0.5f * f;
            fArray[this.c] = f6;
            f5 += f4 + f;
        }
        f4 = this.a(hNode, f2, false, true, bl);
        hSegmentIterator = hNode.o();
        f5 = f3 + f4;
        f6 = hNode.a(this.c);
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            if (hSegment.i() && bl2) {
                hSegment.k();
                continue;
            }
            if (hSegment.w() != -1 && !bl) continue;
            f = this.e * hSegment.e().w();
            fArray = hSegment.g();
            fArray[this.b] = f5 + 0.5f * f;
            fArray[this.c] = f6;
            f5 += f4 + f;
        }
    }

    private final void c(HNode hNode, HNode hNode2) {
        float f;
        HSegment hSegment;
        if (hNode.u()) {
            return;
        }
        hNode2.a5();
        boolean bl = hNode.an() < hNode2.an();
        float f2 = hNode.a(this.c);
        float f3 = hNode.c(this.c);
        float f4 = this.a(hNode2, f3, true, true, false);
        int n = hNode2.u(2);
        if (hNode2.u(0) > n) {
            n = hNode2.u(0);
        }
        if (bl) {
            if (hNode.u(1) > n) {
                n = hNode.u(1);
            }
        } else if (hNode.u(3) > n) {
            n = hNode.u(3);
        }
        float[] fArray = null;
        if (n > 0) {
            fArray = new float[n];
            this.a(hNode2, fArray, f2, f3, true, true);
        }
        this.d(hNode2);
        HSegmentIterator hSegmentIterator = bl ? hNode2.o() : hNode2.r();
        float f5 = f2 + f4;
        float f6 = hNode.a(this.b);
        if (bl) {
            f6 += hNode.c(this.b);
        }
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            f = this.e * hSegment.e().w();
            if (!this.b(hSegment, f6, f5 + 0.5f * f, fArray)) continue;
            f5 += f4 + f;
        }
        HSegmentIterator hSegmentIterator2 = hSegmentIterator = bl ? hNode2.q() : hNode2.n();
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            f = this.e * hSegment.e().w();
            if (!this.a(hSegment, f6, f5 + 0.5f * f, fArray)) continue;
            f5 += f4 + f;
        }
    }

    float a(HNode hNode, float f, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        HSegmentIterator hSegmentIterator = bl ? (bl2 ? hNode.p() : hNode.n()) : hNode.o();
        int n = 0;
        float f2 = 0.0f;
        boolean bl5 = bl4 = !hNode.az();
        while (hSegmentIterator.hasNext()) {
            boolean bl6;
            int n2;
            HSegment hSegment = hSegmentIterator.next();
            if (hSegment.a() == hNode) {
                n2 = hSegment.v();
                bl6 = bl4 && hSegment.h();
            } else {
                n2 = hSegment.w();
                boolean bl7 = bl6 = bl4 && hSegment.i();
            }
            if (bl6 || n2 != -1 && !bl3) continue;
            ++n;
            f2 += hSegment.e().w();
        }
        this.e = 1.0f;
        float f3 = (f - f2) / (float)(n + 1);
        if ((double)f3 < 0.0) {
            f3 = 0.0f;
            this.e = f / f2;
        }
        return f3;
    }

    private boolean a(HSegment hSegment, float f, float f2, float[] fArray) {
        float f3;
        int n = hSegment.v();
        boolean bl = false;
        boolean bl2 = false;
        float f4 = hSegment.c(this.c);
        float f5 = hSegment.n();
        if (hSegment.h()) {
            hSegment.j();
            f3 = hSegment.c(this.c);
            bl = true;
        } else if (n == -1) {
            f3 = f2;
            bl2 = true;
        } else {
            f3 = fArray[n];
        }
        this.a(hSegment, true, f, f3, f5, f4, bl);
        return bl2;
    }

    private boolean b(HSegment hSegment, float f, float f2, float[] fArray) {
        float f3;
        int n = hSegment.w();
        boolean bl = false;
        boolean bl2 = false;
        float f4 = hSegment.d(this.c);
        float f5 = hSegment.n();
        if (hSegment.i()) {
            hSegment.k();
            f3 = hSegment.d(this.c);
            bl = true;
        } else if (n == -1) {
            f3 = f2;
            bl2 = true;
        } else {
            f3 = fArray[n];
        }
        this.a(hSegment, false, f, f3, f5, f4, bl);
        return bl2;
    }

    private void a(HSegment hSegment, boolean bl, float f, float f2, float f3, float f4, boolean bl2) {
        HNode hNode;
        HNode hNode2;
        float[] fArray;
        HGraph hGraph = this.getGraph();
        HLink hLink = hSegment.e();
        if (bl) {
            fArray = hSegment.f();
            hNode2 = hSegment.a();
        } else {
            fArray = hSegment.g();
            hNode2 = hSegment.b();
        }
        if (hLink.ae()) {
            HNode hNode3 = this.a(hNode2, hSegment);
            if (!hNode3.ah() && hNode3.u() && hNode3.ak() == -1) {
                hNode3.a(this.b, f3);
            }
            hNode = hLink.a(hSegment, hGraph);
            HNode hNode4 = hLink.a(hSegment, hGraph);
            if (hSegment.aa() == bl) {
                HNode hNode5 = hNode;
                hNode = hNode4;
                hNode4 = hNode5;
            }
            hNode4.a(this.b, f3);
            hNode4.a(this.c, f2);
        } else {
            hNode = hLink.a(hSegment, hGraph);
        }
        hNode.a(this.b, f3);
        hNode.a(this.c, f4);
        if (!bl2) {
            fArray[this.b] = f;
            fArray[this.c] = f2;
        }
    }

    public final void calcNorthSouthPortConnectors() {
        HNodeIterator hNodeIterator = this.getGraph().aa();
        while (hNodeIterator.hasNext()) {
            this.b(hNodeIterator.next());
            this.c().addPoints(1);
            this.e();
        }
    }

    private final void b(HNode hNode) {
        float[] fArray;
        int n;
        HSegment hSegment;
        HSegmentIterator hSegmentIterator;
        float f;
        float[] fArray2;
        if (hNode.u()) {
            return;
        }
        if (hNode.az()) {
            return;
        }
        hNode.a5();
        float f2 = hNode.c(this.b);
        float f3 = hNode.a(this.b);
        int n2 = hNode.u(2);
        if (n2 >= 0) {
            fArray2 = new float[n2];
            this.a(hNode, fArray2, f3, f2, true, false);
            f = hNode.a(this.c) + hNode.c(this.c);
            hSegmentIterator = hNode.a(true, true, false, false);
            while (hSegmentIterator.hasNext()) {
                hSegment = hSegmentIterator.next();
                n = hSegment.v();
                if (n == -1) continue;
                fArray = hSegment.f();
                fArray[this.b] = fArray2[n];
                fArray[this.c] = f;
            }
            fArray2 = null;
        }
        if ((n2 = hNode.u(0)) >= 0) {
            fArray2 = new float[n2];
            this.a(hNode, fArray2, f3, f2, false, true);
            f = hNode.a(this.c);
            hSegmentIterator = hNode.b(true, true, false, false);
            while (hSegmentIterator.hasNext()) {
                hSegment = hSegmentIterator.next();
                n = hSegment.w();
                if (n == -1) continue;
                fArray = hSegment.g();
                fArray[this.b] = fArray2[n];
                fArray[this.c] = f;
            }
            fArray2 = null;
        }
    }

    private final void c(HNode hNode) {
        hNode.a5();
        if (hNode.u(2) == 0 && hNode.u(0) == 0) {
            this.a(hNode, false);
            return;
        }
        float f = hNode.c(this.b);
        float f2 = hNode.a(this.b);
        float f3 = this.a(hNode, f, true, true, true);
        HSegmentIterator hSegmentIterator = hNode.n();
        HSegmentIterator hSegmentIterator2 = hNode.o();
        float f4 = f2 + f3;
        float f5 = hNode.a(this.c);
        float f6 = f5 + hNode.c(this.c);
        while (hSegmentIterator.hasNext() || hSegmentIterator2.hasNext()) {
            float[] fArray;
            float f7;
            HSegment hSegment;
            if (hSegmentIterator.hasNext()) {
                hSegment = hSegmentIterator.next();
                f7 = hSegment.e().w();
                fArray = hSegment.f();
                fArray[this.b] = f4 + 0.5f * f7;
                fArray[this.c] = f6;
                f4 += f3 + f7;
            }
            if (!hSegmentIterator2.hasNext()) continue;
            hSegment = hSegmentIterator2.next();
            f7 = hSegment.e().w();
            fArray = hSegment.g();
            fArray[this.b] = f4 + 0.5f * f7;
            fArray[this.c] = f5;
            f4 += f3 + f7;
        }
    }

    private final void a(HNode hNode, float[] fArray, float f, float f2, boolean bl, boolean bl2) {
        HSegmentIterator hSegmentIterator;
        int n;
        int n2 = fArray.length;
        for (n = 0; n < n2; ++n) {
            fArray[n] = 0.0f;
        }
        HSegmentIterator hSegmentIterator2 = bl ? (bl2 ? hNode.c(true, true, false, false) : hNode.a(true, true, false, false)) : (hSegmentIterator = hNode.b(true, true, false, false));
        while (hSegmentIterator.hasNext()) {
            HSegment hSegment = hSegmentIterator.next();
            int n3 = hSegment.a() == hNode ? hSegment.v() : hSegment.w();
            if (n3 == -1) continue;
            fArray[n3] = Math.max(hSegment.e().w(), fArray[n3]);
        }
        float f3 = 0.0f;
        for (n = 0; n < fArray.length; ++n) {
            f3 += fArray[n];
        }
        float f4 = Float.MAX_VALUE;
        float f5 = (f2 - f3) / (float)(n2 + 1);
        if ((double)f5 < 0.0) {
            f5 = f2 / (float)(n2 + 1);
            f4 = 0.0f;
        }
        float f6 = f + f5;
        for (n = 0; n < n2; ++n) {
            float f7 = fArray[n];
            if (f7 > f4) {
                f7 = f4;
            }
            fArray[n] = f6 + 0.5f * f7;
            f6 += f5 + f7;
        }
    }

    private void d(HNode hNode) {
        float f;
        HSegment hSegment;
        float[] fArray = new float[2];
        this.a(hNode, fArray);
        HSegmentIterator hSegmentIterator = hNode.a(true, true, false, false);
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            if (hSegment.v() != -1) {
                bl = true;
            }
            f = this.a(hSegment, fArray, true);
            hSegment.e(f);
            ++n;
        }
        hSegmentIterator = hNode.b(true, true, false, false);
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            if (hSegment.w() != -1) {
                bl = true;
            }
            f = this.a(hSegment, fArray, false);
            hSegment.e(f);
            ++n2;
        }
        if (bl) {
            this.a.a(hNode.a(true, true, false, false), hNode.b(true, true, false, false), n + n2, true);
            this.a.run();
            this.a.a(hNode.a(true, true, false, false), hNode.b(true, true, false, false), n + n2, false);
            this.a.run();
        } else {
            hSegmentIterator = hNode.a(true, true, false, false);
            this.a.a(hSegmentIterator, n, true);
            this.a.run();
            hSegmentIterator = hNode.b(true, true, false, false);
            this.a.a(hSegmentIterator, n2, false);
            this.a.run();
        }
    }

    private float a(HSegment hSegment, float[] fArray, boolean bl) {
        HNode hNode;
        float f;
        int n = this.b;
        if (bl) {
            f = hSegment.c(n);
            hNode = hSegment.a();
        } else {
            f = hSegment.d(n);
            hNode = hSegment.b();
        }
        HLink hLink = hSegment.e();
        if (hLink.ab().getOwnerGraph() == hLink.ac().getOwnerGraph() && hLink.ab().ak() == hLink.ac().ak()) {
            return f;
        }
        HNode hNode2 = this.a(hNode, hSegment);
        if (hNode2.ah()) {
            return f;
        }
        float f2 = this.b();
        if (hLink.ae() && hNode2.u() && hNode2.ak() == -1) {
            if ((hNode2 = this.a(hNode2, hNode2.d(this.g))).ah()) {
                return f;
            }
            f2 = this.b();
        }
        if (f2 >= fArray[0] && f2 <= fArray[1]) {
            return f2;
        }
        return f;
    }

    private final void a(HNode hNode, float[] fArray) {
        HNode hNode2;
        int n = this.b;
        HGraph hGraph = this.getGraph();
        fArray[0] = -3.4028235E38f;
        fArray[1] = Float.MAX_VALUE;
        int n2 = hNode.an();
        HLevel hLevel = hNode.al();
        if (n2 > 0) {
            hNode2 = hLevel.b(n2 - 1);
            fArray[0] = hNode2.az() ? 0.5f * (hNode2.a(n) + hNode2.c(n) + hNode.a(n) + hGraph.m(n)) : (hNode2.u() ? (hNode2.ah() ? hNode2.m(n) + hGraph.m(n) : hNode2.a(n) + hNode2.c(n) + hGraph.m(n)) : hNode2.a(n) + hNode2.c(n) + hGraph.l(n));
        }
        if (n2 < hLevel.h() - 1) {
            hNode2 = hLevel.b(n2 + 1);
            fArray[1] = hNode2.az() ? 0.5f * (hNode.a(n) + hNode.c(n) + hNode2.a(n) - hGraph.m(n)) : (hNode2.u() ? (hNode2.ah() ? hNode2.m(n) - hGraph.m(n) : hNode2.a(n) - hGraph.m(n)) : hNode2.a(n) - hGraph.l(n));
        }
    }

    HNode a(HNode hNode, HSegment hSegment) {
        hNode = hSegment.a(hNode);
        while (hNode.ah() && hNode.ak() == -1) {
            hSegment = hNode.d(hSegment);
            hNode = hSegment.a(hNode);
        }
        this.f = hNode;
        this.g = hSegment;
        return hNode;
    }

    float b() {
        float f = this.g.a() == this.f ? this.g.c(this.b) : this.g.d(this.b);
        HGraph hGraph = this.getGraph();
        return hGraph.a(this.f, f, this.b);
    }
}

