/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.grid;

import ilog.views.IlvGraphic;
import ilog.views.IlvNamedProperty;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutNodeProperty;
import ilog.views.graphlayout.IlvGrapherAdapter;
import ilog.views.graphlayout.grid.IlvGridLayout;
import ilog.views.graphlayout.internalutil.AlignmentOptions;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;

public class IlvGridLayoutNodeProperty
extends IlvGraphLayoutNodeProperty {
    static final long serialVersionUID = 2272851156909189612L;
    private int a;
    private int b;

    public IlvGridLayoutNodeProperty(String string, IlvGridLayout ilvGridLayout, IlvGraphic ilvGraphic, boolean bl) {
        super(string, ilvGridLayout, ilvGraphic, bl);
        try {
            this.a = ilvGridLayout.getHorizontalAlignment(ilvGraphic);
        }
        catch (Exception exception) {
            this.a = 0;
        }
        try {
            this.b = ilvGridLayout.getVerticalAlignment(ilvGraphic);
        }
        catch (Exception exception) {
            this.b = 0;
        }
    }

    public IlvGridLayoutNodeProperty(IlvGridLayoutNodeProperty ilvGridLayoutNodeProperty) {
        super(ilvGridLayoutNodeProperty);
        this.a = ilvGridLayoutNodeProperty.a;
        this.b = ilvGridLayoutNodeProperty.b;
    }

    public IlvGridLayoutNodeProperty(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        super(ilvInputStream);
        try {
            this.a = AlignmentOptions.valueOf(ilvInputStream.readString("horizontalAlignment"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.a = 0;
        }
        try {
            this.b = AlignmentOptions.valueOf(ilvInputStream.readString("verticalAlignment"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.b = 0;
        }
    }

    public IlvNamedProperty copy() {
        return new IlvGridLayoutNodeProperty(this);
    }

    public boolean isPersistent() {
        if (super.isPersistent()) {
            return true;
        }
        if (this.a != 0) {
            return true;
        }
        return this.b != 0;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        block7: {
            block6: {
                block5: {
                    block4: {
                        super.write(ilvOutputStream);
                        if (this.a != 0) break block4;
                        if (this.omitDefaults()) break block5;
                    }
                    ilvOutputStream.write("horizontalAlignment", AlignmentOptions.toString(this.a));
                }
                if (this.b != 0) break block6;
                if (this.omitDefaults()) break block7;
            }
            ilvOutputStream.write("verticalAlignment", AlignmentOptions.toString(this.b));
        }
    }

    public void transfer(IlvGraphLayout ilvGraphLayout, IlvGraphic ilvGraphic) {
        if (ilvGraphLayout == null) {
            return;
        }
        super.transfer(ilvGraphLayout, ilvGraphic);
        IlvGridLayout ilvGridLayout = (IlvGridLayout)ilvGraphLayout;
        try {
            ilvGridLayout.setHorizontalAlignment(ilvGraphic, this.a);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ilvGridLayout.setVerticalAlignment(ilvGraphic, this.b);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose(IlvGrapherAdapter ilvGrapherAdapter) {
        super.dispose(ilvGrapherAdapter);
    }
}

