/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.bpmn;

import ilog.views.bpmn.IlvBPMNUtilities;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.renderer.IlvLaneRenderer;
import java.util.ArrayList;
import java.util.Enumeration;

public class IlvBPMNFlowValidator {
    public static FlowRule notSameNode = new FlowRule(){

        public boolean isValidTarget(IlvSDMEngine ilvSDMEngine, Object object, Object object2, Object object3) {
            return object2 != object3;
        }
    };
    public static FlowRule noArtifact = new FlowRule(){

        public boolean isValidSource(IlvSDMEngine ilvSDMEngine, Object object, Object object2) {
            IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
            return !IlvBPMNUtilities.isArtifact(ilvSDMModel, object2) && !IlvBPMNUtilities.isAssociation(ilvSDMModel, object2);
        }

        public boolean isValidTarget(IlvSDMEngine ilvSDMEngine, Object object, Object object2, Object object3) {
            IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
            return !IlvBPMNUtilities.isArtifact(ilvSDMModel, object3) && !IlvBPMNUtilities.isAssociation(ilvSDMModel, object3);
        }
    };
    public static FlowRule noLane = new FlowRule(){

        public boolean isValidSource(IlvSDMEngine ilvSDMEngine, Object object, Object object2) {
            return !IlvBPMNUtilities.isLane(ilvSDMEngine.getModel(), object2);
        }

        public boolean isValidTarget(IlvSDMEngine ilvSDMEngine, Object object, Object object2, Object object3) {
            return !IlvBPMNUtilities.isLane(ilvSDMEngine.getModel(), object3);
        }
    };
    public static FlowRule noPoolForSequenceFlow = new FlowRule(){

        public boolean isValidSource(IlvSDMEngine ilvSDMEngine, Object object, Object object2) {
            IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
            return !IlvBPMNUtilities.isPool(ilvSDMModel, object2) || IlvBPMNUtilities.isMessageFlow(ilvSDMModel, object);
        }

        public boolean isValidTarget(IlvSDMEngine ilvSDMEngine, Object object, Object object2, Object object3) {
            IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
            return !IlvBPMNUtilities.isPool(ilvSDMModel, object3) || IlvBPMNUtilities.isMessageFlow(ilvSDMModel, object);
        }
    };
    public static FlowRule noGatewayForMessageFlow = new FlowRule(){

        public boolean isValidSource(IlvSDMEngine ilvSDMEngine, Object object, Object object2) {
            IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
            return !IlvBPMNUtilities.isGateway(ilvSDMModel, object2) || !IlvBPMNUtilities.isMessageFlow(ilvSDMModel, object);
        }

        public boolean isValidTarget(IlvSDMEngine ilvSDMEngine, Object object, Object object2, Object object3) {
            IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
            return !IlvBPMNUtilities.isGateway(ilvSDMModel, object3) || !IlvBPMNUtilities.isMessageFlow(ilvSDMModel, object);
        }
    };
    public static FlowRule noEndEventSourceOfSequenceFlow = new FlowRule(){

        public boolean isValidSource(IlvSDMEngine ilvSDMEngine, Object object, Object object2) {
            IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
            return !IlvBPMNUtilities.isEndEvent(ilvSDMModel, object2) || IlvBPMNUtilities.isMessageFlow(ilvSDMModel, object);
        }
    };
    public static FlowRule noStartEventSourceOfMessageFlow = new FlowRule(){

        public boolean isValidSource(IlvSDMEngine ilvSDMEngine, Object object, Object object2) {
            IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
            return !IlvBPMNUtilities.isMessageFlow(ilvSDMModel, object) || !IlvBPMNUtilities.isStartEvent(ilvSDMModel, object2);
        }
    };
    public static FlowRule sourceForOnlyOneDefaultFlow = new FlowRule(){

        public boolean isValidSource(IlvSDMEngine ilvSDMEngine, Object object, Object object2) {
            IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
            return !IlvBPMNUtilities.isDefaultFlow(ilvSDMModel, object) || !IlvBPMNFlowValidator.d(ilvSDMModel, object2);
        }
    };
    public static FlowRule samePoolForSequenceFlow = new FlowRule(){

        public boolean isValidTarget(IlvSDMEngine ilvSDMEngine, Object object, Object object2, Object object3) {
            IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
            return IlvBPMNUtilities.isMessageFlow(ilvSDMModel, object) || IlvBPMNFlowValidator.areInSamePool(ilvSDMEngine, object2, object3);
        }
    };
    public static FlowRule sameSubProcessForSequenceFlow = new FlowRule(){

        public boolean isValidTarget(IlvSDMEngine ilvSDMEngine, Object object, Object object2, Object object3) {
            IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
            if (!IlvBPMNUtilities.isMessageFlow(ilvSDMModel, object)) {
                Object object4;
                Object object5 = ilvSDMModel.getParent(object2);
                if (object5 == (object4 = ilvSDMModel.getParent(object3))) {
                    return true;
                }
                if (IlvBPMNUtilities.isInterruptIntermediate(ilvSDMModel, object2)) {
                    object5 = ilvSDMModel.getParent(object5);
                }
                if (IlvBPMNUtilities.isInterruptIntermediate(ilvSDMModel, object3)) {
                    object4 = ilvSDMModel.getParent(object4);
                }
                return object5 == object4;
            }
            return true;
        }
    };
    public static FlowRule noStartEventTargetOfSequenceFlow = new FlowRule(){

        public boolean isValidTarget(IlvSDMEngine ilvSDMEngine, Object object, Object object2, Object object3) {
            IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
            return IlvBPMNUtilities.isMessageFlow(ilvSDMModel, object) || !IlvBPMNUtilities.isStartEvent(ilvSDMModel, object3);
        }
    };
    public static FlowRule noEndEventTargetOfMessageFlow = new FlowRule(){

        public boolean isValidTarget(IlvSDMEngine ilvSDMEngine, Object object, Object object2, Object object3) {
            IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
            return !IlvBPMNUtilities.isMessageFlow(ilvSDMModel, object) || !IlvBPMNUtilities.isEndEvent(ilvSDMModel, object3);
        }
    };
    public static FlowRule noSameLaneForMessageFlow = new FlowRule(){

        public boolean isValidTarget(IlvSDMEngine ilvSDMEngine, Object object, Object object2, Object object3) {
            IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
            return !IlvBPMNUtilities.isMessageFlow(ilvSDMModel, object) || !IlvBPMNFlowValidator.areInSameLane(ilvSDMEngine, object2, object3) || IlvBPMNUtilities.isPool(ilvSDMModel, object2) || IlvBPMNUtilities.isPool(ilvSDMModel, object3);
        }
    };
    public static FlowRule noSamePoolForMessageFlow = new FlowRule(){

        public boolean isValidTarget(IlvSDMEngine ilvSDMEngine, Object object, Object object2, Object object3) {
            IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
            return !IlvBPMNUtilities.isMessageFlow(ilvSDMModel, object) || !IlvBPMNFlowValidator.areInSamePool(ilvSDMEngine, object2, object3) || IlvBPMNUtilities.isPool(ilvSDMModel, object2) || IlvBPMNUtilities.isPool(ilvSDMModel, object3);
        }
    };
    public static FlowRule compensationAssociation = new FlowRule(){

        public boolean isValidSource(IlvSDMEngine ilvSDMEngine, Object object, Object object2) {
            IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
            return !(IlvBPMNUtilities.h(ilvSDMModel, object) ? !IlvBPMNUtilities.f(ilvSDMModel, object2) && !IlvBPMNUtilities.g(ilvSDMModel, object2) || IlvBPMNFlowValidator.e(ilvSDMModel, object2) : IlvBPMNUtilities.f(ilvSDMModel, object2) || IlvBPMNUtilities.e(ilvSDMModel, object2));
        }

        public boolean isValidTarget(IlvSDMEngine ilvSDMEngine, Object object, Object object2, Object object3) {
            IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
            return !(IlvBPMNUtilities.h(ilvSDMModel, object) ? !IlvBPMNUtilities.e(ilvSDMModel, object3) : IlvBPMNUtilities.f(ilvSDMModel, object3) || IlvBPMNUtilities.e(ilvSDMModel, object3));
        }
    };
    static int a = 1;
    public static FlowRule interruptIntermediateTarget = new FlowRule(){

        public boolean isValidTarget(IlvSDMEngine ilvSDMEngine, Object object, Object object2, Object object3) {
            return !IlvBPMNUtilities.isInterruptIntermediate(ilvSDMEngine.getModel(), object3);
        }
    };
    private static final String b = "Lane";
    ArrayList c = new ArrayList();

    public IlvBPMNFlowValidator() {
        this.addRule(notSameNode);
        this.addRule(noArtifact);
        this.addRule(noLane);
        this.addRule(noPoolForSequenceFlow);
        this.addRule(sourceForOnlyOneDefaultFlow);
        this.addRule(noEndEventSourceOfSequenceFlow);
        this.addRule(noStartEventSourceOfMessageFlow);
        this.addRule(noGatewayForMessageFlow);
        this.addRule(samePoolForSequenceFlow);
        this.addRule(sameSubProcessForSequenceFlow);
        this.addRule(noStartEventTargetOfSequenceFlow);
        this.addRule(noEndEventTargetOfMessageFlow);
        this.addRule(noSamePoolForMessageFlow);
        this.addRule(compensationAssociation);
        this.addRule(interruptIntermediateTarget);
    }

    public void addRule(FlowRule flowRule) {
        if (this.c.indexOf(flowRule) == -1) {
            this.c.add(flowRule);
        }
    }

    public void insertRule(int n, FlowRule flowRule) {
        if (this.c.indexOf(flowRule) == -1) {
            this.c.add(n, flowRule);
        }
    }

    public void removeRule(FlowRule flowRule) {
        this.c.remove(flowRule);
    }

    public int getRuleCount() {
        return this.c.size();
    }

    public FlowRule getRule(int n) {
        return (FlowRule)this.c.get(n);
    }

    public boolean isValidSource(IlvSDMEngine ilvSDMEngine, Object object, Object object2) {
        if (ilvSDMEngine.getModel().isLink(object2)) {
            return false;
        }
        for (int i = 0; i < this.getRuleCount(); ++i) {
            if (this.getRule(i).isValidSource(ilvSDMEngine, object, object2)) continue;
            return false;
        }
        return true;
    }

    public boolean isValidTarget(IlvSDMEngine ilvSDMEngine, Object object, Object object2, Object object3) {
        if (ilvSDMEngine.getModel().isLink(object3)) {
            return false;
        }
        for (int i = 0; i < this.getRuleCount(); ++i) {
            if (this.getRule(i).isValidTarget(ilvSDMEngine, object, object2, object3)) continue;
            return false;
        }
        return true;
    }

    public static boolean areInSameLane(IlvSDMEngine ilvSDMEngine, Object object, Object object2) {
        IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
        return ilvSDMModel.getObjectProperty(object, b) == ilvSDMModel.getObjectProperty(object2, b);
    }

    public static boolean areInSamePool(IlvSDMEngine ilvSDMEngine, Object object, Object object2) {
        Object object3;
        IlvLaneRenderer ilvLaneRenderer = IlvLaneRenderer.getInstance(ilvSDMEngine);
        IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
        Object object4 = IlvBPMNFlowValidator.a(ilvSDMModel, ilvLaneRenderer, object);
        return object4 == (object3 = IlvBPMNFlowValidator.a(ilvSDMModel, ilvLaneRenderer, object2));
    }

    private static Object a(IlvSDMModel ilvSDMModel, IlvLaneRenderer ilvLaneRenderer, Object object) {
        Object object2 = IlvBPMNFlowValidator.b(ilvSDMModel, ilvLaneRenderer, object);
        if (object2 != null) {
            if (IlvBPMNUtilities.isPool(ilvSDMModel, object2)) {
                return object2;
            }
            return IlvBPMNFlowValidator.a(ilvSDMModel, ilvLaneRenderer, object2);
        }
        return null;
    }

    private static Object b(IlvSDMModel ilvSDMModel, IlvLaneRenderer ilvLaneRenderer, Object object) {
        String string = IlvBPMNFlowValidator.c(ilvSDMModel, object);
        if (string != null) {
            return ilvLaneRenderer.getLaneNode(string);
        }
        return null;
    }

    private static String c(IlvSDMModel ilvSDMModel, Object object) {
        Object object2 = ilvSDMModel.getObjectProperty(object, b);
        if (object2 != null) {
            return object2.toString();
        }
        if ((object = ilvSDMModel.getParent(object)) != null) {
            return IlvBPMNFlowValidator.c(ilvSDMModel, object);
        }
        return null;
    }

    private static boolean d(IlvSDMModel ilvSDMModel, Object object) {
        Enumeration enumeration = ilvSDMModel.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!IlvBPMNUtilities.isDefaultFlow(ilvSDMModel, e) || ilvSDMModel.getFrom(e) != object) continue;
            return true;
        }
        return false;
    }

    private static boolean e(IlvSDMModel ilvSDMModel, Object object) {
        Enumeration enumeration = ilvSDMModel.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!ilvSDMModel.isLink(e) || ilvSDMModel.getFrom(e) != object) continue;
            return true;
        }
        return false;
    }

    public static abstract class FlowRule {
        protected FlowRule() {
        }

        public boolean isValidSource(IlvSDMEngine ilvSDMEngine, Object object, Object object2) {
            return true;
        }

        public boolean isValidTarget(IlvSDMEngine ilvSDMEngine, Object object, Object object2, Object object3) {
            return true;
        }
    }
}

